/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.standalone;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.standalone.ChildVM;
import org.apache.geode.test.dunit.standalone.DUnitLauncher;
import org.apache.geode.test.dunit.standalone.RemoteDUnitVMIF;
import org.apache.geode.test.dunit.standalone.VersionManager;

public class ProcessManager {
    private int namingPort;
    private Map<Integer, ProcessHolder> processes = new HashMap<Integer, ProcessHolder>();
    private File log4jConfig;
    private int pendingVMs;
    private Registry registry;
    private int debugPort = Integer.getInteger("dunit.debug.basePort", 0);
    private int suspendVM = Integer.getInteger("dunit.debug.suspendVM", -100);
    private VersionManager versionManager = VersionManager.getInstance();

    public ProcessManager(int namingPort, Registry registry) {
        this.namingPort = namingPort;
        this.registry = registry;
    }

    public synchronized void launchVM(int vmNum) throws IOException {
        this.launchVM("000", vmNum, false);
    }

    public synchronized void launchVM(String version, int vmNum, boolean bouncedVM) throws IOException {
        if (this.processes.containsKey(vmNum)) {
            throw new IllegalStateException("VM " + vmNum + " is already running.");
        }
        File workingDir = ProcessManager.getVMDir(version, vmNum);
        if (!workingDir.exists()) {
            workingDir.mkdirs();
        } else if (!bouncedVM || DUnitLauncher.MAKE_NEW_WORKING_DIRS) {
            try {
                FileUtils.deleteDirectory((File)workingDir);
            }
            catch (IOException e) {
                System.err.println("Unable to delete " + workingDir + ". Currently contains " + Arrays.asList(workingDir.list()));
            }
            workingDir.mkdirs();
        }
        Object[] cmd = this.buildJavaCommand(vmNum, this.namingPort, version);
        System.out.println("Executing " + Arrays.toString(cmd));
        if (this.log4jConfig != null) {
            FileUtils.copyFileToDirectory((File)this.log4jConfig, (File)workingDir);
        }
        try {
            Process process = Runtime.getRuntime().exec((String[])cmd, null, workingDir);
            ++this.pendingVMs;
            ProcessHolder holder = new ProcessHolder(process);
            this.processes.put(vmNum, holder);
            this.linkStreams(version, vmNum, holder, process.getErrorStream(), System.err);
            this.linkStreams(version, vmNum, holder, process.getInputStream(), System.out);
        }
        catch (Error | RuntimeException t) {
            t.printStackTrace();
            throw t;
        }
    }

    public void validateVersion(String version) {
        if (!this.versionManager.isValidVersion(version)) {
            throw new IllegalArgumentException("Version " + version + " is not configured for use");
        }
    }

    public static File getVMDir(String version, int vmNum) {
        return new File("dunit", VM.getVMName("000", vmNum));
    }

    public synchronized void killVMs() {
        for (ProcessHolder process : this.processes.values()) {
            if (process == null) continue;
            process.kill();
        }
    }

    public synchronized boolean hasLiveVMs() {
        for (ProcessHolder process : this.processes.values()) {
            if (process == null || !process.isAlive()) continue;
            return true;
        }
        return false;
    }

    public synchronized void bounce(String version, int vmNum, boolean force) {
        if (!this.processes.containsKey(vmNum)) {
            throw new IllegalStateException("No such process " + vmNum);
        }
        try {
            ProcessHolder holder = this.processes.remove(vmNum);
            if (force) {
                holder.killForcibly();
            } else {
                holder.kill();
            }
            holder.getProcess().waitFor();
            System.out.println("Old process for vm_" + vmNum + " has exited");
            this.launchVM(version, vmNum, true);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to restart VM " + vmNum, e);
        }
    }

    private void linkStreams(String version, int vmNum, final ProcessHolder holder, final InputStream in, final PrintStream out) {
        final String vmName = "[" + VM.getVMName(version, vmNum) + "] ";
        System.out.println("linking IO streams for " + vmName);
        Thread ioTransport = new Thread(){

            @Override
            public void run() {
                block5: {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            if (line.length() == 0) {
                                out.println();
                            } else {
                                out.print(vmName);
                                out.println(line);
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (Exception e) {
                        if (holder.isKilled()) break block5;
                        out.println("Error transporting IO from child process");
                        e.printStackTrace(out);
                    }
                }
            }
        };
        ioTransport.setDaemon(true);
        ioTransport.start();
    }

    private String[] buildJavaCommand(int vmNum, int namingPort, String version) {
        String classPath;
        String cmd = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String dunitClasspath = System.getProperty("java.class.path");
        String separator = File.separator;
        if (VersionManager.isCurrentVersion((String)version)) {
            classPath = dunitClasspath;
        } else {
            String buildDir = separator + "geode-core" + separator + "build" + separator;
            String mainClasses = buildDir + "classes" + separator + "main";
            dunitClasspath = this.removeFromPath(dunitClasspath, mainClasses);
            dunitClasspath = this.removeFromPath(dunitClasspath, "geode-core/out/production");
            String mainResources = buildDir + "resources" + separator + "main";
            dunitClasspath = this.removeFromPath(dunitClasspath, mainResources);
            String generatedResources = buildDir + "generated-resources" + separator + "main";
            dunitClasspath = this.removeFromPath(dunitClasspath, generatedResources);
            buildDir = separator + "geode-common" + separator + "build" + separator + "classes" + separator + "main";
            dunitClasspath = this.removeFromPath(dunitClasspath, buildDir);
            buildDir = separator + "geode-json" + separator + "build" + separator + "classes" + separator + "main";
            dunitClasspath = this.removeFromPath(dunitClasspath, buildDir);
            classPath = this.versionManager.getClasspath(version) + File.pathSeparator + dunitClasspath;
        }
        String agent = this.getAgentString();
        String jdkDebug = "";
        if (this.debugPort > 0) {
            jdkDebug = jdkDebug + ",address=" + this.debugPort;
            ++this.debugPort;
        }
        String jdkSuspend = vmNum == this.suspendVM ? "y" : "n";
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(cmd);
        cmds.add("-classpath");
        String jreLib = separator + "jre" + separator + "lib" + separator;
        classPath = this.removeFromPath(classPath, jreLib);
        cmds.add(classPath);
        cmds.add("-Dgemfire.DUnitLauncher.RMI_PORT=" + namingPort);
        cmds.add("-Dgemfire.DUnitLauncher.VM_NUM=" + vmNum);
        cmds.add("-Dgemfire.DUnitLauncher.VM_VERSION=" + version);
        cmds.add("-DWORKSPACE_DIR=" + new File(".").getAbsolutePath());
        if (vmNum >= 0) {
            if (version.equals("000")) {
                cmds.add("-DLocator.inhibitDMBanner=true");
            }
        } else {
            cmds.add("-Dgemfire.enable-network-partition-detection=false");
            cmds.add("-Dgemfire.allow_old_members_to_join_for_testing=true");
        }
        cmds.add("-Dlog-level=" + DUnitLauncher.logLevel);
        if (DUnitLauncher.LOG4J != null) {
            cmds.add("-Dlog4j.configurationFile=" + DUnitLauncher.LOG4J);
        }
        cmds.add("-Djava.library.path=" + System.getProperty("java.library.path"));
        cmds.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=" + jdkSuspend + jdkDebug);
        cmds.add("-XX:+HeapDumpOnOutOfMemoryError");
        cmds.add("-Xmx512m");
        cmds.add("-Dgemfire.DEFAULT_MAX_OPLOG_SIZE=10");
        cmds.add("-Dgemfire.disallowMcastDefaults=true");
        cmds.add("-Dgemfire.use-ephemeral-ports=true");
        cmds.add("-Dgemfire.validate-serializable-objects=true");
        cmds.add("-ea");
        cmds.add("-XX:MetaspaceSize=512m");
        cmds.add(agent);
        cmds.add(ChildVM.class.getName());
        String[] rst = new String[cmds.size()];
        cmds.toArray(rst);
        return rst;
    }

    private String removeFromPath(String classpath, String partialPath) {
        String[] jars = classpath.split(File.pathSeparator);
        StringBuilder sb = new StringBuilder(classpath.length());
        Boolean firstjar = true;
        for (String jar : jars) {
            if (jar.contains(partialPath)) continue;
            if (!firstjar.booleanValue()) {
                sb.append(File.pathSeparator);
            }
            sb.append(jar);
            firstjar = false;
        }
        return sb.toString();
    }

    private String getAgentString() {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeBean != null) {
            for (String arg : runtimeBean.getInputArguments()) {
                if (!arg.contains("-javaagent:")) continue;
                arg = arg.replace("-javaagent:..", "-javaagent:" + System.getProperty("user.dir") + File.separator + "..");
                arg = arg.replace("destfile=..", "destfile=" + System.getProperty("user.dir") + File.separator + "..");
                return arg;
            }
        }
        return "-DdummyArg=true";
    }

    synchronized void signalVMReady() {
        --this.pendingVMs;
        this.notifyAll();
    }

    public synchronized boolean waitForVMs(long timeout) throws InterruptedException {
        long end = System.currentTimeMillis() + timeout;
        while (this.pendingVMs > 0) {
            long remaining = end - System.currentTimeMillis();
            if (remaining <= 0L) {
                return false;
            }
            this.wait(remaining);
        }
        return true;
    }

    public RemoteDUnitVMIF getStub(int i) throws AccessException, RemoteException, NotBoundException, InterruptedException {
        return this.getStub("000", i);
    }

    public RemoteDUnitVMIF getStub(String version, int i) throws AccessException, RemoteException, NotBoundException, InterruptedException {
        this.waitForVMs(120000L);
        return (RemoteDUnitVMIF)this.registry.lookup("vm" + i);
    }

    private static class VersionedVMNumber {
        String version;
        int number;

        VersionedVMNumber(String version, int number) {
            this.version = version;
            this.number = number;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionedVMNumber that = (VersionedVMNumber)o;
            if (this.number != that.number) {
                return false;
            }
            return this.version.equals(that.version);
        }

        public int hashCode() {
            int result = this.version.hashCode();
            result = 31 * result + this.number;
            return result;
        }
    }

    public static class ProcessHolder {
        private final Process process;
        private volatile boolean killed = false;

        public ProcessHolder(Process process) {
            this.process = process;
        }

        public void kill() {
            this.killed = true;
            this.process.destroy();
        }

        public void killForcibly() {
            this.killed = true;
            this.process.destroyForcibly();
        }

        public Process getProcess() {
            return this.process;
        }

        public boolean isKilled() {
            return this.killed;
        }

        public boolean isAlive() {
            return !this.killed && this.process.isAlive();
        }
    }
}

