/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.RemoteInvoker;
import org.apache.geode.test.dunit.standalone.DUnitLauncher;
import org.apache.geode.test.junit.rules.serializable.SerializableStatement;
import org.apache.geode.test.junit.rules.serializable.SerializableTestRule;
import org.assertj.core.api.Assertions;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

class AbstractDistributedRule
implements SerializableTestRule {
    private final int vmCount;
    private final RemoteInvoker invoker;
    private volatile int beforeVmCount;

    protected AbstractDistributedRule() {
        this(VM.DEFAULT_VM_COUNT);
    }

    protected AbstractDistributedRule(int vmCount) {
        this(vmCount, new RemoteInvoker());
    }

    protected AbstractDistributedRule(int vmCount, RemoteInvoker invoker) {
        this.vmCount = vmCount;
        this.invoker = invoker;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new SerializableStatement(){

            public void evaluate() throws Throwable {
                AbstractDistributedRule.this.beforeDistributedTest();
                AbstractDistributedRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    AbstractDistributedRule.this.after();
                    AbstractDistributedRule.this.afterDistributedTest();
                }
            }
        };
    }

    private void beforeDistributedTest() throws Throwable {
        DUnitLauncher.launchIfNeeded(this.vmCount);
        this.beforeVmCount = VM.getVMCount();
    }

    private void afterDistributedTest() throws Throwable {
        int afterVmCount = VM.getVMCount();
        Assertions.assertThat((int)afterVmCount).isEqualTo(this.beforeVmCount);
    }

    protected void before() throws Throwable {
    }

    protected void after() throws Throwable {
    }

    protected RemoteInvoker invoker() {
        return this.invoker;
    }

    protected int vmCount() {
        return this.vmCount;
    }
}

