/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.concurrent.FileBasedCountDownLatch;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.MemberStarterRule;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ShowDeadlockDistributedTestBase {
    private static Thread stuckThread;
    private static final ReentrantLock LOCK;
    protected MemberVM locator;
    private MemberVM server1;
    private MemberVM server2;
    private File outputFile;
    private String showDeadlockCommand;
    @Rule
    public ClusterStartupRule lsRule = new ClusterStartupRule();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public GfshCommandRule gfsh = new GfshCommandRule();

    @Before
    public void setup() throws Exception {
        this.outputFile = new File(this.temporaryFolder.getRoot(), "dependency.txt").getAbsoluteFile();
        this.showDeadlockCommand = "show dead-locks --file=" + this.outputFile.getAbsolutePath();
        this.outputFile.delete();
        this.locator = this.lsRule.startLocatorVM(0, MemberStarterRule::withHttpService);
        Properties props = new Properties();
        props.setProperty("serializable-object-filter", "org.apache.geode.management.internal.cli.commands.ShowDeadlock*");
        this.server1 = this.lsRule.startServerVM(1, props, this.locator.getPort());
        this.server2 = this.lsRule.startServerVM(2, props, this.locator.getPort());
        this.connect();
    }

    @After
    public final void interruptStuckThreads() throws Exception {
        this.server1.invoke(() -> {
            if (stuckThread != null) {
                stuckThread.interrupt();
            }
            stuckThread = null;
        });
        this.server2.invoke(() -> {
            if (stuckThread != null) {
                stuckThread.interrupt();
            }
            stuckThread = null;
        });
        this.server1.invoke(() -> GeodeAwaitility.await().until(() -> !LOCK.isLocked()));
        this.server2.invoke(() -> GeodeAwaitility.await().until(() -> !LOCK.isLocked()));
    }

    public void connect() throws Exception {
        this.gfsh.connectAndVerify(this.locator, new String[0]);
    }

    @Test
    public void testNoDeadlock() throws Exception {
        this.gfsh.executeAndAssertThat(this.showDeadlockCommand).statusIsSuccess();
        String commandOutput = this.gfsh.getGfshOutput();
        Assertions.assertThat((String)commandOutput).startsWith((CharSequence)"No deadlock was detected.");
        Assertions.assertThat((File)this.outputFile).exists();
    }

    @Test
    public void testDistributedDeadlockWithFunction() throws Exception {
        FileBasedCountDownLatch countDownLatch = new FileBasedCountDownLatch(2);
        this.lockTheLocks(this.server1, this.server2, countDownLatch);
        this.lockTheLocks(this.server2, this.server1, countDownLatch);
        GeodeAwaitility.await().untilAsserted(() -> {
            this.gfsh.executeAndAssertThat(this.showDeadlockCommand).statusIsSuccess();
            String commandOutput = this.gfsh.getGfshOutput();
            Assertions.assertThat((String)commandOutput).startsWith((CharSequence)"Deadlock detected.");
            Assertions.assertThat((File)this.outputFile).exists();
        });
    }

    private void lockTheLocks(MemberVM thisVM, MemberVM thatVM, FileBasedCountDownLatch countDownLatch) {
        thisVM.invokeAsync(() -> {
            LOCK.lock();
            countDownLatch.countDown();
            countDownLatch.await();
            ShowDeadlockDistributedTestBase.lockRemoteVM(thatVM);
            LOCK.unlock();
        });
    }

    private static void lockRemoteVM(MemberVM vmToLock) {
        InternalDistributedMember thatInternalMember = ShowDeadlockDistributedTestBase.getInternalDistributedMember(vmToLock);
        ResultCollector collector = FunctionService.onMember((DistributedMember)thatInternalMember).execute((Function)new LockFunction());
        collector.getResult();
    }

    private static InternalDistributedMember getInternalDistributedMember(MemberVM memberVM) {
        return (InternalDistributedMember)memberVM.getVM().invoke(() -> ClusterStartupRule.getCache().getInternalDistributedSystem().getDistributedMember());
    }

    static {
        LOCK = new ReentrantLock();
    }

    private static class LockFunction
    implements Function<Object> {
        private LockFunction() {
        }

        public void execute(FunctionContext<Object> context) {
            stuckThread = Thread.currentThread();
            try {
                LOCK.tryLock(5L, TimeUnit.MINUTES);
                LOCK.unlock();
            }
            catch (InterruptedException e) {
                if (LOCK.isHeldByCurrentThread()) {
                    LOCK.unlock();
                }
            }
            finally {
                context.getResultSender().lastResult(null);
            }
        }
    }
}

