/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.configuration.ConfigGroup;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.services.result.ServiceResult;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.assertj.core.api.Assertions;

public class ClusterConfig
implements Serializable {
    private final List<ConfigGroup> groups = new ArrayList<ConfigGroup>();

    public ClusterConfig(ConfigGroup ... configGroups) {
        Collections.addAll(this.groups, configGroups);
    }

    public Set<String> getMaxLogFileSizes() {
        if (this.groups.size() == 0) {
            return Collections.emptySet();
        }
        return this.groups.stream().map(ConfigGroup::getMaxLogFileSize).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public List<String> getJarNames() {
        return this.groups.stream().flatMap(configGroup -> configGroup.getJars().stream()).collect(Collectors.toList());
    }

    public List<String> getRegions() {
        return this.groups.stream().flatMap(configGroup -> configGroup.getRegions().stream()).collect(Collectors.toList());
    }

    public List<ConfigGroup> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public void verify(MemberVM memberVM) throws ClassNotFoundException {
        if (memberVM.isLocator()) {
            this.verifyLocator(memberVM);
        } else {
            this.verifyServer(memberVM);
        }
    }

    public void verifyLocator(MemberVM locatorVM) {
        Set expectedGroupConfigs = this.getGroups().stream().map(ConfigGroup::getName).collect(Collectors.toSet());
        locatorVM.invoke(() -> {
            InternalLocator internalLocator = ClusterStartupRule.getLocator();
            InternalConfigurationPersistenceService sc = internalLocator.getConfigurationPersistenceService();
            Set actualGroupConfigs = sc.getConfigurationRegion().keySet();
            Assertions.assertThat((Collection)actualGroupConfigs).isEqualTo((Object)expectedGroupConfigs);
            for (ConfigGroup configGroup : this.getGroups()) {
                Configuration config = sc.getConfiguration(configGroup.name);
                Assertions.assertThat((Collection)config.getJarNames()).isEqualTo((Object)configGroup.getJars());
                if (StringUtils.isNotBlank((CharSequence)configGroup.getMaxLogFileSize())) {
                    Properties props = config.getGemfireProperties();
                    Assertions.assertThat((String)props.getProperty("log-file-size-limit")).isEqualTo(configGroup.getMaxLogFileSize());
                }
                for (String regionName : configGroup.getRegions()) {
                    String regionXml = "<region name=\"" + regionName + "\"";
                    Assertions.assertThat((String)config.getCacheXmlContent()).contains(new CharSequence[]{regionXml});
                }
            }
        });
        File clusterConfigDir = new File(locatorVM.getWorkingDir(), "/cluster_config");
        for (ConfigGroup configGroup : this.getGroups()) {
            Set<String> actualFiles = ClusterConfig.toSetIgnoringHiddenFiles(new File(clusterConfigDir, configGroup.name).list());
            Set expectedFiles = configGroup.getAllJarFiles();
            Assertions.assertThat(actualFiles).isEqualTo((Object)expectedFiles);
        }
    }

    public void verifyServer(MemberVM serverVM) {
        Set expectedJarNames = this.getJarNames().stream().collect(Collectors.toSet());
        String[] actualJarFiles = serverVM.getWorkingDir().list((dir, filename) -> filename.contains(".jar"));
        Set actualJarNames = Stream.of(actualJarFiles).map(jar -> jar.replaceAll("\\.v\\d+\\.jar", ".jar")).collect(Collectors.toSet());
        Assertions.assertThat(expectedJarNames).isSubsetOf(actualJarNames);
        serverVM.invoke(() -> {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            for (String region : this.getRegions()) {
                Assertions.assertThat((Map)cache.getRegion(region)).isNotNull();
            }
            if (this.getMaxLogFileSizes().size() > 0) {
                Properties props = cache.getDistributedSystem().getProperties();
                Assertions.assertThat(this.getMaxLogFileSizes()).contains((Object[])new String[]{props.getProperty("log-file-size-limit")});
            }
            for (String fileName : this.getJarNames()) {
                ServiceResult serviceResult = ClassPathLoader.getLatest().getJarDeploymentService().getDeployed(fileName);
                Assertions.assertThat((boolean)serviceResult.isSuccessful()).isTrue();
                Deployment deployment = (Deployment)serviceResult.getMessage();
                Assertions.assertThat(Class.forName(ClusterConfig.nameOfClassContainedInJar(fileName), true, new URLClassLoader(new URL[]{deployment.getFile().toURI().toURL()}))).isNotNull();
            }
            HashSet undeployedJarNames = new HashSet(actualJarNames);
            undeployedJarNames.removeAll(expectedJarNames);
            for (String jar : undeployedJarNames) {
                System.out.println("Verifying undeployed jar: " + jar);
                ServiceResult serviceResult = ClassPathLoader.getLatest().getJarDeploymentService().getDeployed(jar);
                Assertions.assertThat((boolean)serviceResult.isFailure()).isTrue();
            }
        });
    }

    private static Set<String> toSetIgnoringHiddenFiles(String[] array) {
        if (array == null) {
            return new HashSet<String>();
        }
        return Arrays.stream(array).filter(name -> !name.startsWith(".")).collect(Collectors.toSet());
    }

    private static String nameOfClassContainedInJar(String jarName) {
        switch (jarName) {
            case "cluster.jar": {
                return "Cluster";
            }
            case "group1.jar": {
                return "Group1";
            }
            case "group2.jar": {
                return "Group2";
            }
        }
        throw new IllegalArgumentException("We don't know what class to expect in the jar named " + jarName);
    }
}

