/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.geode.SystemFailure;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.RMIException;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.AsyncThreadId;
import org.apache.geode.test.dunit.internal.IdentifiableCallable;
import org.apache.geode.test.dunit.internal.IdentifiableRunnable;
import org.apache.geode.test.dunit.internal.StackTrace;

public class AsyncInvocation<V>
implements Future<V> {
    private static final long DEFAULT_TIMEOUT_MILLIS = GeodeAwaitility.getTimeout().toMillis();
    private final Thread thread;
    private final AtomicReference<V> resultValue = new AtomicReference();
    private final AtomicReference<Throwable> resultThrowable = new AtomicReference();
    private final Object target;
    private final String methodName;
    private final Function<TimeoutException, TimeoutException> asyncTimeoutHandler;
    private boolean cancelled;

    public static <V> AsyncInvocation<V> create(IdentifiableRunnable target, Callable<V> work, VM vm) {
        return new AsyncInvocation<V>(target, target.getMethodName(), work, AsyncInvocation.asyncTimeoutHandler(vm, target.getId()));
    }

    public static <V> AsyncInvocation<V> create(IdentifiableCallable<V> target, Callable<V> work, VM vm) {
        return new AsyncInvocation<V>(target, target.getMethodName(), work, AsyncInvocation.asyncTimeoutHandler(vm, target.getId()));
    }

    public static <V> AsyncInvocation<V> create(Object target, String methodName, Callable<V> work, VM vm) {
        return new AsyncInvocation<V>(target, methodName, work, timeoutException -> timeoutException);
    }

    private AsyncInvocation(Object target, String methodName, Callable<V> work, Function<TimeoutException, TimeoutException> asyncTimeoutHandler) {
        this.target = target;
        this.methodName = methodName;
        this.thread = new Thread(new AsyncInvocationGroup(), this.answer(work), AsyncInvocation.getName(target, methodName));
        this.asyncTimeoutHandler = asyncTimeoutHandler;
    }

    public synchronized AsyncInvocation<V> start() {
        this.thread.start();
        return this;
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    public synchronized boolean isAlive() {
        return this.thread.isAlive();
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return !this.thread.isAlive();
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.thread.isAlive() && mayInterruptIfRunning) {
            this.cancelled = true;
            this.thread.interrupt();
            return true;
        }
        return false;
    }

    public AsyncInvocation<V> await() throws InterruptedException {
        try {
            return this.await(DEFAULT_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
    }

    @Override
    public V get() throws InterruptedException {
        try {
            return this.get(DEFAULT_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
    }

    public long getId() {
        return this.thread.getId();
    }

    public String toString() {
        return "AsyncInvocation{target=" + this.target + ", methodName='" + this.methodName + '\'' + '}';
    }

    @Deprecated
    public Object getTarget() {
        return this.target;
    }

    @Deprecated
    public String getMethodName() {
        return this.methodName;
    }

    @Deprecated
    public boolean exceptionOccurred() {
        return this.getException() != null;
    }

    @Deprecated
    public Throwable getException() {
        try {
            this.checkIsDone("Exception status not available while thread is alive.");
        }
        catch (IllegalStateException illegalStateException) {
            throw new AssertionError((Object)illegalStateException);
        }
        if (this.resultThrowable.get() instanceof RMIException) {
            return this.resultThrowable.get().getCause();
        }
        return this.resultThrowable.get();
    }

    @Deprecated
    public AsyncInvocation<V> checkException() {
        if (this.resultThrowable.get() != null) {
            throw new AssertionError("An exception occurred during asynchronous invocation.", this.getException());
        }
        return this;
    }

    @Deprecated
    public V getResult() throws InterruptedException {
        this.join();
        this.checkException();
        this.checkIsDone("Return value not available while thread is alive.");
        return this.resultValue.get();
    }

    @Deprecated
    public V getResult(long millis) throws InterruptedException {
        try {
            return this.get(millis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
    }

    @Deprecated
    public V getReturnValue() {
        this.checkIsDone("Return value not available while thread is alive.");
        return this.resultValue.get();
    }

    @Deprecated
    public synchronized AsyncInvocation<V> join(long millis) throws InterruptedException {
        this.thread.join(millis);
        return this;
    }

    @Deprecated
    public synchronized AsyncInvocation<V> join(long millis, int nanos) throws InterruptedException {
        this.thread.join(millis, nanos);
        return this;
    }

    @Deprecated
    public AsyncInvocation<V> join() throws InterruptedException {
        this.join(DEFAULT_TIMEOUT_MILLIS);
        return this;
    }

    @Deprecated
    public AsyncInvocation<V> await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long millis = unit.toMillis(timeout);
        this.join(millis);
        this.timeoutIfAlive(millis);
        this.checkException();
        return this;
    }

    @Override
    @Deprecated
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long millis = unit.toMillis(timeout);
        this.join(millis);
        this.timeoutIfAlive(millis);
        this.checkException();
        return this.resultValue.get();
    }

    private AsyncInvocation<V> checkIsDone(String message) {
        if (this.thread.isAlive()) {
            throw new IllegalStateException(message);
        }
        return this;
    }

    private AsyncInvocation<V> timeoutIfAlive(long timeout) throws TimeoutException {
        if (this.thread.isAlive()) {
            TimeoutException timeoutException = new TimeoutException("Timed out waiting " + timeout + " milliseconds for AsyncInvocation to complete.");
            throw this.asyncTimeoutHandler.apply(timeoutException);
        }
        return this;
    }

    private Runnable answer(Callable<V> work) {
        return () -> {
            try {
                this.resultValue.set(work.call());
            }
            catch (Throwable throwable) {
                this.resultThrowable.set(throwable);
            }
        };
    }

    private static String getName(Object target, String methodName) {
        StringBuilder sb = new StringBuilder(methodName).append(" invoked on ");
        if (target instanceof Class) {
            sb.append("class ").append(((Class)target).getName());
        } else {
            sb.append("an instance of ").append(target.getClass().getName());
        }
        return sb.toString();
    }

    private static Function<TimeoutException, TimeoutException> asyncTimeoutHandler(VM vm, long id) {
        return timeoutException -> {
            StackTrace stackTrace = (StackTrace)vm.invoke(() -> {
                System.out.println(VM.dumpThreads());
                return new StackTrace(vm.getId(), AsyncThreadId.get(id));
            });
            timeoutException.initCause(stackTrace);
            return timeoutException;
        };
    }

    private class AsyncInvocationGroup
    extends ThreadGroup {
        private AsyncInvocationGroup() {
            super("Async Invocations");
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof VirtualMachineError) {
                SystemFailure.setFailure((Error)((Error)throwable));
            }
            AsyncInvocation.this.resultThrowable.set(throwable);
        }
    }
}

