/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache30;

import org.apache.geode.cache.CacheCallback;
import org.apache.geode.test.awaitility.GeodeAwaitility;

public abstract class TestCacheCallback
implements CacheCallback {
    private volatile boolean isClosed = false;
    volatile boolean invoked = false;
    protected volatile Throwable callbackError = null;

    public boolean wasInvoked() {
        this.checkForError();
        boolean value = this.invoked;
        if (value) {
            this.invoked = false;
        }
        return value;
    }

    public boolean waitForInvocation(int timeoutMs) {
        return this.waitForInvocation(timeoutMs, 200L);
    }

    public boolean waitForInvocation(int timeoutMs, long interval) {
        if (!this.invoked) {
            GeodeAwaitility.await((String)"listener was never invoked").until(() -> this.invoked);
        }
        return this.wasInvoked();
    }

    public boolean isClosed() {
        this.checkForError();
        return this.isClosed;
    }

    public void close() {
        this.isClosed = true;
        this.close2();
    }

    public void close2() {
    }

    private void checkForError() {
        if (this.callbackError != null) {
            AssertionError error = new AssertionError((Object)"Exception occurred in callback");
            ((Throwable)((Object)error)).initCause(this.callbackError);
            throw error;
        }
    }
}

