/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.test.junit.rules.MemberStarterRule;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;
import org.apache.geode.test.junit.rules.serializable.SerializableTemporaryFolder;
import org.junit.rules.TemporaryFolder;

public class LocatorLauncherStartupRule
extends SerializableExternalResource {
    private LocatorLauncher launcher;
    private final TemporaryFolder temp = new SerializableTemporaryFolder();
    private final Properties properties = new Properties();
    private boolean autoStart;
    private UnaryOperator<LocatorLauncher.Builder> builderOperator;

    public LocatorLauncherStartupRule withAutoStart() {
        this.autoStart = true;
        return this;
    }

    public LocatorLauncherStartupRule withProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public LocatorLauncherStartupRule withProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public LocatorLauncherStartupRule withSSL(String components, boolean requireAuth, boolean endPointIdentification) {
        Properties sslProps = MemberStarterRule.getSSLProperties(components, requireAuth, endPointIdentification);
        this.properties.putAll((Map<?, ?>)sslProps);
        return this;
    }

    public LocatorLauncherStartupRule withBuilder(UnaryOperator<LocatorLauncher.Builder> builderOperator) {
        this.builderOperator = builderOperator;
        return this;
    }

    public void before() {
        if (this.autoStart) {
            this.start();
        }
    }

    public void start() {
        LocatorLauncher.Builder builder = new LocatorLauncher.Builder().setPort(Integer.valueOf(0)).set(this.properties).set("log-level", "config");
        if (this.builderOperator != null) {
            builder = (LocatorLauncher.Builder)this.builderOperator.apply(builder);
        }
        if (builder.getMemberName() == null) {
            builder.setMemberName("locator-0");
        }
        try {
            this.temp.create();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        builder.setWorkingDirectory(this.temp.getRoot().getAbsolutePath());
        this.launcher = builder.build();
        this.launcher.start();
    }

    public LocatorLauncher getLauncher() {
        return this.launcher;
    }

    public File getWorkingDir() {
        return this.temp.getRoot();
    }

    public void after() {
        if (this.launcher != null) {
            this.launcher.stop();
        }
        this.temp.delete();
    }
}

