/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.generator;

import java.security.Principal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.cache.operations.OperationContext;
import org.apache.geode.security.generator.AuthzCredentialGenerator;
import org.apache.geode.security.templates.UsernamePrincipal;
import org.apache.geode.security.templates.XmlAuthorization;
import org.apache.geode.test.util.ResourceUtils;

public class XmlAuthzCredentialGenerator
extends AuthzCredentialGenerator {
    private static final String dummyXml = "authz-dummy.xml";
    private static final String ldapXml = "authz-ldap.xml";
    private static final String pkcsXml = "authz-pkcs.xml";
    private static final String sslXml = "authz-ssl.xml";
    private static final String[] QUERY_REGIONS;
    public static OperationContext.OperationCode[] READER_OPS;
    public static OperationContext.OperationCode[] WRITER_OPS;
    public static OperationContext.OperationCode[] QUERY_OPS;
    private static final byte READER_ROLE = 1;
    private static final byte WRITER_ROLE = 2;
    private static final byte QUERY_ROLE = 3;
    private static final byte ADMIN_ROLE = 4;
    private static Set readerOpsSet;
    private static Set writerOpsSet;
    private static Set queryOpsSet;
    private static Set queryRegionSet;

    @Override
    protected Properties init() throws IllegalArgumentException {
        Properties sysProps = new Properties();
        String dirName = "/org/apache/geode/security/generator/";
        if (this.generator.classCode().isDummy()) {
            String xmlFilename = ResourceUtils.createTempFileFromResource(XmlAuthzCredentialGenerator.class, (String)"/org/apache/geode/security/generator/authz-dummy.xml").getAbsolutePath();
            sysProps.setProperty("security-authz-xml-uri", xmlFilename);
        } else if (this.generator.classCode().isLDAP()) {
            String xmlFilename = ResourceUtils.createTempFileFromResource(XmlAuthzCredentialGenerator.class, (String)"/org/apache/geode/security/generator/authz-ldap.xml").getAbsolutePath();
            sysProps.setProperty("security-authz-xml-uri", xmlFilename);
        } else {
            throw new IllegalArgumentException("No XML defined for XmlAuthorization module to work with " + this.generator.getAuthenticator());
        }
        return sysProps;
    }

    @Override
    public AuthzCredentialGenerator.ClassCode classCode() {
        return AuthzCredentialGenerator.ClassCode.XML;
    }

    @Override
    public String getAuthorizationCallback() {
        return XmlAuthorization.class.getName() + ".create";
    }

    private Principal getDummyPrincipal(byte roleType, int index) {
        String[] admins = new String[]{"root", "admin", "administrator"};
        int numReaders = 3;
        int numWriters = 3;
        switch (roleType) {
            case 1: {
                return new UsernamePrincipal("reader" + index % 3);
            }
            case 2: {
                return new UsernamePrincipal("writer" + index % 3);
            }
            case 3: {
                return new UsernamePrincipal("reader" + (index % 2 + 3));
            }
        }
        return new UsernamePrincipal(admins[index % admins.length]);
    }

    @Override
    protected Principal getAllowedPrincipal(OperationContext.OperationCode[] opCodes, String[] regionNames, int index) {
        if (this.generator.classCode().isDummy()) {
            byte roleType = this.getRequiredRole(opCodes, regionNames);
            return this.getDummyPrincipal(roleType, index);
        }
        if (this.generator.classCode().isLDAP()) {
            byte roleType = this.getRequiredRole(opCodes, regionNames);
            return this.getLdapPrincipal(roleType, index);
        }
        return null;
    }

    @Override
    protected Principal getDisallowedPrincipal(OperationContext.OperationCode[] opCodes, String[] regionNames, int index) {
        byte roleType = this.getRequiredRole(opCodes, regionNames);
        byte disallowedRoleType = 1;
        switch (roleType) {
            case 1: {
                disallowedRoleType = 2;
                break;
            }
            case 2: {
                disallowedRoleType = 1;
                break;
            }
            case 3: {
                disallowedRoleType = 1;
                break;
            }
            case 4: {
                disallowedRoleType = 1;
            }
        }
        if (this.generator.classCode().isDummy()) {
            return this.getDummyPrincipal(disallowedRoleType, index);
        }
        if (this.generator.classCode().isLDAP()) {
            return this.getLdapPrincipal(disallowedRoleType, index);
        }
        return null;
    }

    @Override
    protected int getNumPrincipalTries(OperationContext.OperationCode[] opCodes, String[] regionNames) {
        return 5;
    }

    private Principal getLdapPrincipal(byte roleType, int index) {
        String userPrefix = "gemfire";
        int[] readerIndices = new int[]{3, 4, 5};
        int[] writerIndices = new int[]{6, 7, 8};
        int[] queryIndices = new int[]{9, 10};
        int[] adminIndices = new int[]{1, 2};
        switch (roleType) {
            case 1: {
                int readerIndex = readerIndices[index % readerIndices.length];
                return new UsernamePrincipal("gemfire" + readerIndex);
            }
            case 2: {
                int writerIndex = writerIndices[index % writerIndices.length];
                return new UsernamePrincipal("gemfire" + writerIndex);
            }
            case 3: {
                int queryIndex = queryIndices[index % queryIndices.length];
                return new UsernamePrincipal("gemfire" + queryIndex);
            }
        }
        int adminIndex = adminIndices[index % adminIndices.length];
        return new UsernamePrincipal("gemfire" + adminIndex);
    }

    private byte getRequiredRole(OperationContext.OperationCode[] opCodes, String[] regionNames) {
        int roleType = 4;
        boolean requiresReader = true;
        boolean requiresWriter = true;
        boolean requiresQuery = true;
        for (int opNum = 0; opNum < opCodes.length; ++opNum) {
            OperationContext.OperationCode opCode = opCodes[opNum];
            if (requiresReader && !readerOpsSet.contains(opCode)) {
                requiresReader = false;
            }
            if (requiresWriter && !writerOpsSet.contains(opCode)) {
                requiresWriter = false;
            }
            if (!requiresQuery || queryOpsSet.contains(opCode)) continue;
            requiresQuery = false;
        }
        if (requiresReader) {
            roleType = 1;
        } else if (requiresWriter) {
            roleType = 2;
        } else if (requiresQuery && regionNames != null && regionNames.length > 0) {
            for (int index = 0; index < regionNames.length; ++index) {
                String regionName = XmlAuthorization.normalizeRegionName(regionNames[index]);
                if (!requiresQuery || queryRegionSet.contains(regionName)) continue;
                requiresQuery = false;
                break;
            }
            if (requiresQuery) {
                roleType = 3;
            }
        }
        return (byte)roleType;
    }

    static {
        int index;
        QUERY_REGIONS = new String[]{"/Portfolios", "/Positions", "/AuthRegion"};
        READER_OPS = new OperationContext.OperationCode[]{OperationContext.OperationCode.GET, OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.UNREGISTER_INTEREST, OperationContext.OperationCode.KEY_SET, OperationContext.OperationCode.CONTAINS_KEY, OperationContext.OperationCode.EXECUTE_FUNCTION};
        WRITER_OPS = new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT, OperationContext.OperationCode.DESTROY, OperationContext.OperationCode.INVALIDATE, OperationContext.OperationCode.REGION_CLEAR};
        QUERY_OPS = new OperationContext.OperationCode[]{OperationContext.OperationCode.QUERY, OperationContext.OperationCode.EXECUTE_CQ, OperationContext.OperationCode.STOP_CQ, OperationContext.OperationCode.CLOSE_CQ};
        readerOpsSet = new HashSet();
        for (index = 0; index < READER_OPS.length; ++index) {
            readerOpsSet.add(READER_OPS[index]);
        }
        writerOpsSet = new HashSet();
        for (index = 0; index < WRITER_OPS.length; ++index) {
            writerOpsSet.add(WRITER_OPS[index]);
        }
        queryOpsSet = new HashSet();
        for (index = 0; index < QUERY_OPS.length; ++index) {
            queryOpsSet.add(QUERY_OPS[index]);
        }
        queryRegionSet = new HashSet();
        for (index = 0; index < QUERY_REGIONS.length; ++index) {
            queryRegionSet.add(QUERY_REGIONS[index]);
        }
    }
}

