/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.cache.util.CqListenerAdapter;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.AvailablePort;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.test.dunit.Assert;
import org.apache.geode.test.dunit.DistributedTestUtils;
import org.apache.geode.test.dunit.IgnoredException;
import org.apache.geode.test.dunit.LogWriterUtils;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;

public class CacheServerTestUtil
extends JUnit4DistributedTestCase {
    private static Cache cache = null;
    private static IgnoredException expected;
    private static PoolImpl pool;
    protected static final int TYPE_CREATE = 0;
    protected static final int TYPE_UPDATE = 1;
    protected static final int TYPE_INVALIDATE = 2;
    protected static final int TYPE_DESTROY = 3;

    public static void createCacheClient(Pool poolAttr, String regionName) throws Exception {
        CacheServerTestUtil.createCacheClient(poolAttr, regionName, CacheServerTestUtil.getClientProperties(), Boolean.FALSE);
    }

    public static void createCacheClient(Pool poolAttr, String regionName, Properties dsProperties) throws Exception {
        CacheServerTestUtil.createCacheClient(poolAttr, regionName, dsProperties, Boolean.FALSE);
    }

    public static void createClientCache(Pool poolAttr, String regionName) throws Exception {
        CacheServerTestUtil.createClientCache(poolAttr, regionName, CacheServerTestUtil.getClientProperties());
    }

    public static void createClientCache(Pool poolAttr, String regionName, Properties dsProperties) throws Exception {
        ClientCacheFactory ccf = new ClientCacheFactory(dsProperties);
        if (poolAttr != null) {
            ccf.setPoolFreeConnectionTimeout(poolAttr.getFreeConnectionTimeout()).setPoolServerConnectionTimeout(poolAttr.getServerConnectionTimeout()).setPoolLoadConditioningInterval(poolAttr.getLoadConditioningInterval()).setPoolSocketBufferSize(poolAttr.getSocketBufferSize()).setPoolMinConnections(poolAttr.getMinConnections()).setPoolMaxConnections(poolAttr.getMaxConnections()).setPoolIdleTimeout(poolAttr.getIdleTimeout()).setPoolPingInterval(poolAttr.getPingInterval()).setPoolStatisticInterval(poolAttr.getStatisticInterval()).setPoolRetryAttempts(poolAttr.getRetryAttempts()).setPoolReadTimeout(poolAttr.getReadTimeout()).setPoolSubscriptionEnabled(poolAttr.getSubscriptionEnabled()).setPoolPRSingleHopEnabled(poolAttr.getPRSingleHopEnabled()).setPoolSubscriptionRedundancy(poolAttr.getSubscriptionRedundancy()).setPoolSubscriptionMessageTrackingTimeout(poolAttr.getSubscriptionMessageTrackingTimeout()).setPoolSubscriptionTimeoutMultiplier(poolAttr.getSubscriptionTimeoutMultiplier()).setPoolSubscriptionAckInterval(poolAttr.getSubscriptionAckInterval()).setPoolServerGroup(poolAttr.getServerGroup()).setPoolMultiuserAuthentication(poolAttr.getMultiuserAuthentication());
            for (InetSocketAddress locator : poolAttr.getLocators()) {
                ccf.addPoolLocator(locator.getHostName(), locator.getPort());
            }
            for (InetSocketAddress server : poolAttr.getServers()) {
                ccf.addPoolServer(server.getHostName(), server.getPort());
            }
        }
        new CacheServerTestUtil().createClientCache(dsProperties, ccf);
        ClientCache cc = (ClientCache)cache;
        cc.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create(regionName);
        pool = (PoolImpl)((GemFireCacheImpl)cc).getDefaultPool();
    }

    public static void createPool(PoolFactoryImpl.PoolAttributes poolAttr) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        InternalDistributedSystem ds = new CacheServerTestUtil().getSystem(props);
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init((Pool)poolAttr);
        PoolImpl p = (PoolImpl)pf.create("CacheServerTestUtil");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        pool = p;
    }

    public static void createCacheClient(Pool poolAttr, String regionName, Properties dsProperties, Boolean addControlListener) throws Exception {
        CacheServerTestUtil.createCacheClient(poolAttr, regionName, dsProperties, addControlListener, null);
    }

    public static void createCacheClient(Pool poolAttr, String regionName, Properties dsProperties, Boolean addControlListener, Properties javaSystemProperties) throws Exception {
        new CacheServerTestUtil().createCache(dsProperties);
        IgnoredException.addIgnoredException("java.net.ConnectException||java.net.SocketException");
        if (javaSystemProperties != null && javaSystemProperties.size() > 0) {
            Enumeration<?> e = javaSystemProperties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.setProperty(key, javaSystemProperties.getProperty(key));
            }
        }
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init(poolAttr);
        PoolImpl p = (PoolImpl)pf.create("CacheServerTestUtil");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        if (addControlListener.booleanValue()) {
            factory.addCacheListener((CacheListener)new ControlListener());
        }
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        pool = p;
    }

    public static void unsetJavaSystemProperties(Properties javaSystemProperties) {
        if (javaSystemProperties != null && javaSystemProperties.size() > 0) {
            Enumeration<?> e = javaSystemProperties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.clearProperty(key);
            }
        }
    }

    public static void createCacheClient(Pool poolAttr, String regionName1, String regionName2) throws Exception {
        new CacheServerTestUtil().createCache(CacheServerTestUtil.getClientProperties());
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init(poolAttr);
        PoolImpl p = (PoolImpl)pf.create("CacheServerTestUtil");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName1, attrs);
        cache.createRegion(regionName2, attrs);
        pool = p;
    }

    public static void createCacheClientFromXmlN(URL url, String poolName, String durableClientId, int timeout, Boolean addControlListener) {
        ClientCacheFactory ccf = new ClientCacheFactory();
        try {
            File cacheXmlFile = new File(url.toURI().getPath());
            ccf.set("cache-xml-file", cacheXmlFile.toURI().getPath());
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        ccf.set("mcast-port", "0");
        ccf.set("durable-client-id", durableClientId);
        ccf.set("durable-client-timeout", String.valueOf(timeout));
        ccf.set("log-file", "abs_client_system.log");
        ccf.set("log-level", LogWriterUtils.getDUnitLogLevel());
        cache = (Cache)ccf.create();
        expected = IgnoredException.addIgnoredException("java.net.ConnectionException||java.net.SocketException");
        pool = (PoolImpl)PoolManager.find((String)poolName);
    }

    public static void createCacheClientFromXml(URL url, String poolName, String durableClientId, int timeout, Boolean addControlListener) {
        ClientCacheFactory ccf = new ClientCacheFactory();
        try {
            File cacheXmlFile = new File(url.toURI().getPath());
            ccf.set("cache-xml-file", cacheXmlFile.toURI().getPath());
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        ccf.set("mcast-port", "0");
        ccf.set("durable-client-id", durableClientId);
        ccf.set("durable-client-timeout", String.valueOf(timeout));
        cache = (Cache)ccf.create();
        expected = IgnoredException.addIgnoredException("java.net.ConnectionException||java.net.SocketException");
        pool = (PoolImpl)PoolManager.find((String)poolName);
    }

    public static Integer createCacheServerFromXmlN(URL url) {
        CacheFactory ccf = new CacheFactory();
        try {
            File cacheXmlFile = new File(url.toURI().getPath());
            ccf.set("cache-xml-file", cacheXmlFile.toURI().getPath());
            ccf.set("mcast-port", "0");
            ccf.set("locators", "localhost[" + DistributedTestUtils.getDUnitLocatorPort() + "]");
            ccf.set("log-file", "abs_server_system.log");
            ccf.set("log-level", LogWriterUtils.getDUnitLogLevel());
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        cache = ccf.create();
        return new Integer(((CacheServer)cache.getCacheServers().get(0)).getPort());
    }

    public static Integer createCacheServerFromXml(URL url) {
        CacheFactory ccf = new CacheFactory();
        try {
            File cacheXmlFile = new File(url.toURI().getPath());
            ccf.set("cache-xml-file", cacheXmlFile.toURI().getPath());
            ccf.set("mcast-port", "0");
            ccf.set("locators", "localhost[" + DistributedTestUtils.getDUnitLocatorPort() + "]");
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        cache = ccf.create();
        return new Integer(((CacheServer)cache.getCacheServers().get(0)).getPort());
    }

    public static void createCacheClients(Pool poolAttr, String regionName1, String regionName2, Properties dsProperties) throws Exception {
        new CacheServerTestUtil().createCache(dsProperties);
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init(poolAttr);
        Pool p = pf.create("CacheServerTestUtil1");
        AttributesFactory factory1 = new AttributesFactory();
        factory1.setScope(Scope.LOCAL);
        factory1.setPoolName(p.getName());
        cache.createRegion(regionName1, factory1.create());
        p = pf.create("CacheServerTestUtil2");
        AttributesFactory factory2 = new AttributesFactory();
        factory2.setScope(Scope.LOCAL);
        factory2.setPoolName(p.getName());
        cache.createRegion(regionName2, factory2.create());
    }

    private static Properties getClientProperties() {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        return props;
    }

    private static Properties getClientProperties(boolean durable) {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        return props;
    }

    public static Integer createCacheServer(String regionName, Boolean notifyBySubscription) throws Exception {
        int port = AvailablePort.getRandomAvailablePort((int)0);
        CacheServerTestUtil.createCacheServer(regionName, notifyBySubscription, port);
        return port;
    }

    public static Integer[] createCacheServerReturnPorts(String regionName, Boolean notifyBySubscription) throws Exception {
        int port = CacheServerTestUtil.createCacheServer(regionName, notifyBySubscription);
        return new Integer[]{port, 0};
    }

    public static void createCacheServer(String regionName, Boolean notifyBySubscription, Integer serverPort) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + DistributedTestUtils.getDUnitLocatorPort() + "]");
        new CacheServerTestUtil().createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableBridgeConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        CacheServer server = cache.addCacheServer();
        server.setPort(serverPort.intValue());
        server.setNotifyBySubscription(notifyBySubscription.booleanValue());
        server.start();
    }

    public static Integer createCacheServer(String regionName1, String regionName2, Boolean notifyBySubscription) throws Exception {
        new CacheServerTestUtil().createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableBridgeConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        if (!regionName1.equals("")) {
            cache.createRegion(regionName1, attrs);
        }
        if (!regionName2.equals("")) {
            cache.createRegion(regionName2, attrs);
        }
        CacheServer server1 = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setNotifyBySubscription(notifyBySubscription.booleanValue());
        server1.start();
        return new Integer(server1.getPort());
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Assert.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        Assert.assertNotNull((Object)cache);
    }

    private void createClientCache(Properties props, ClientCacheFactory ccf) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Assert.assertNotNull((Object)ds);
        ds.disconnect();
        ClientCache cc = ccf.create();
        this.setSystem(props, cc.getDistributedSystem());
        cache = (Cache)cc;
        Assert.assertNotNull((Object)cache);
        expected = IgnoredException.addIgnoredException("java.net.ConnectionException||java.net.SocketException");
    }

    public static void closeCache() {
        if (expected != null) {
            expected.remove();
            expected = null;
        }
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void closeCache(boolean keepalive) {
        if (expected != null) {
            expected.remove();
            expected = null;
        }
        if (cache != null && !cache.isClosed()) {
            cache.close(keepalive);
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void clearCacheReference() {
        cache = null;
    }

    public static void setClientCrash(boolean crashOnClose) {
        ConnectionImpl.setTEST_DURABLE_CLIENT_CRASH((boolean)crashOnClose);
    }

    public static Cache getCache() {
        return cache;
    }

    public static ClientCache getClientCache() {
        return (ClientCache)cache;
    }

    public static PoolImpl getPool() {
        return pool;
    }

    public static void disableShufflingOfEndpoints() {
        System.setProperty("gemfire.PoolImpl.DISABLE_RANDOM", "true");
        System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "true");
    }

    public static void enableShufflingOfEndpoints() {
        System.setProperty("gemfire.PoolImpl.DISABLE_RANDOM", "false");
        System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "false");
    }

    public static void resetDisableShufflingOfEndpointsFlag() {
        System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "false");
    }

    static {
        pool = null;
    }

    public static class ControlCqListener
    extends CqListenerAdapter {
        public final LinkedList events = new LinkedList();
        public final Object CONTROL_LOCK = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitWhileNotEnoughEvents(long sleepMs, int eventCount) {
            long maxMillis = System.currentTimeMillis() + sleepMs;
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    long waitMillis;
                    while (this.events.size() < eventCount && (waitMillis = maxMillis - System.currentTimeMillis()) >= 10L) {
                        this.CONTROL_LOCK.wait(waitMillis);
                    }
                }
                catch (InterruptedException abort) {
                    Assert.fail((String)"interrupted");
                }
                return !this.events.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(CqEvent aCqEvent) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(aCqEvent);
                this.CONTROL_LOCK.notifyAll();
            }
        }
    }

    public static class ControlListener
    extends CacheListenerAdapter
    implements Declarable {
        public final LinkedList<EventWrapper> events = new LinkedList();
        public final LinkedList<EntryEvent> createEvents = new LinkedList();
        public final LinkedList<EntryEvent> updateEvents = new LinkedList();
        public final LinkedList<EntryEvent> destroyEvents = new LinkedList();
        public final Object CONTROL_LOCK = new Object();

        public void init(Properties props) {
        }

        public boolean waitWhileNotEnoughEvents(long sleepMs, int eventCount) {
            return this.waitWhileNotEnoughEvents(sleepMs, eventCount, -1);
        }

        public boolean waitWhileNotEnoughEvents(long sleepMs, int eventCount, int eventType) {
            return this.waitWhileNotEnoughEvents(sleepMs, eventCount, this.getEvents(eventType));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitWhileNotEnoughEvents(long sleepMs, int eventCount, List eventsToCheck) {
            long maxMillis = System.currentTimeMillis() + sleepMs;
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    long waitMillis;
                    while (eventsToCheck.size() < eventCount && (waitMillis = maxMillis - System.currentTimeMillis()) >= 10L) {
                        this.CONTROL_LOCK.wait(waitMillis);
                    }
                }
                catch (InterruptedException abort) {
                    Assert.fail((String)"interrupted");
                }
                return !eventsToCheck.isEmpty();
            }
        }

        public List getEvents(int eventType) {
            LinkedList<Object> eventsToCheck = null;
            switch (eventType) {
                case 0: {
                    eventsToCheck = this.createEvents;
                    break;
                }
                case 1: {
                    eventsToCheck = this.updateEvents;
                    break;
                }
                case 3: {
                    eventsToCheck = this.destroyEvents;
                    break;
                }
                default: {
                    eventsToCheck = this.events;
                }
            }
            return eventsToCheck;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 0));
                this.createEvents.add(e);
                this.CONTROL_LOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 1));
                this.updateEvents.add(e);
                this.CONTROL_LOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterInvalidate(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 2));
                this.CONTROL_LOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDestroy(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 3));
                this.destroyEvents.add(e);
                this.CONTROL_LOCK.notifyAll();
            }
        }
    }

    public static class EventWrapper {
        public final EntryEvent event;
        public final Object key;
        public final Object val;
        public final Object arg;
        public final int type;

        public EventWrapper(EntryEvent ee, int type) {
            this.event = ee;
            this.key = ee.getKey();
            this.val = ee.getNewValue();
            this.arg = ee.getCallbackArgument();
            this.type = type;
        }

        public boolean isCreate() {
            return this.type == 0;
        }

        public String toString() {
            return "EventWrapper: event=" + this.event + ", type=" + this.type;
        }
    }
}

