/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.util.Properties;
import org.apache.geode.cache.query.QueryTestUtils;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache30.ClientServerTestCase;
import org.apache.geode.cache30.RegionTestCase;
import org.apache.geode.distributed.internal.DistributionMessageObserver;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.admin.ClientStatsManager;
import org.apache.geode.internal.cache.DiskStoreObserver;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.tier.InternalClientMembership;
import org.apache.geode.internal.cache.tier.sockets.CacheServerTestUtil;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.geode.test.dunit.Disconnect;
import org.apache.geode.test.dunit.DistributedTestUtils;
import org.apache.geode.test.dunit.IgnoredException;
import org.apache.geode.test.dunit.Invoke;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;

public class DistributedRule
extends AbstractDistributedRule {
    public static Builder builder() {
        return new Builder();
    }

    public DistributedRule() {
        this(new Builder());
    }

    public DistributedRule(int vmCount) {
        this(new Builder().withVMCount(vmCount));
    }

    private DistributedRule(Builder builder) {
        super(builder.vmCount);
    }

    @Override
    protected void after() {
        TearDown.doTearDown();
    }

    public static Properties getDistributedSystemProperties() {
        return DUnitLauncher.getDistributedSystemProperties();
    }

    public static class TearDown
    extends SerializableExternalResource {
        protected void before() {
        }

        protected void after() {
            TearDown.doTearDown();
        }

        static void doTearDown() {
            TearDown.tearDownInVM();
            Invoke.invokeInEveryVM(() -> TearDown.tearDownInVM());
            Invoke.invokeInLocator(() -> {
                DistributionMessageObserver.setInstance(null);
                DistributedTestUtils.unregisterInstantiatorsInThisVM();
            });
            DUnitLauncher.closeAndCheckForSuspects();
        }

        public static void tearDownInVM() {
            Disconnect.disconnectFromDS();
            CacheCreation.clearThreadLocals();
            CacheServerTestUtil.clearCacheReference();
            ClientProxyMembershipID.system = null;
            ClientServerTestCase.AUTO_LOAD_BALANCE = false;
            ClientStatsManager.cleanupForTests();
            DiskStoreObserver.setInstance(null);
            DistributedTestUtils.unregisterInstantiatorsInThisVM();
            DistributionMessageObserver.setInstance(null);
            InitialImageOperation.slowImageProcessing = 0;
            InternalClientMembership.unregisterAllListeners();
            LogWrapper.close();
            QueryObserverHolder.reset();
            QueryTestUtils.setCache(null);
            RegionTestCase.preSnapshotRegion = null;
            SocketCreator.resetHostNameCache();
            SocketCreator.resolve_dns = true;
            System.clearProperty("gemfire.log-level");
            System.clearProperty("jgroups.resolve_dns");
            System.clearProperty("gemfire.client.max-message-size");
            if (InternalDistributedSystem.systemAttemptingReconnect != null) {
                InternalDistributedSystem.systemAttemptingReconnect.stopReconnecting();
            }
            IgnoredException.removeAllExpectedExceptions();
            SocketCreatorFactory.close();
            TypeRegistry.setPdxSerializer(null);
            TypeRegistry.init();
        }
    }

    public static class Builder {
        private int vmCount = VM.DEFAULT_VM_COUNT;

        public Builder withVMCount(int vmCount) {
            if (vmCount < 0) {
                throw new IllegalArgumentException("VM count must be positive integer");
            }
            this.vmCount = vmCount;
            return this;
        }

        public DistributedRule build() {
            return new DistributedRule(this);
        }
    }
}

