/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;

public class DistributedReference<V>
extends AbstractDistributedRule {
    private static final AtomicReference<Object> reference = new AtomicReference();
    private final AtomicBoolean autoClose = new AtomicBoolean(true);

    public DistributedReference() {
        this(VM.DEFAULT_VM_COUNT);
    }

    public DistributedReference(int vmCount) {
        super(vmCount);
    }

    public DistributedReference<V> autoClose(boolean value) {
        this.autoClose.set(value);
        return this;
    }

    public V get() {
        return (V)reference.get();
    }

    public void set(V newValue) {
        reference.set(newValue);
    }

    @Override
    protected void after() {
        this.invoker().invokeInEveryVMAndController(this::invokeAfter);
    }

    private void invokeAfter() {
        V value = this.get();
        if (value == null) {
            return;
        }
        reference.set(null);
        if (this.autoClose.get()) {
            this.autoClose(value);
        }
    }

    private void autoClose(V value) {
        if (value instanceof AutoCloseable) {
            DistributedReference.close((AutoCloseable)value);
        } else if (DistributedReference.hasMethod(value.getClass(), "close")) {
            DistributedReference.invokeMethod(value, "close");
        } else if (DistributedReference.hasMethod(value.getClass(), "disconnect")) {
            DistributedReference.invokeMethod(value, "disconnect");
        } else if (DistributedReference.hasMethod(value.getClass(), "stop")) {
            DistributedReference.invokeMethod(value, "stop");
        }
    }

    private static void close(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean hasMethod(Class<?> objectClass, String methodName) {
        try {
            Method method = objectClass.getMethod(methodName, new Class[0]);
            Class<?> returnType = method.getReturnType();
            if (method.getParameterCount() == 0 && Modifier.isPublic(method.getModifiers())) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private static void invokeMethod(Object object, String methodName) {
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

