/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.geode.test.dunit.internal.InternalBlackboard;
import org.apache.geode.util.internal.UncheckedUtils;

public class InternalBlackboardImpl
extends UnicastRemoteObject
implements InternalBlackboard {
    private static InternalBlackboard blackboard;
    private final Map<String, Boolean> gates = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Serializable> mailboxes = new ConcurrentHashMap<String, Serializable>();

    public static synchronized InternalBlackboard getInstance() {
        if (blackboard == null) {
            try {
                InternalBlackboardImpl.initialize();
            }
            catch (AlreadyBoundException alreadyBoundException) {
            }
            catch (Exception e) {
                throw new RuntimeException("failed to initialize blackboard", e);
            }
        }
        return blackboard;
    }

    private static synchronized void initialize() throws AlreadyBoundException, MalformedURLException, RemoteException {
        if (blackboard == null) {
            System.out.println("gemfire.DUnitLauncher.RMI_PORT=" + System.getProperty("gemfire.DUnitLauncher.RMI_PORT"));
            int namingPort = Integer.getInteger("gemfire.DUnitLauncher.RMI_PORT");
            String name = "//localhost:" + namingPort + "/InternalBlackboard";
            try {
                blackboard = (InternalBlackboard)Naming.lookup(name);
            }
            catch (NotBoundException e) {
                blackboard = new InternalBlackboardImpl();
                Naming.bind(name, blackboard);
            }
        }
    }

    @Override
    public void initBlackboard() throws RemoteException {
        this.gates.clear();
        this.mailboxes.clear();
    }

    @Override
    public void clearGate(String gateName) throws RemoteException {
        this.gates.remove(gateName);
    }

    @Override
    public void signalGate(String gateName) throws RemoteException {
        this.gates.put(gateName, Boolean.TRUE);
    }

    @Override
    public void waitForGate(String gateName, long timeout, TimeUnit units) throws InterruptedException, RemoteException, TimeoutException {
        long giveupTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, units);
        while (System.currentTimeMillis() < giveupTime) {
            Boolean gate = this.gates.get(gateName);
            if (gate != null && gate.booleanValue()) {
                return;
            }
            Thread.sleep(50L);
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isGateSignaled(String gateName) {
        Boolean gate = this.gates.get(gateName);
        return gate != null && gate != false;
    }

    @Override
    public <T> void setMailbox(String boxName, T value) {
        this.mailboxes.put(boxName, (Serializable)value);
    }

    @Override
    public <T> T getMailbox(String boxName) {
        return (T)UncheckedUtils.uncheckedCast((Object)this.mailboxes.get(boxName));
    }

    @Override
    public void ping() throws RemoteException {
    }

    @Override
    public Map<String, Boolean> gates() {
        return Collections.unmodifiableMap(this.gates);
    }

    @Override
    public Map<String, Serializable> mailboxes() {
        return Collections.unmodifiableMap(this.mailboxes);
    }

    @Override
    public void putGates(Map<String, Boolean> gates) {
        this.gates.putAll(gates);
    }

    @Override
    public void putMailboxes(Map<String, Serializable> mailboxes) {
        this.mailboxes.putAll(mailboxes);
    }
}

