/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.greplogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.test.greplogs.Patterns;

public class LogConsumer {
    private static final int ERROR_BUFFER_LIMIT = 128;
    private final String logName;
    private final Collection<Pattern> dynamicIgnoredPatterns = new ArrayList<Pattern>();
    private final Collection<Pattern> constantIgnoredPatterns = new ArrayList<Pattern>();
    private final boolean enableLogLevelThreshold;
    private final int skipLimit;
    private final Map<String, Integer> individualErrorCount = new HashMap<String, Integer>();
    private boolean infoMsgFlag;
    private int eatLines;
    private boolean tmpErrFlag;
    private int tmpErrLines;
    private boolean saveFlag;
    private int savelinenum;
    private StringBuilder all;
    private int lineNumber;

    public LogConsumer(boolean enableLogLevelThreshold, Collection<Pattern> constantIgnoredPatterns, String logName, int repeatLimit) {
        this.enableLogLevelThreshold = enableLogLevelThreshold;
        this.constantIgnoredPatterns.addAll(constantIgnoredPatterns);
        this.logName = logName;
        this.skipLimit = repeatLimit;
    }

    public StringBuilder consume(CharSequence line) {
        ++this.lineNumber;
        Matcher expectedExceptionMatcher = Patterns.IGNORED_EXCEPTION.matcher(line);
        if (expectedExceptionMatcher.find()) {
            this.expectedExceptionMatcherHandler(expectedExceptionMatcher);
            return null;
        }
        if (this.enableLogLevelThreshold && this.skipLine(line)) {
            return null;
        }
        if (this.eatLines != 0) {
            --this.eatLines;
            return null;
        }
        if (this.saveFlag || Patterns.ERROR_OR_MORE_LOG_LEVEL.matcher(line).find() || this.isExceptionErrorOrSomeSpecialCase(line)) {
            if (!this.saveFlag) {
                this.setInstanceVariablesForSomeReason(line);
            } else {
                if (!Patterns.CAUSED_BY.matcher(line).find() && this.matchesIgnoredPatterns(line)) {
                    this.tmpErrFlag = false;
                    this.tmpErrLines = 0;
                    this.saveFlag = false;
                }
                if (Patterns.BLANK.matcher(line).matches()) {
                    return this.enforceErrorLimitsAtShortErrMatcher();
                }
                if (this.tmpErrFlag) {
                    this.addErrLinesToAll(line);
                }
            }
        } else if (this.isWroteOrRMIWarn(line)) {
            this.handleWroteOrRMIWarn();
            return null;
        }
        return null;
    }

    public StringBuilder close() {
        if (this.saveFlag) {
            this.saveFlag = false;
            return this.enforceErrorLimit(1, this.all.toString(), this.savelinenum, this.logName);
        }
        return null;
    }

    private void handleWroteOrRMIWarn() {
        this.eatLines = 1;
    }

    private boolean isWroteOrRMIWarn(CharSequence line) {
        return Patterns.DEBUG_WROTE_EXCEPTION.matcher(line).find() || Patterns.RMI_WARNING.matcher(line).find();
    }

    private boolean isExceptionErrorOrSomeSpecialCase(CharSequence line) {
        return !(!Patterns.EXCEPTION.matcher(line).find() && !Patterns.JAVA_LANG_ERROR.matcher(line).find() && !Patterns.MALFORMED_I18N_MESSAGE.matcher(line).find() && !Patterns.MALFORMED_LOG4J_MESSAGE.matcher(line).find() || Patterns.HYDRA_MASTER_LOCATORS_WILDCARD.matcher(line).find() || Patterns.WARN_OR_LESS_LOG_LEVEL.matcher(line).find() && Patterns.RVV_BIT_SET_MESSAGE.matcher(line).find());
    }

    private void addErrLinesToAll(CharSequence line) {
        if (this.tmpErrLines < 128) {
            ++this.tmpErrLines;
            this.all.append(line).append(System.lineSeparator());
        }
        if (this.tmpErrLines == 128) {
            ++this.tmpErrLines;
            this.all.append("GrepLogs: ERROR_BUFFER_LIMIT limit reached,").append(" the error was too long to display completely.").append(System.lineSeparator());
        }
    }

    private StringBuilder enforceErrorLimitsAtShortErrMatcher() {
        this.saveFlag = false;
        Matcher shortErrMatcher = Patterns.ERROR_SHORT_NAME.matcher(this.all.toString());
        if (shortErrMatcher.matches()) {
            String shortName = shortErrMatcher.group(1);
            Integer i = this.individualErrorCount.get(shortName);
            int occurrences = i == null ? 1 : i + 1;
            this.individualErrorCount.put(shortName, occurrences);
            return this.enforceErrorLimit(occurrences, this.all.toString(), this.savelinenum, this.logName);
        }
        return this.enforceErrorLimit(1, this.all.toString(), this.lineNumber, this.logName);
    }

    private void setInstanceVariablesForSomeReason(CharSequence line) {
        this.saveFlag = true;
        this.tmpErrFlag = true;
        if (this.matchesIgnoredPatterns(line)) {
            this.saveFlag = false;
            this.tmpErrFlag = false;
            this.tmpErrLines = 0;
        }
        if (this.tmpErrFlag) {
            this.tmpErrLines = 1;
            this.all = new StringBuilder(line);
            this.all.append(System.lineSeparator());
            this.savelinenum = this.lineNumber;
        }
    }

    private String getShortName(CharSequence line) {
        Matcher exception2Matcher = Patterns.EXCEPTION_2.matcher(line);
        if (exception2Matcher.find()) {
            return exception2Matcher.group(1);
        }
        Matcher exception3Matcher = Patterns.EXCEPTION_3.matcher(line);
        if (exception3Matcher.find()) {
            return exception3Matcher.group(1);
        }
        Matcher exception4Matcher = Patterns.EXCEPTION_4.matcher(line);
        if (exception4Matcher.find()) {
            return exception4Matcher.group(1);
        }
        return null;
    }

    private boolean skipLine(CharSequence line) {
        if (this.infoMsgFlag) {
            if (Patterns.LOG_STATEMENT.matcher(line).find()) {
                this.infoMsgFlag = false;
            } else {
                if (Patterns.BLANK.matcher(line).matches()) {
                    this.infoMsgFlag = false;
                }
                return true;
            }
        }
        if (Patterns.WARN_OR_LESS_LOG_LEVEL.matcher(line).find()) {
            this.infoMsgFlag = true;
            return true;
        }
        return false;
    }

    private void expectedExceptionMatcherHandler(MatchResult expectedExceptionMatcher) {
        if (expectedExceptionMatcher.group(1).equals("add")) {
            this.dynamicIgnoredPatterns.add(Pattern.compile(expectedExceptionMatcher.group(2)));
        } else {
            this.dynamicIgnoredPatterns.remove(Pattern.compile(expectedExceptionMatcher.group(2)));
        }
    }

    private boolean matchesIgnoredPatterns(CharSequence line) {
        return this.dynamicIgnoredPatterns.stream().anyMatch(p -> p.matcher(line).find()) || this.constantIgnoredPatterns.stream().anyMatch(p -> p.matcher(line).find());
    }

    private StringBuilder enforceErrorLimit(int hits, String line, int linenum, String filename) {
        if (hits < this.skipLimit) {
            StringBuilder string = new StringBuilder();
            string.append("-----------------------------------------------------------------------").append(System.lineSeparator()).append("Found suspect string in ").append(filename).append(" at line ").append(linenum).append(System.lineSeparator()).append(System.lineSeparator()).append(line).append(System.lineSeparator());
            return string;
        }
        if (hits == this.skipLimit) {
            StringBuilder string = new StringBuilder();
            string.append(System.lineSeparator()).append(System.lineSeparator()).append("Hit occurrence limit of ").append(hits).append(" for this string.").append(System.lineSeparator()).append("Further reporting of this type of error will be suppressed.").append(System.lineSeparator());
            return string;
        }
        return null;
    }
}

