/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.util.Random;

class Jitter {
    private static final boolean USE_JITTER = true;
    private static final Random jitter = new Random();

    protected Jitter() {
    }

    static long jitterInterval(long intervalMillis) {
        return Jitter.adjustIntervalIfJitterIsEnabled(intervalMillis);
    }

    static int minimum() {
        return 10;
    }

    static int maximum() {
        return 5000;
    }

    private static int adjustIntervalIfJitterIsEnabled(long intervalMillis) {
        int minLegal = Jitter.minimum();
        int maxLegal = Jitter.maximum();
        if (intervalMillis <= (long)minLegal) {
            return (int)intervalMillis;
        }
        int maxValue = maxLegal;
        if (intervalMillis < (long)maxLegal) {
            maxValue = (int)intervalMillis;
        }
        return minLegal + jitter.nextInt(maxValue - minLegal + 1);
    }
}

