/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.security;

import java.util.List;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.examples.SimpleSecurityManager;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.security.TestCommand;
import org.apache.geode.test.junit.categories.SecurityTest;
import org.apache.geode.test.junit.rules.ConnectionConfiguration;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.ServerStarterRule;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTest.class})
public class GfshCommandsSecurityTestBase {
    @ClassRule
    public static ServerStarterRule serverStarter = ((ServerStarterRule)((ServerStarterRule)((ServerStarterRule)new ServerStarterRule().withJMXManager()).withHttpService()).withSecurityManager(SimpleSecurityManager.class)).withRegion(RegionShortcut.REPLICATE_PERSISTENT, "persistentRegion").withEmbeddedLocator();
    @Rule
    public GfshCommandRule gfshConnection = new GfshCommandRule(serverStarter::getJmxPort, GfshCommandRule.PortType.jmxManager);

    @BeforeClass
    public static void beforeClass() throws Exception {
        serverStarter.getCache().createRegionFactory(RegionShortcut.REPLICATE).create("region1");
    }

    @Test
    @ConnectionConfiguration(user="data", password="wrongPwd")
    public void testInvalidCredentials() throws Exception {
        Assertions.assertThat((boolean)this.gfshConnection.isConnected()).isFalse();
    }

    @Test
    @ConnectionConfiguration(user="data", password="data")
    public void testValidCredentials() throws Exception {
        Assertions.assertThat((boolean)this.gfshConnection.isConnected()).isTrue();
    }

    @Test
    @ConnectionConfiguration(user="clusterRead", password="clusterRead")
    public void testClusterReader() throws Exception {
        this.runCommandsPermittedAndForbiddenBy("CLUSTER:READ");
    }

    @Test
    @ConnectionConfiguration(user="clusterWrite", password="clusterWrite")
    public void testClusterWriter() throws Exception {
        this.runCommandsPermittedAndForbiddenBy("CLUSTER:WRITE");
    }

    @Test
    @ConnectionConfiguration(user="clusterManage", password="clusterManage")
    public void testClusterManager() throws Exception {
        this.runCommandsPermittedAndForbiddenBy("CLUSTER:MANAGE");
    }

    @Test
    @ConnectionConfiguration(user="dataRead", password="dataRead")
    public void testDataReader() throws Exception {
        this.runCommandsPermittedAndForbiddenBy("DATA:READ");
    }

    @Test
    @ConnectionConfiguration(user="dataWrite", password="dataWrite")
    public void testDataWriter() throws Exception {
        this.runCommandsPermittedAndForbiddenBy("DATA:WRITE");
    }

    @Test
    @ConnectionConfiguration(user="dataManage", password="dataManage")
    public void testDataManager() throws Exception {
        this.runCommandsPermittedAndForbiddenBy("DATA:MANAGE");
    }

    @Test
    @ConnectionConfiguration(user="dataReadRegionA", password="dataReadRegionA")
    public void testRegionAReader() throws Exception {
        this.runCommandsPermittedAndForbiddenBy("DATA:READ:RegionA");
    }

    @Test
    @ConnectionConfiguration(user="dataWriteRegionA", password="dataWriteRegionA")
    public void testRegionAWriter() throws Exception {
        this.runCommandsPermittedAndForbiddenBy("DATA:WRITE:RegionA");
    }

    @Test
    @ConnectionConfiguration(user="dataManageRegionA", password="dataManageRegionA")
    public void testRegionAManager() throws Exception {
        this.runCommandsPermittedAndForbiddenBy("DATA:MANAGE:RegionA");
    }

    @Test
    @ConnectionConfiguration(user="data,cluster", password="data,cluster")
    public void testRegionSuperUser() throws Exception {
        this.runCommandsPermittedAndForbiddenBy("*");
    }

    private void runCommandsPermittedAndForbiddenBy(String permission) throws Exception {
        List allPermitted = TestCommand.getPermittedCommands((Permission)new WildcardPermission(permission, true));
        for (TestCommand permitted : allPermitted) {
            System.out.println("Processing authorized command: " + permitted.getCommand());
            CommandResult result = this.gfshConnection.executeCommand(permitted.getCommand());
            Assertions.assertThat((Object)result).isNotNull();
            if (result.getStatus() != Result.Status.ERROR) continue;
            Assertions.assertThat((String)result.asString()).doesNotContain(new CharSequence[]{"not authorized"});
        }
        List others = TestCommand.getOnlineCommands();
        others.removeAll(allPermitted);
        for (TestCommand other : others) {
            System.out.println("Processing unauthorized command: " + other.getCommand());
            this.gfshConnection.executeAndAssertThat(other.getCommand()).statusIsError().containsOutput(new String[]{"Unauthorized"});
        }
    }

    @Test
    @ConnectionConfiguration(user="data,cluster", password="data,cluster")
    public void modifyInternalRegionSuperUser() {
        CommandResult result = this.gfshConnection.executeCommand("put --key=key1 --value=value1 --region=PdxTypes");
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.ERROR);
        Assertions.assertThat((String)result.asString()).contains(new CharSequence[]{"Unauthorized"});
    }

    @Test
    @ConnectionConfiguration(user="data", password="data")
    public void testGetPostProcess() throws Exception {
        this.gfshConnection.executeCommand("put --region=region1 --key=key2 --value=value2");
        this.gfshConnection.executeCommand("put --region=region1 --key=key2 --value=value2");
        this.gfshConnection.executeCommand("put --region=region1 --key=key3 --value=value3");
        this.gfshConnection.executeCommand("query --query=\"select * from /region1\"");
    }

    @Test
    @ConnectionConfiguration(user="data", password="data")
    public void createDiskStore() throws Exception {
        this.gfshConnection.executeAndAssertThat("create disk-store --name=disk1 --dir=disk1").statusIsError().containsOutput(new String[]{"not authorized for CLUSTER:MANAGE:DISK"});
    }

    @Test
    @ConnectionConfiguration(user="dataManage,clusterWriteDisk", password="dataManage,clusterWriteDisk")
    public void createPartitionedPersistentRegionWithCorrectPermissions() throws Exception {
        this.gfshConnection.executeAndAssertThat("create region --name=region2 --type=PARTITION_PERSISTENT").statusIsSuccess();
    }

    @Test
    @ConnectionConfiguration(user="dataManage", password="dataManage")
    public void createPartitionedPersistentRegionWithoutClusterWriteDisk() throws Exception {
        this.gfshConnection.executeAndAssertThat("create region --name=region2 --type=PARTITION_PERSISTENT").statusIsError().containsOutput(new String[]{"not authorized for CLUSTER:WRITE:DISK"});
    }

    @Test
    @ConnectionConfiguration(user="clusterWriteDisk", password="clusterWriteDisk")
    public void createPartitionedPersistentRegionWithoutDataManage() throws Exception {
        this.gfshConnection.executeAndAssertThat("create region --name=region2 --type=PARTITION_PERSISTENT").statusIsError().containsOutput(new String[]{"not authorized for DATA:MANAGE"});
    }
}

