/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.generator;

import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.apache.geode.security.generator.CredentialGenerator;
import org.apache.geode.security.templates.PKCSAuthInit;
import org.apache.geode.security.templates.PKCSAuthenticator;
import org.apache.geode.test.util.ResourceUtils;

public class PKCSCredentialGenerator
extends CredentialGenerator {
    public static String keyStoreDir = PKCSCredentialGenerator.getKeyStoreDir();
    public static boolean usesIBMJSSE;

    private static boolean usesIBMProviders() {
        Provider[] providers = Security.getProviders();
        for (int index = 0; index < providers.length; ++index) {
            if (providers[index].getName().toLowerCase().startsWith("ibm")) continue;
            return false;
        }
        return true;
    }

    private static String getKeyStoreDir() {
        usesIBMJSSE = PKCSCredentialGenerator.usesIBMProviders();
        if (usesIBMJSSE) {
            return "/org/apache/geode/security/generator/keys/ibm";
        }
        return "/org/apache/geode/security/generator/keys";
    }

    @Override
    protected Properties initialize() throws IllegalArgumentException {
        String keyStoreFile = ResourceUtils.createTempFileFromResource(PKCSCredentialGenerator.class, (String)(keyStoreDir + "/publickeyfile")).getAbsolutePath();
        Properties props = new Properties();
        props.setProperty("security-publickey-filepath", keyStoreFile);
        props.setProperty("security-publickey-pass", "gemfire");
        return props;
    }

    @Override
    public CredentialGenerator.ClassCode classCode() {
        return CredentialGenerator.ClassCode.PKCS;
    }

    @Override
    public String getAuthInit() {
        return PKCSAuthInit.class.getName() + ".create";
    }

    @Override
    public String getAuthenticator() {
        return PKCSAuthenticator.class.getName() + ".create";
    }

    @Override
    public Properties getInvalidCredentials(int index) {
        String keyStoreFile = ResourceUtils.createTempFileFromResource(PKCSCredentialGenerator.class, (String)(keyStoreDir + "/gemfire11.keystore")).getAbsolutePath();
        Properties props = new Properties();
        props.setProperty("security-keystorepath", keyStoreFile);
        props.setProperty("security-alias", "gemfire11");
        props.setProperty("security-keystorepass", "gemfire");
        return props;
    }

    @Override
    public Properties getValidCredentials(int index) {
        int aliasnum = index % 10 + 1;
        String keyStoreFile = ResourceUtils.createTempFileFromResource(PKCSCredentialGenerator.class, (String)(keyStoreDir + "/gemfire" + aliasnum + ".keystore")).getAbsolutePath();
        Properties props = new Properties();
        props.setProperty("security-keystorepath", keyStoreFile);
        props.setProperty("security-alias", "gemfire" + aliasnum);
        props.setProperty("security-keystorepass", "gemfire");
        return props;
    }

    @Override
    public Properties getValidCredentials(Principal principal) {
        String keyStoreFile = ResourceUtils.createTempFileFromResource(PKCSCredentialGenerator.class, (String)(keyStoreDir + principal.getName() + ".keystore")).getAbsolutePath();
        Properties props = new Properties();
        props.setProperty("security-keystorepath", keyStoreFile);
        props.setProperty("security-alias", principal.getName());
        props.setProperty("security-keystorepass", "gemfire");
        return props;
    }
}

