/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.LocatorDiscoveryCallback;
import org.apache.geode.cache.client.internal.LocatorDiscoveryCallbackAdapter;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.test.dunit.Assert;
import org.apache.geode.test.dunit.Invoke;
import org.apache.geode.test.dunit.LogWriterUtils;
import org.apache.geode.test.dunit.SerializableRunnable;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;

public abstract class LocatorTestBase
extends JUnit4DistributedTestCase {
    protected static final String CACHE_KEY = "CACHE";
    protected static final String LOCATOR_KEY = "LOCATOR";
    protected static final String REGION_NAME = "A_REGION";
    protected static final String POOL_NAME = "daPool";
    protected static final Object CALLBACK_KEY = "callback";
    protected static final HashMap<Object, Object> remoteObjects = new HashMap();

    @Override
    public final void preTearDown() throws Exception {
        SerializableRunnable tearDown = new SerializableRunnable("tearDown"){

            @Override
            public void run() {
                Cache cache;
                Locator locator = (Locator)remoteObjects.get(LocatorTestBase.LOCATOR_KEY);
                if (locator != null) {
                    try {
                        locator.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((cache = (Cache)remoteObjects.get(LocatorTestBase.CACHE_KEY)) != null) {
                    try {
                        cache.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                remoteObjects.clear();
            }
        };
        Invoke.invokeInEveryVM(tearDown);
        tearDown.run();
        this.postTearDownLocatorTestBase();
    }

    protected void postTearDownLocatorTestBase() throws Exception {
    }

    protected int startLocator(String hostName, String otherLocators) throws Exception {
        LocatorTestBase.disconnectFromDS();
        int httpPort = AvailablePortHelper.getRandomAvailableTCPPort();
        Properties props = new Properties();
        props.put("mcast-port", String.valueOf(0));
        props.put("locators", otherLocators);
        props.put("log-level", LogWriterUtils.getDUnitLogLevel());
        props.put("enable-cluster-configuration", "false");
        props.put("http-service-port", String.valueOf(httpPort));
        File logFile = new File("");
        InetAddress bindAddr = null;
        try {
            bindAddr = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException uhe) {
            Assert.fail("While resolving bind address ", uhe);
        }
        Locator locator = Locator.startLocatorAndDS((int)0, (File)logFile, (InetAddress)bindAddr, (Properties)props);
        remoteObjects.put(LOCATOR_KEY, locator);
        return locator.getPort();
    }

    protected int startLocatorInVM(VM vm, String hostName, String otherLocators) {
        return (Integer)vm.invoke("create locator", () -> this.startLocator(hostName, otherLocators));
    }

    protected void stopLocator() {
        Locator locator = (Locator)remoteObjects.remove(LOCATOR_KEY);
        locator.stop();
    }

    protected int startBridgeServerInVM(VM vm, String[] groups, String locators) {
        return this.startBridgeServerInVM(vm, groups, locators, new String[]{REGION_NAME});
    }

    protected int addCacheServer(String[] groups) throws IOException {
        Cache cache = (Cache)remoteObjects.get(CACHE_KEY);
        CacheServer server = cache.addCacheServer();
        server.setPort(0);
        server.setGroups(groups);
        server.start();
        return server.getPort();
    }

    protected int startBridgeServerInVM(VM vm, String[] groups, String locators, String[] regions) {
        return this.startBridgeServerInVM(vm, groups, locators, regions, CacheServer.DEFAULT_LOAD_PROBE, false);
    }

    protected int startBridgeServerInVM(VM vm, String[] groups, String locators, boolean useGroupsProperty) {
        return this.startBridgeServerInVM(vm, groups, locators, new String[]{REGION_NAME}, CacheServer.DEFAULT_LOAD_PROBE, useGroupsProperty);
    }

    protected int startBridgeServerInVM(VM vm, String[] groups, String locators, String[] regions, ServerLoadProbe probe, boolean useGroupsProperty) {
        return (Integer)vm.invoke("start cache server", () -> this.startBridgeServer(groups, locators, regions, probe, useGroupsProperty));
    }

    protected int startBridgeServer(String[] groups, String locators) throws IOException {
        return this.startBridgeServer(groups, locators, new String[]{REGION_NAME});
    }

    protected int startBridgeServer(String[] groups, String locators, String[] regions) throws IOException {
        return this.startBridgeServer(groups, locators, regions, CacheServer.DEFAULT_LOAD_PROBE, false);
    }

    protected int startBridgeServer(String[] groups, String locators, String[] regions, ServerLoadProbe probe, boolean useGroupsProperty) throws IOException {
        CacheFactory cacheFactory = new CacheFactory().set("mcast-port", "0").set("locators", locators);
        if (useGroupsProperty && groups != null) {
            cacheFactory.set("groups", StringUtils.join((Object[])groups, (String)","));
        }
        Cache cache = cacheFactory.create();
        for (String regionName : regions) {
            cache.createRegionFactory(RegionShortcut.REPLICATE).setEnableSubscriptionConflation(true).create(regionName);
        }
        CacheServer server = cache.addCacheServer();
        server.setPort(0);
        if (!useGroupsProperty) {
            server.setGroups(groups);
        }
        server.setLoadProbe(probe);
        server.start();
        remoteObjects.put(CACHE_KEY, cache);
        return server.getPort();
    }

    protected int startBridgeServerWithEmbeddedLocator(String[] groups, String locators, String[] regions, ServerLoadProbe probe) throws IOException {
        Cache cache = new CacheFactory().set("mcast-port", "0").set("locators", locators).set("start-locator", locators).create();
        for (String regionName : regions) {
            cache.createRegionFactory(RegionShortcut.REPLICATE).setEnableSubscriptionConflation(true).create(regionName);
        }
        CacheServer server = cache.addCacheServer();
        server.setGroups(groups);
        server.setLoadProbe(probe);
        server.setPort(0);
        server.start();
        remoteObjects.put(CACHE_KEY, cache);
        return server.getPort();
    }

    protected void startBridgeClientInVM(VM vm, String group, String host, int port) throws Exception {
        this.startBridgeClientInVM(vm, group, host, port, REGION_NAME);
    }

    protected void startBridgeClientInVM(VM vm, String group, String host, int port, String ... regions) throws Exception {
        PoolFactoryImpl pf = new PoolFactoryImpl(null);
        pf.addLocator(host, port).setServerGroup(group).setPingInterval(200L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1);
        this.startBridgeClientInVM(vm, (Pool)pf.getPoolAttributes(), regions);
    }

    protected void startBridgeClientInVM(VM vm, final Pool pool, final String ... regions) throws Exception {
        SerializableRunnable connect = new SerializableRunnable("Start bridge client"){

            @Override
            public void run() throws Exception {
                LocatorTestBase.this.startBridgeClient(pool, regions);
            }
        };
        if (vm == null) {
            connect.run();
        } else {
            vm.invoke(connect);
        }
    }

    protected void startBridgeClient(String group, String host, int port) throws Exception {
        this.startBridgeClient(group, host, port, new String[]{REGION_NAME});
    }

    protected void startBridgeClient(String group, String host, int port, String[] regions) throws Exception {
        PoolFactoryImpl pf = new PoolFactoryImpl(null);
        pf.addLocator(host, port).setServerGroup(group).setPingInterval(200L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1);
        this.startBridgeClient((Pool)pf.getPoolAttributes(), regions);
    }

    protected void startBridgeClient(Pool pool, String[] regions) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", String.valueOf(0));
        props.setProperty("locators", "");
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = CacheFactory.create((DistributedSystem)ds);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(POOL_NAME);
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init(pool);
        MyLocatorCallback locatorCallback = new MyLocatorCallback();
        remoteObjects.put(CALLBACK_KEY, (Object)locatorCallback);
        pf.setLocatorDiscoveryCallback((LocatorDiscoveryCallback)locatorCallback);
        pf.create(POOL_NAME);
        RegionAttributes attrs = factory.create();
        for (int i = 0; i < regions.length; ++i) {
            cache.createRegion(regions[i], attrs);
        }
        remoteObjects.put(CACHE_KEY, cache);
    }

    protected void stopBridgeMemberVM(VM vm) {
        vm.invoke(new SerializableRunnable("Stop bridge member"){

            @Override
            public void run() {
                Cache cache = (Cache)remoteObjects.remove(LocatorTestBase.CACHE_KEY);
                cache.close();
                JUnit4DistributedTestCase.disconnectFromDS();
            }
        });
    }

    public String getLocatorString(String hostName, int locatorPort) {
        return this.getLocatorString(hostName, new int[]{locatorPort});
    }

    public String getLocatorString(String hostName, int ... locatorPorts) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < locatorPorts.length; ++i) {
            str.append(hostName).append("[").append(locatorPorts[i]).append("]");
            if (i >= locatorPorts.length - 1) continue;
            str.append(",");
        }
        return str.toString();
    }

    protected static class MyLocatorCallback
    extends LocatorDiscoveryCallbackAdapter {
        private final Set discoveredLocators = new HashSet();
        private final Set removedLocators = new HashSet();

        protected MyLocatorCallback() {
        }

        public synchronized void locatorsDiscovered(List locators) {
            this.discoveredLocators.addAll(locators);
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized void locatorsRemoved(List locators) {
            this.removedLocators.addAll(locators);
            ((Object)((Object)this)).notifyAll();
        }

        public boolean waitForDiscovery(InetSocketAddress locator, long time) throws InterruptedException {
            return this.waitFor(this.discoveredLocators, locator, time);
        }

        public boolean waitForRemove(InetSocketAddress locator, long time) throws InterruptedException {
            return this.waitFor(this.removedLocators, locator, time);
        }

        private synchronized boolean waitFor(Set set, InetSocketAddress locator, long time) throws InterruptedException {
            long remaining = time;
            long endTime = System.currentTimeMillis() + time;
            while (!set.contains(locator) && remaining >= 0L) {
                ((Object)((Object)this)).wait(remaining);
                remaining = endTime - System.currentTimeMillis();
            }
            return set.contains(locator);
        }

        public synchronized Set getDiscovered() {
            return new HashSet(this.discoveredLocators);
        }
    }
}

