/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.test.dunit.Disconnect;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;
import org.assertj.core.api.Assertions;

public class CacheRule
extends AbstractDistributedRule {
    private static volatile InternalCache cache;
    private final boolean createCacheInAll;
    private final boolean createCache;
    private final boolean disconnectAfter;
    private final boolean destroyRegions;
    private final boolean replaceConfig;
    private final List<VM> createCacheInVMs;
    private final Properties config;
    private final Properties systemProperties;

    public static Builder builder() {
        return new Builder();
    }

    public CacheRule() {
        this(new Builder());
    }

    public CacheRule(int vmCount) {
        this(new Builder().vmCount(vmCount));
    }

    CacheRule(Builder builder) {
        super(builder.vmCount);
        this.createCacheInAll = builder.createCacheInAll;
        this.createCache = builder.createCache;
        this.disconnectAfter = builder.disconnectAfter;
        this.destroyRegions = builder.destroyRegions;
        this.replaceConfig = builder.replaceConfig;
        this.createCacheInVMs = builder.createCacheInVMs;
        this.config = builder.config;
        this.systemProperties = builder.systemProperties;
    }

    @Override
    protected void before() {
        if (this.createCacheInAll) {
            this.invoker().invokeInEveryVMAndController(() -> this.createCache(this.config(), this.systemProperties));
        } else {
            if (this.createCache) {
                this.createCache(this.config(), this.systemProperties);
            }
            for (VM vm : this.createCacheInVMs) {
                vm.invoke(() -> this.createCache(this.config(), this.systemProperties));
            }
        }
    }

    @Override
    protected void after() {
        this.closeAndNullCache();
        this.invoker().invokeInEveryVMAndController(() -> this.closeAndNullCache());
        if (this.disconnectAfter) {
            Disconnect.disconnectAllFromDS();
        }
    }

    public InternalCache getCache() {
        return cache;
    }

    public InternalDistributedSystem getSystem() {
        return cache.getInternalDistributedSystem();
    }

    public void createCache() {
        cache = (InternalCache)new CacheFactory(this.config()).create();
    }

    public void createCache(CacheFactory cacheFactory) {
        cache = (InternalCache)cacheFactory.create();
    }

    public void createCache(Properties config) {
        cache = (InternalCache)new CacheFactory(this.config(config)).create();
    }

    public void createCache(Properties config, Properties systemProperties) {
        System.getProperties().putAll((Map<?, ?>)systemProperties);
        cache = (InternalCache)new CacheFactory(this.config(config)).create();
    }

    public InternalCache getOrCreateCache() {
        if (cache == null || cache.isClosed()) {
            cache = null;
            this.createCache();
            Assertions.assertThat((Object)cache).isNotNull();
        }
        return cache;
    }

    public InternalCache getOrCreateCache(CacheFactory cacheFactory) {
        if (cache == null || cache.isClosed()) {
            cache = null;
            this.createCache(cacheFactory);
            Assertions.assertThat((Object)cache).isNotNull();
        }
        return cache;
    }

    public InternalCache getOrCreateCache(Properties config) {
        if (cache == null || cache.isClosed()) {
            cache = null;
            this.createCache(config);
            Assertions.assertThat((Object)cache).isNotNull();
        }
        return cache;
    }

    public InternalCache getOrCreateCache(Properties config, Properties systemProperties) {
        if (cache == null || cache.isClosed()) {
            cache = null;
            this.createCache(config, systemProperties);
            Assertions.assertThat((Object)cache).isNotNull();
        }
        return cache;
    }

    public void closeAndNullCache() {
        this.closeCache();
        CacheRule.nullCache();
    }

    private Properties config() {
        return this.config(new Properties());
    }

    private Properties config(Properties config) {
        if (this.replaceConfig) {
            return config;
        }
        Properties allConfig = DUnitLauncher.getDistributedSystemProperties();
        allConfig.putAll((Map<?, ?>)this.config);
        allConfig.putAll((Map<?, ?>)config);
        return allConfig;
    }

    private void closeCache() {
        try {
            if (cache != null) {
                if (this.destroyRegions) {
                    CacheRule.destroyRegions((Cache)cache);
                }
                cache.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void nullCache() {
        cache = null;
    }

    private static void destroyRegions(Cache cache) {
        if (cache != null && !cache.isClosed()) {
            for (Region root : cache.rootRegions()) {
                String regionFullPath;
                String string = regionFullPath = root == null ? null : root.getFullPath();
                if (root.isDestroyed() || root instanceof HARegion || root instanceof PartitionedRegion) continue;
                try {
                    root.localDestroyRegion((Object)"CacheRule_tearDown");
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class Builder {
        private final List<VM> createCacheInVMs = new ArrayList<VM>();
        private final Properties systemProperties = new Properties();
        private boolean createCacheInAll;
        private boolean createCache;
        private boolean disconnectAfter;
        private boolean destroyRegions;
        private boolean replaceConfig;
        private Properties config = new Properties();
        private int vmCount = VM.DEFAULT_VM_COUNT;

        public Builder createCacheInAll() {
            this.createCacheInAll = true;
            return this;
        }

        public Builder createCacheIn(VM vm) {
            if (!this.createCacheInVMs.contains(vm)) {
                this.createCacheInVMs.add(vm);
            }
            return this;
        }

        public Builder createCacheInLocal() {
            this.createCache = true;
            return this;
        }

        public Builder disconnectAfter() {
            this.disconnectAfter = true;
            return this;
        }

        public Builder destroyRegions() {
            this.destroyRegions = true;
            return this;
        }

        public Builder replaceConfig(Properties config) {
            this.config = config;
            this.replaceConfig = true;
            return this;
        }

        public Builder addConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        public Builder addConfig(Properties config) {
            this.config.putAll((Map<?, ?>)config);
            return this;
        }

        public Builder addSystemProperty(String key, String value) {
            this.systemProperties.put(key, value);
            return this;
        }

        public Builder addSystemProperties(Properties config) {
            this.systemProperties.putAll((Map<?, ?>)config);
            return this;
        }

        public Builder vmCount(int vmCount) {
            this.vmCount = vmCount;
            return this;
        }

        public CacheRule build() {
            return new CacheRule(this);
        }
    }
}

