/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.NoAvailableServersException;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.QueueConnectionImpl;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.cache30.CacheSerializableRunnable;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.AvailablePort;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.CacheClientUpdater;
import org.apache.geode.internal.cache.tier.sockets.MessageTooLargeException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.DistributedTestUtils;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.IgnoredException;
import org.apache.geode.test.dunit.NetworkUtils;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.Wait;
import org.apache.geode.test.dunit.cache.internal.JUnit4CacheTestCase;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.junit.categories.ClientServerTest;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientServerTest.class})
public class ClientServerMiscDUnitTestBase
extends JUnit4CacheTestCase {
    protected static PoolImpl pool = null;
    protected static Connection conn = null;
    static Cache static_cache;
    static int PORT1;
    private static final String k1 = "k1";
    private static final String k2 = "k2";
    static final String server_k1 = "server-k1";
    static final String server_k2 = "server-k2";
    static final String REGION_NAME1 = "ClientServerMiscDUnitTest_region1";
    static final String REGION_NAME2 = "ClientServerMiscDUnitTest_region2";
    private static final String PR_REGION_NAME = "ClientServerMiscDUnitTest_PRregion";
    private static Host host;
    protected static VM server1;
    protected static VM server2;
    private static RegionAttributes attrs;
    Properties props = new Properties();
    private final int putRange_1Start = 1;
    private final int putRange_1End = 5;
    private final int putRange_2Start = 6;
    private final int putRange_2End = 10;
    String testVersion = "10240.0.0";

    @Override
    public final void postSetUp() {
        host = Host.getHost(0);
        server1 = host.getVM("10240.0.0", 2);
        server2 = host.getVM("10240.0.0", 3);
    }

    int initServerCache(boolean notifyBySub) {
        return this.initServerCache(notifyBySub, false);
    }

    int initServerCache2() {
        return this.initServerCache2(false);
    }

    private int initServerCache(boolean notifyBySub, boolean isHA) {
        return this.initServerCache(notifyBySub, server1, isHA);
    }

    private int initServerCache2(boolean isHA) {
        return this.initServerCache(true, server2, isHA);
    }

    int initServerCache(boolean notifyBySub, VM vm, boolean isHA) {
        return (Integer)vm.invoke(() -> ClientServerMiscDUnitTestBase.createServerCache(notifyBySub, this.getMaxThreads(), isHA));
    }

    @Test
    public void testConcurrentOperationsWithDRandPR() {
        int port1 = this.initServerCache(true);
        int port2 = this.initServerCache2();
        String serverName = NetworkUtils.getServerHostName();
        host.getVM(this.testVersion, 0).invoke(() -> ClientServerMiscDUnitTestBase.createClientCacheV(serverName, port1));
        host.getVM(this.testVersion, 1).invoke(() -> ClientServerMiscDUnitTestBase.createClientCacheV(serverName, port2));
        LogService.getLogger().info("Testing concurrent map operations from a client with a distributed region");
        this.concurrentMapTest(host.getVM(this.testVersion, 0), "/ClientServerMiscDUnitTest_region1");
        LogService.getLogger().info("Testing concurrent map operations from a client with a partitioned region");
        this.concurrentMapTest(host.getVM(this.testVersion, 0), "/ClientServerMiscDUnitTest_PRregion");
    }

    @Test
    public void testClientReceivesPingIntervalSetting() {
        VM clientVM = Host.getHost(0).getVM(this.testVersion, 0);
        int port = this.initServerCache(true);
        String host = NetworkUtils.getServerHostName();
        clientVM.invoke("create client cache and verify", () -> this.createClientCacheAndVerifyPingIntervalIsSet(host, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createClientCacheAndVerifyPingIntervalIsSet(String host, int port) throws Exception {
        PoolImpl pool = null;
        try {
            Properties props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", "");
            this.createCache(props);
            pool = (PoolImpl)PoolManager.createFactory().addServer(host, port).setSubscriptionEnabled(true).setReadTimeout(1000).setSocketBufferSize(32768).setMinConnections(1).setSubscriptionRedundancy(-1).setPingInterval(2000L).create("test pool");
            Region region = cache.createRegionFactory(RegionShortcut.LOCAL).setPoolName("test pool").create(REGION_NAME1);
            region.registerInterest((Object)".*");
            QueueConnectionImpl primaryConnection = (QueueConnectionImpl)pool.getPrimaryConnection();
            int pingInterval = ((CacheClientUpdater)primaryConnection.getUpdater()).getServerQueueStatus().getPingInterval();
            Assert.assertNotEquals((long)0L, (long)pingInterval);
            Assert.assertEquals((long)CacheClientNotifier.getClientPingInterval(), (long)pingInterval);
        }
        finally {
            cache.close();
        }
    }

    @Test
    public void testConcurrentOperationsWithDRandPRandEmptyClient() {
        int port1 = this.initServerCache(true);
        int port2 = this.initServerCache2();
        String serverName = NetworkUtils.getServerHostName();
        host.getVM(this.testVersion, 0).invoke(() -> ClientServerMiscDUnitTestBase.createEmptyClientCache(serverName, port1));
        host.getVM(this.testVersion, 1).invoke(() -> ClientServerMiscDUnitTestBase.createClientCacheV(serverName, port2));
        LogService.getLogger().info("Testing concurrent map operations from a client with a distributed region");
        this.concurrentMapTest(host.getVM(this.testVersion, 0), "/ClientServerMiscDUnitTest_region1");
        LogService.getLogger().info("Testing concurrent map operations from a client with a partitioned region");
        this.concurrentMapTest(host.getVM(this.testVersion, 0), "/ClientServerMiscDUnitTest_PRregion");
    }

    private void concurrentMapTest(VM clientVM, final String rName) {
        clientVM.invoke(new CacheSerializableRunnable("doConcurrentMapOperations"){

            @Override
            public void run2() throws CacheException {
                int i;
                int size;
                InternalCache cache = ClientServerMiscDUnitTestBase.this.getCache();
                Region pr = cache.getRegion(rName);
                Assert.assertNotNull((String)(rName + " not created"), (Object)pr);
                boolean isEmpty = pr.getAttributes().getDataPolicy() == DataPolicy.EMPTY;
                for (int i2 = 1; i2 <= 5; ++i2) {
                    Object putResult = pr.putIfAbsent((Object)Integer.toString(i2), (Object)Integer.toString(i2));
                    Assert.assertNull((String)("Expected null, but got " + putResult + " for key " + i2), (Object)putResult);
                }
                if (!isEmpty) {
                    size = pr.size();
                    Assert.assertEquals((String)"Size doesn't return expected value", (long)5L, (long)size);
                    Assert.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 5; ++i) {
                    Object putResult = pr.putIfAbsent((Object)Integer.toString(i), (Object)Integer.toString(i + 1));
                    Assert.assertEquals((String)("for i=" + i), (Object)Integer.toString(i), (Object)putResult);
                    Assert.assertEquals((String)("for i=" + i), (Object)Integer.toString(i), (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    Assert.assertEquals((String)"Size doesn't return expected value", (long)5L, (long)size);
                    Assert.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 5; ++i) {
                    boolean replaceSucceeded = pr.replace((Object)Integer.toString(i), (Object)Integer.toString(i), (Object)("replaced" + i));
                    Assert.assertTrue((String)("for i=" + i), (boolean)replaceSucceeded);
                    Assert.assertEquals((String)("for i=" + i), (Object)("replaced" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    Assert.assertEquals((String)"Size doesn't return expected value", (long)5L, (long)size);
                    Assert.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 10; ++i) {
                    boolean replaceSucceeded = pr.replace((Object)Integer.toString(i), (Object)Integer.toString(i), (Object)("not" + i));
                    Assert.assertFalse((String)("for i=" + i), (boolean)replaceSucceeded);
                    Assert.assertEquals((String)("for i=" + i), i <= 5 ? "replaced" + i : null, (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    Assert.assertEquals((String)"Size doesn't return expected value", (long)5L, (long)size);
                    Assert.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 5; ++i) {
                    Object replaceResult = pr.replace((Object)Integer.toString(i), (Object)("twice replaced" + i));
                    Assert.assertEquals((String)("for i=" + i), (Object)("replaced" + i), (Object)replaceResult);
                    Assert.assertEquals((String)("for i=" + i), (Object)("twice replaced" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    Assert.assertEquals((String)"Size doesn't return expected value", (long)5L, (long)size);
                    Assert.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 6; i <= 10; ++i) {
                    Object replaceResult = pr.replace((Object)Integer.toString(i), (Object)("thrice replaced" + i));
                    Assert.assertNull((String)("for i=" + i), (Object)replaceResult);
                    Assert.assertNull((String)("for i=" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    Assert.assertEquals((String)"Size doesn't return expected value", (long)5L, (long)size);
                    Assert.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 10; ++i) {
                    boolean removeResult = pr.remove((Object)Integer.toString(i), (Object)Integer.toString(-i));
                    Assert.assertFalse((String)("for i=" + i), (boolean)removeResult);
                    Assert.assertEquals((String)("for i=" + i), i <= 5 ? "twice replaced" + i : null, (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    Assert.assertEquals((String)"Size doesn't return expected value", (long)5L, (long)size);
                    Assert.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 5; ++i) {
                    boolean removeResult = pr.remove((Object)Integer.toString(i), (Object)("twice replaced" + i));
                    Assert.assertTrue((String)("for i=" + i), (boolean)removeResult);
                    Assert.assertNull((String)("for i=" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    Assert.assertEquals((String)"Size doesn't return expected value", (long)0L, (long)size);
                    pr.localClear();
                    Assert.assertTrue((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                if (!isEmpty) {
                    String key42169 = "key42169";
                    pr.put((Object)key42169, (Object)"initialValue42169");
                    pr.localDestroy((Object)key42169);
                    boolean success = pr.replace((Object)key42169, (Object)"initialValue42169", (Object)"newValue42169");
                    Assert.assertTrue((String)"expected replace to succeed", (boolean)success);
                    pr.destroy((Object)key42169);
                    pr.put((Object)key42169, (Object)"secondRound");
                    pr.localDestroy((Object)key42169);
                    Object result = pr.putIfAbsent((Object)key42169, null);
                    Assert.assertEquals((String)"expected putIfAbsent to fail", (Object)result, (Object)"secondRound");
                    pr.destroy((Object)key42169);
                }
                if (isEmpty) {
                    String key41265 = "key41265";
                    boolean success = pr.remove((Object)key41265, null);
                    Assert.assertFalse((String)"expected remove to fail because key does not exist", (boolean)success);
                }
                Object oldValue = pr.putIfAbsent((Object)"keyForNull", null);
                Assert.assertNull((Object)oldValue);
                if (!isEmpty) {
                    Assert.assertTrue((boolean)pr.containsKey((Object)"keyForNull"));
                    Assert.assertTrue((!pr.containsValueForKey((Object)"keyForNull") ? 1 : 0) != 0);
                }
                Assert.assertTrue((boolean)pr.replace((Object)"keyForNull", null, (Object)"no longer invalid"));
                Assertions.assertThatThrownBy(() -> pr.replace((Object)"keyForNull", (Object)"no longer invalid", null)).isExactlyInstanceOf(NullPointerException.class);
                Assertions.assertThatThrownBy(() -> pr.replace((Object)"keyForNull", null)).isExactlyInstanceOf(NullPointerException.class);
                pr.putIfAbsent((Object)"otherKeyForNull", null);
                CachePerfStats stats = ((GemFireCacheImpl)pr.getCache()).getCachePerfStats();
                Number puts = this.getNumPuts(stats);
                boolean success = pr.replace((Object)"otherKeyForNull", null, (Object)"no longer invalid");
                Assert.assertTrue((boolean)success);
                Number newputs = this.getNumPuts(stats);
                Assert.assertEquals((String)"stats not updated properly or replace malfunctioned", (long)newputs.longValue(), (long)(puts.longValue() + 1L));
            }

            public Number getNumPuts(CachePerfStats stats) {
                Method getPutsMethod = null;
                try {
                    getPutsMethod = stats.getClass().getMethod("getPuts", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    Assert.fail((String)e.getMessage());
                }
                Number puts = null;
                try {
                    puts = (Number)getPutsMethod.invoke((Object)stats, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    Assert.fail((String)e.getMessage());
                }
                catch (InvocationTargetException e) {
                    Assert.fail((String)e.getMessage());
                }
                return puts;
            }
        });
    }

    @Test
    public void testForTwoRegionHavingDifferentInterestList() {
        int serverPort = PORT1 = this.initServerCache(true);
        VM client1 = Host.getHost(0).getVM(this.testVersion, 1);
        String hostname = NetworkUtils.getServerHostName();
        client1.invoke("create client1 cache", () -> {
            ClientServerMiscDUnitTestBase.createClientCache(hostname, serverPort);
            ClientServerMiscDUnitTestBase.populateCache();
            ClientServerMiscDUnitTestBase.registerInterest();
        });
        server1.invoke("putting entries in server1", () -> ClientServerMiscDUnitTestBase.put());
        client1.invoke(() -> ClientServerMiscDUnitTestBase.verifyUpdates());
    }

    @Test
    public void testForTwoRegionHavingALLKEYSInterest() throws Exception {
        PORT1 = this.initServerCache(true);
        ClientServerMiscDUnitTestBase.createClientCache(NetworkUtils.getServerHostName(), PORT1);
        ClientServerMiscDUnitTestBase.populateCache();
        ClientServerMiscDUnitTestBase.registerInterestInBothTheRegions();
        ClientServerMiscDUnitTestBase.closeRegion1();
        Wait.pause(6000);
        server1.invoke(() -> ClientServerMiscDUnitTestBase.verifyInterestListOnServer());
        server1.invoke(() -> ClientServerMiscDUnitTestBase.put());
        ClientServerMiscDUnitTestBase.verifyUpdatesOnRegion2();
    }

    @Test
    public void testRegionClose() throws Exception {
        PORT1 = this.initServerCache(true);
        pool = (PoolImpl)ClientServerMiscDUnitTestBase.createClientCache(NetworkUtils.getServerHostName(), PORT1);
        ClientServerMiscDUnitTestBase.populateCache();
        ClientServerMiscDUnitTestBase.registerInterestInBothTheRegions();
        ClientServerMiscDUnitTestBase.closeBothRegions();
        Assert.assertFalse((boolean)pool.isDestroyed());
        pool.destroy();
        Assert.assertTrue((boolean)pool.isDestroyed());
        server1.invoke(() -> ClientServerMiscDUnitTestBase.verifyNoCacheClientProxyOnServer());
    }

    @Test
    public void testCCPDestroyOnLastDestroyRegion() throws Exception {
        PORT1 = this.initServerCache(true);
        PoolImpl pool = (PoolImpl)ClientServerMiscDUnitTestBase.createClientCache(NetworkUtils.getServerHostName(), PORT1);
        ClientServerMiscDUnitTestBase.destroyRegion1();
        server1.invoke(() -> ClientServerMiscDUnitTestBase.verifyCacheClientProxyOnServer(REGION_NAME1));
        Connection conn = pool.acquireConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)1L, (long)pool.getConnectedServerCount());
        Assert.assertFalse((boolean)pool.isDestroyed());
        ClientServerMiscDUnitTestBase.destroyRegion2();
        Assert.assertFalse((boolean)pool.isDestroyed());
        ClientServerMiscDUnitTestBase.destroyPRRegion();
        Assert.assertFalse((boolean)pool.isDestroyed());
        pool.destroy();
        Assert.assertTrue((boolean)pool.isDestroyed());
        server1.invoke(() -> ClientServerMiscDUnitTestBase.verifyNoCacheClientProxyOnServer());
        Assertions.assertThatThrownBy(() -> this.getCache().createRegion(REGION_NAME2, attrs)).isExactlyInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testInvalidatesPropagateOnTwoRegions() throws Exception {
        PORT1 = this.initServerCache(false);
        ClientServerMiscDUnitTestBase.createClientCache(NetworkUtils.getServerHostName(), PORT1);
        ClientServerMiscDUnitTestBase.registerInterestForInvalidatesInBothTheRegions();
        ClientServerMiscDUnitTestBase.populateCache();
        server1.invoke(() -> ClientServerMiscDUnitTestBase.put());
        ClientServerMiscDUnitTestBase.verifyInvalidatesOnBothRegions();
    }

    @Test
    public void testGetInClientCreatesEntry() throws Exception {
        PORT1 = this.initServerCache(false);
        ClientServerMiscDUnitTestBase.createClientCache(NetworkUtils.getServerHostName(), PORT1);
        ClientServerMiscDUnitTestBase.registerInterestForInvalidatesInBothTheRegions();
        Region region = static_cache.getRegion(REGION_NAME1);
        ClientServerMiscDUnitTestBase.populateCache();
        region.put((Object)"invalidationKey", (Object)"invalidationValue");
        region.localDestroy((Object)"invalidationKey");
        Assertions.assertThat((boolean)region.containsKey((Object)"invalidationKey")).isFalse();
        region.invalidate((Object)"invalidationKey");
        Assertions.assertThat((boolean)region.containsKey((Object)"invalidationKey")).isTrue();
        Object value = region.get((Object)"invalidationKey");
        Assertions.assertThat((Object)value).isNull();
        Assertions.assertThat((boolean)region.containsKeyOnServer((Object)"invalidationKey")).isTrue();
    }

    @Test
    public void testLargeMessageIsRejected() throws Exception {
        PORT1 = this.initServerCache(false);
        ClientServerMiscDUnitTestBase.createClientCache(NetworkUtils.getServerHostName(), PORT1);
        Region region = static_cache.getRegion(REGION_NAME1);
        Op operation = new Op(){

            public Object attempt(Connection cnx) throws Exception {
                throw new MessageTooLargeException("message is too big");
            }
        };
        try {
            ((LocalRegion)region).getServerProxy().getPool().execute(operation);
        }
        catch (GemFireIOException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof MessageTooLargeException));
            return;
        }
        Assert.fail((String)"expected an exception to be thrown");
    }

    @Test
    public void testInvalidatesPropagateOnRegionHavingNoPool() {
        PORT1 = this.initServerCache(false);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new ClientServerMiscDUnitTestBase().createCache(props);
        String host = NetworkUtils.getServerHostName();
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1).setSubscriptionEnabled(true).setReadTimeout(1000).setSocketBufferSize(32768).setMinConnections(3).setSubscriptionRedundancy(-1).setPingInterval(2000L).create("testInvalidatesPropagateOnRegionHavingNoPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        attrs = factory.create();
        Region region1 = this.getCache().createRegion(REGION_NAME1, attrs);
        Region region2 = this.getCache().createRegion(REGION_NAME2, attrs);
        Assert.assertNotNull((Object)region1);
        Assert.assertNotNull((Object)region2);
        pool = p;
        conn = pool.acquireConnection();
        Assert.assertNotNull((Object)conn);
        ClientServerMiscDUnitTestBase.populateCache();
        server1.invoke(() -> ClientServerMiscDUnitTestBase.put());
        GeodeAwaitility.await().until(() -> {
            Object val = region1.getEntry((Object)k1).getValue();
            return k1.equals(val);
        });
        GeodeAwaitility.await().until(() -> {
            Object val = region1.getEntry((Object)k2).getValue();
            return k2.equals(val);
        });
        GeodeAwaitility.await().until(() -> {
            Object val = region2.getEntry((Object)k1).getValue();
            return k1.equals(val);
        });
        GeodeAwaitility.await().until(() -> {
            Object val = region2.getEntry((Object)k2).getValue();
            return k2.equals(val);
        });
    }

    @Test
    public void testProxyCreationBeforeCacheCreation() {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        InternalDistributedSystem ds = this.getSystem(props);
        Assert.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        PORT1 = this.initServerCache(true);
        String host = NetworkUtils.getServerHostName();
        Pool p = PoolManager.createFactory().addServer(host, PORT1).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).create("testProxyCreationBeforeCacheCreationPool");
        InternalCache cache = this.getCache();
        Assert.assertNotNull((Object)cache);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes myAttrs = factory.create();
        Region region1 = cache.createRegion(REGION_NAME1, myAttrs);
        Region region2 = cache.createRegion(REGION_NAME2, myAttrs);
        Assert.assertNotNull((Object)region1);
        Assert.assertNotNull((Object)region2);
        region2.registerInterest((Object)"ALL_KEYS");
        Wait.pause(6000);
        server1.invoke(() -> ClientServerMiscDUnitTestBase.verifyInterestListOnServer());
    }

    @Test
    public void testSystemCanBeCycledWithAnInitializedPool() {
        IgnoredException.addIgnoredException("Connection reset");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        InternalDistributedSystem ds = this.getSystem(props);
        Assert.assertNotNull((Object)ds);
        PORT1 = this.initServerCache(true);
        String host = NetworkUtils.getServerHostName();
        Pool p = PoolManager.createFactory().addServer(host, PORT1).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).create("testBug35380Pool");
        InternalCache cache = this.getCache();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes myAttrs = factory.create();
        Region region1 = cache.createRegion(REGION_NAME1, myAttrs);
        Region region2 = cache.createRegion(REGION_NAME2, myAttrs);
        Assert.assertNotNull((Object)region1);
        Assert.assertNotNull((Object)region2);
        region2.registerInterest((Object)"ALL_KEYS");
        ds.disconnect();
        Properties prop = new Properties();
        prop.setProperty("mcast-port", "0");
        prop.setProperty("locators", "");
        ds = this.getSystem(prop);
        InternalCache cacheForLamda = this.getCache();
        Assert.assertNotNull((Object)cacheForLamda);
        AttributesFactory factory1 = new AttributesFactory();
        factory1.setScope(Scope.DISTRIBUTED_ACK);
        factory1.setPoolName(p.getName());
        RegionAttributes attrs1 = factory1.create();
        Assertions.assertThatThrownBy(() -> ClientServerMiscDUnitTestBase.lambda$testSystemCanBeCycledWithAnInitializedPool$5((Cache)cacheForLamda, attrs1)).isInstanceOfAny(new Class[]{IllegalStateException.class, DistributedSystemDisconnectedException.class});
    }

    @Test(expected=GemFireConfigException.class)
    public void clientIsPreventedFromConnectingToLocatorAsServer() {
        IgnoredException.addIgnoredException("Improperly configured client detected");
        ClientCacheFactory clientCacheFactory = new ClientCacheFactory();
        clientCacheFactory.addPoolServer("localhost", DistributedTestUtils.getDUnitLocatorPort());
        clientCacheFactory.setPoolSubscriptionEnabled(true);
        this.getClientCache(clientCacheFactory);
        Region region = ((ClientCache)cache).createClientRegionFactory(ClientRegionShortcut.PROXY).create(REGION_NAME1);
        region.registerInterest((Object)k1);
    }

    private void createCache(Properties props) {
        this.createCacheV(props);
    }

    private Cache createCacheV(Properties props) {
        InternalDistributedSystem ds = this.getSystem(props);
        Assert.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        InternalCache cache = this.getCache();
        Assert.assertNotNull((Object)cache);
        return cache;
    }

    public static void createClientCacheV(String h, int port) {
        ClientServerMiscDUnitTestBase._createClientCache(h, false, -1, port);
    }

    public static void createEmptyClientCache(String h, int ... ports) {
        ClientServerMiscDUnitTestBase._createClientCache(h, false, -1, ports);
    }

    public static Pool createClientCache(String h, int ... ports) {
        return ClientServerMiscDUnitTestBase._createClientCache(h, false, -1, ports);
    }

    public static Pool createClientCache(String h, int subscriptionAckInterval, boolean empty, int ... ports) {
        return ClientServerMiscDUnitTestBase._createClientCache(h, empty, subscriptionAckInterval, ports);
    }

    private static PoolFactory addServers(PoolFactory factory, String h, int ... ports) {
        for (int port : ports) {
            factory.addServer(h, port);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pool _createClientCache(String h, boolean empty, int subscriptionAckInterval, int ... ports) {
        PoolImpl p;
        Cache cache;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        props.setProperty("log-level", DUnitLauncher.logLevel);
        static_cache = cache = new ClientServerMiscDUnitTestBase().createCacheV(props);
        System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "true");
        try {
            PoolFactory poolFactory = PoolManager.createFactory();
            ClientServerMiscDUnitTestBase.addServers(poolFactory, h, ports).setSubscriptionEnabled(true).setReadTimeout(5000).setSocketBufferSize(32768).setMinConnections(3).setSubscriptionRedundancy(1).setPingInterval(2000L);
            if (subscriptionAckInterval > 0) {
                poolFactory.setSubscriptionAckInterval(subscriptionAckInterval);
            }
            p = (PoolImpl)poolFactory.create("ClientServerMiscDUnitTestPool");
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            if (empty) {
                factory.setDataPolicy(DataPolicy.EMPTY);
            }
            factory.setPoolName(p.getName());
            attrs = factory.create();
        }
        finally {
            System.getProperties().remove("gemfire.bridge.disableShufflingOfEndpoints");
        }
        Region region1 = cache.createRegion(REGION_NAME1, attrs);
        Region region2 = cache.createRegion(REGION_NAME2, attrs);
        Region prRegion = cache.createRegion(PR_REGION_NAME, attrs);
        Assert.assertNotNull((Object)region1);
        Assert.assertNotNull((Object)region2);
        Assert.assertNotNull((Object)prRegion);
        pool = p;
        GeodeAwaitility.await().until(() -> {
            try {
                conn = pool.acquireConnection();
                return conn != null;
            }
            catch (NoAvailableServersException e) {
                return false;
            }
        });
        return p;
    }

    public static void dumpPoolIdentifiers() throws Exception {
        PoolImpl pool = (PoolImpl)PoolManager.find((String)"ClientServerMiscDUnitTestPool");
        Map seqMap = pool.getThreadIdToSequenceIdMap();
        for (Object o : seqMap.keySet()) {
            ThreadIdentifier tid = (ThreadIdentifier)o;
            byte[] memberBytes = tid.getMembershipID();
            ClientServerMiscDUnitTestBase.dumpMemberId(tid, memberBytes);
        }
    }

    public static void dumpMemberId(Object holder, byte[] memberBytes) throws Exception {
        byte[] newBytes = new byte[memberBytes.length + 17];
        System.arraycopy(memberBytes, 0, newBytes, 0, memberBytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(newBytes);
        DataInputStream dataIn = new DataInputStream(bais);
        InternalDistributedMember memberId = InternalDistributedMember.readEssentialData((DataInput)dataIn);
        String sb = "<" + Thread.currentThread().getName() + "> " + holder + " is " + memberId + " byte count = " + memberBytes.length + " bytes = " + Arrays.toString(memberBytes);
        System.out.println(sb);
    }

    public static Integer createServerCache(Boolean notifyBySubscription, Integer maxThreads, boolean isHA) throws Exception {
        Cache cache = new ClientServerMiscDUnitTestBase().createCacheV(new Properties());
        ClientServerMiscDUnitTestBase.unsetSlowDispatcherFlag();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setConcurrencyChecksEnabled(true);
        RegionAttributes myAttrs = factory.create();
        Region r1 = cache.createRegion(REGION_NAME1, myAttrs);
        Region r2 = cache.createRegion(REGION_NAME2, myAttrs);
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.PARTITION);
        if (isHA) {
            PartitionAttributesFactory paf = new PartitionAttributesFactory().setRedundantCopies(1);
            factory.setPartitionAttributes(paf.create());
        }
        RegionAttributes prAttrs = factory.create();
        Region pr = cache.createRegion(PR_REGION_NAME, prAttrs);
        Assert.assertNotNull((Object)r1);
        Assert.assertNotNull((Object)r2);
        Assert.assertNotNull((Object)pr);
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        r1.getCache().getDistributedSystem().getLogWriter().info("Starting server on port " + port);
        server.setPort(port);
        server.setMaxThreads(maxThreads.intValue());
        server.setNotifyBySubscription(notifyBySubscription.booleanValue());
        server.start();
        r1.getCache().getDistributedSystem().getLogWriter().info("Started server on port " + server.getPort());
        return server.getPort();
    }

    protected int getMaxThreads() {
        return 0;
    }

    public static void registerInterest() {
        InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
        Region r = cache.getRegion("/ClientServerMiscDUnitTest_region2");
        Assert.assertNotNull((Object)r);
        r.registerInterest((Object)"ALL_KEYS");
        r.getAttributesMutator().addCacheListener((CacheListener)new MemberIDVerifier());
    }

    private static void registerInterestForInvalidatesInBothTheRegions() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Region r1 = cache.getRegion("/ClientServerMiscDUnitTest_region1");
            Assert.assertNotNull((Object)r1);
            Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_region2");
            Assert.assertNotNull((Object)r2);
            r1.registerInterestForAllKeys(InterestResultPolicy.KEYS, false, false);
            r2.registerInterestForAllKeys(InterestResultPolicy.KEYS, false, false);
        }
        catch (CacheWriterException e) {
            e.printStackTrace();
            Assert.fail((String)("Test failed due to CacheWriterException during registerInterestnBothRegions" + (Object)((Object)e)));
        }
    }

    private static void registerInterestInBothTheRegions() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Region r1 = cache.getRegion("/ClientServerMiscDUnitTest_region1");
            Assert.assertNotNull((Object)r1);
            Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_region2");
            Assert.assertNotNull((Object)r2);
            r1.registerInterestForAllKeys();
            r2.registerInterestForAllKeys();
        }
        catch (CacheWriterException e) {
            e.printStackTrace();
            Assert.fail((String)("Test failed due to CacheWriterException during registerInterestnBothRegions" + (Object)((Object)e)));
        }
    }

    private static void closeRegion1() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Region r1 = cache.getRegion("/ClientServerMiscDUnitTest_region1");
            Assert.assertNotNull((Object)r1);
            r1.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Test failed due to Exception during closeRegion1" + e));
        }
    }

    private static void closeBothRegions() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Region r1 = cache.getRegion("/ClientServerMiscDUnitTest_region1");
            Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_region2");
            Region pr = cache.getRegion("/ClientServerMiscDUnitTest_PRregion");
            Assert.assertNotNull((Object)r1);
            Assert.assertNotNull((Object)r2);
            Assert.assertNotNull((Object)pr);
            r1.close();
            r2.close();
            pr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Test failed due to Exception during closeBothRegions" + e));
        }
    }

    private static void destroyRegion1() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Region r1 = cache.getRegion("/ClientServerMiscDUnitTest_region1");
            Assert.assertNotNull((Object)r1);
            r1.destroyRegion();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Test failed due to Exception during closeBothRegions" + e));
        }
    }

    private static void destroyRegion2() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_region2");
            Assert.assertNotNull((Object)r2);
            r2.destroyRegion();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Test failed due to Exception during closeBothRegions" + e));
        }
    }

    private static void destroyPRRegion() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_PRregion");
            Assert.assertNotNull((Object)r2);
            r2.destroyRegion();
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to Exception during closeBothRegions" + e));
        }
    }

    private static void verifyInterestListOnServer() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Assert.assertEquals((String)"More than one BridgeServer", (long)1L, (long)cache.getCacheServers().size());
            CacheServerImpl bs = (CacheServerImpl)cache.getCacheServers().iterator().next();
            Assert.assertNotNull((Object)bs);
            Assert.assertNotNull((Object)bs.getAcceptor());
            Assert.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            for (CacheClientProxy ccp : bs.getAcceptor().getCacheClientNotifier().getClientProxies()) {
                Set akr = ccp.cils[0].regions;
                Assert.assertNotNull((Object)akr);
                Assert.assertTrue((!akr.contains("/ClientServerMiscDUnitTest_region1") ? 1 : 0) != 0);
                Assert.assertTrue((boolean)akr.contains("/ClientServerMiscDUnitTest_region2"));
                Assert.assertEquals((long)1L, (long)akr.size());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("while setting verifyInterestListOnServer  " + ex));
        }
    }

    private static void verifyNoCacheClientProxyOnServer() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Assert.assertEquals((String)"More than one BridgeServer", (long)1L, (long)cache.getCacheServers().size());
            CacheServerImpl cacheServer = (CacheServerImpl)cache.getCacheServers().iterator().next();
            Assert.assertNotNull((Object)cacheServer);
            Assert.assertNotNull((Object)cacheServer.getAcceptor());
            CacheClientNotifier ccn = cacheServer.getAcceptor().getCacheClientNotifier();
            Assert.assertNotNull((Object)ccn);
            GeodeAwaitility.await().until(() -> ccn.getClientProxies().size() == 0);
        }
        catch (Exception ex) {
            System.out.println("The size of the client proxies != 0");
            OSProcess.printStacks((int)0);
            throw ex;
        }
    }

    private static void verifyCacheClientProxyOnServer(String regionName) {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Assert.assertNull((Object)cache.getRegion("/" + regionName));
            ClientServerMiscDUnitTestBase.verifyCacheClientProxyOnServer();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("while setting verifyNoCacheClientProxyOnServer  " + ex));
        }
    }

    private static void verifyCacheClientProxyOnServer() {
        InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
        Assert.assertEquals((String)"More than one BridgeServer", (long)1L, (long)cache.getCacheServers().size());
        CacheServerImpl bs = (CacheServerImpl)cache.getCacheServers().iterator().next();
        Assert.assertNotNull((Object)bs);
        Assert.assertNotNull((Object)bs.getAcceptor());
        CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
        Assert.assertNotNull((Object)ccn);
        GeodeAwaitility.await().until(() -> ccn.getClientProxies().size() == 1);
    }

    public static void populateCache() {
        InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
        Region r1 = cache.getRegion("/ClientServerMiscDUnitTest_region1");
        Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_region2");
        Assert.assertNotNull((Object)r1);
        Assert.assertNotNull((Object)r2);
        if (!r1.containsKey((Object)k1)) {
            r1.create((Object)k1, (Object)k1);
        }
        if (!r1.containsKey((Object)k2)) {
            r1.create((Object)k2, (Object)k2);
        }
        if (!r2.containsKey((Object)k1)) {
            r2.create((Object)k1, (Object)k1);
        }
        if (!r2.containsKey((Object)k2)) {
            r2.create((Object)k2, (Object)k2);
        }
        Assert.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)k1);
        Assert.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)k2);
        Assert.assertEquals((Object)r2.getEntry((Object)k1).getValue(), (Object)k1);
        Assert.assertEquals((Object)r2.getEntry((Object)k2).getValue(), (Object)k2);
    }

    public static void put() {
        InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
        Region r1 = cache.getRegion("/ClientServerMiscDUnitTest_region1");
        Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_region2");
        Assert.assertNotNull((Object)r1);
        Assert.assertNotNull((Object)r2);
        r1.put((Object)k1, (Object)server_k1);
        r1.put((Object)k2, (Object)server_k2);
        r2.put((Object)k1, (Object)server_k1);
        r2.put((Object)k2, (Object)server_k2);
        Assert.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)server_k1);
        Assert.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)server_k2);
        Assert.assertEquals((Object)r2.getEntry((Object)k1).getValue(), (Object)server_k1);
        Assert.assertEquals((Object)r2.getEntry((Object)k2).getValue(), (Object)server_k2);
    }

    static void putForClient() {
        InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
        Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_region2");
        if (r2 == null) {
            r2 = cache.createRegionFactory(RegionShortcut.REPLICATE).create(REGION_NAME2);
        }
        r2.put((Object)k1, (Object)"client2_k1");
        r2.put((Object)k2, (Object)"client2_k2");
    }

    private static void verifyUpdates() {
        InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
        Region r1 = cache.getRegion("/ClientServerMiscDUnitTest_region1");
        Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_region2");
        Assert.assertNotNull((Object)r1);
        Assert.assertNotNull((Object)r2);
        GeodeAwaitility.await().until(() -> {
            Object val = r1.getEntry((Object)k1).getValue();
            return k1.equals(val);
        });
        GeodeAwaitility.await().until(() -> {
            Object val = r1.getEntry((Object)k2).getValue();
            return k2.equals(val);
        });
        GeodeAwaitility.await().until(() -> {
            Object val = r2.getEntry((Object)k1).getValue();
            return server_k1.equals(val);
        });
        GeodeAwaitility.await().until(() -> {
            Object val = r2.getEntry((Object)k2).getValue();
            return server_k2.equals(val);
        });
        MemberIDVerifier verifier = (MemberIDVerifier)((LocalRegion)r2).getCacheListener();
        Assert.assertTrue((String)"client should have received a listener event", (boolean)verifier.eventReceived);
        Assert.assertFalse((String)"client received an update but the event had no member id", (boolean)verifier.memberIDNotReceived);
        verifier.reset();
    }

    private static void verifyInvalidatesOnBothRegions() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Region r1 = cache.getRegion("/ClientServerMiscDUnitTest_region1");
            Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_region2");
            Assert.assertNotNull((Object)r1);
            Assert.assertNotNull((Object)r2);
            GeodeAwaitility.await().until(() -> r1.getEntry((Object)k1).getValue() == null);
            GeodeAwaitility.await().until(() -> r1.getEntry((Object)k2).getValue() == null);
            GeodeAwaitility.await().until(() -> r2.getEntry((Object)k1).getValue() == null);
            GeodeAwaitility.await().until(() -> r2.getEntry((Object)k2).getValue() == null);
        }
        catch (Exception ex) {
            Assert.fail((String)("failed while verifyInvalidatesOnBothRegions()" + ex));
        }
    }

    private static void verifyUpdatesOnRegion2() {
        try {
            InternalCache cache = new ClientServerMiscDUnitTestBase().getCache();
            Region r2 = cache.getRegion("/ClientServerMiscDUnitTest_region2");
            Assert.assertNotNull((Object)r2);
            GeodeAwaitility.await().until(() -> server_k1.equals(r2.getEntry((Object)k1).getValue()));
            GeodeAwaitility.await().until(() -> server_k2.equals(r2.getEntry((Object)k2).getValue()));
        }
        catch (Exception ex) {
            Assert.fail((String)("failed while verifyUpdatesOnRegion2()" + ex));
        }
    }

    private static void unsetSlowDispatcherFlag() {
        CacheClientProxy.isSlowStartForTesting = false;
    }

    @Test
    public void testOnSeverMethodsWithProxyClient() throws Exception {
        this.testOnServerMethods(false, false);
    }

    @Test
    public void testOnSeverMethodsWithCachingProxyClient() throws Exception {
        this.testOnServerMethods(true, false);
    }

    @Test
    public void testOnSeverMethodsWithProxyClientHA() throws Exception {
        this.testOnServerMethods(false, true);
    }

    @Test
    public void testOnSeverMethodsWithCachingProxyClientHA() throws Exception {
        this.testOnServerMethods(true, true);
    }

    private void testOnServerMethods(boolean isCachingProxy, boolean isHA) throws Exception {
        int port1 = this.initServerCache(true, isHA);
        int port2 = this.initServerCache2(isHA);
        String serverName = NetworkUtils.getServerHostName();
        if (isCachingProxy) {
            ClientServerMiscDUnitTestBase.createClientCache(serverName, port1, port2);
        } else {
            ClientServerMiscDUnitTestBase.createEmptyClientCache(serverName, port1, port2);
        }
        if (isHA) {
            this.initServerCache(true, host.getVM("10240.0.0", 1), true);
        }
        String rName = "/ClientServerMiscDUnitTest_region1";
        String prName = "/ClientServerMiscDUnitTest_PRregion";
        this.verifyIsEmptyOnServer(rName, true);
        this.verifyIsEmptyOnServer(prName, true);
        int size = 10;
        this.putIntoRegion(rName, size, isCachingProxy);
        this.verifySizeOnServer(rName, size);
        this.putIntoRegion(prName, size, isCachingProxy);
        if (isHA) {
            server1.invoke(() -> this.closeMyCache());
        }
        this.verifySizeOnServer(prName, size);
        this.verifyIsEmptyOnServer(rName, false);
        this.verifyIsEmptyOnServer(prName, false);
        this.destroyEntries(rName, size);
        this.destroyEntries(prName, size);
        this.verifyIsEmptyOnServer(rName, true);
        this.verifyIsEmptyOnServer(prName, true);
        this.verifySizeOnServer(rName, 0);
        this.verifySizeOnServer(prName, 0);
    }

    private void putIntoRegion(String regionName, int size, boolean isCachingProxy) {
        int i;
        InternalCache cache = this.getCache();
        Region region = cache.getRegion(regionName);
        for (i = 0; i < size; ++i) {
            region.put((Object)i, (Object)i);
        }
        if (isCachingProxy) {
            for (i = 0; i < size; ++i) {
                region.localDestroy((Object)i, (Object)i);
            }
        }
    }

    private void destroyEntries(String regionName, int size) {
        InternalCache cache = this.getCache();
        Region region = cache.getRegion(regionName);
        for (int i = 0; i < size; ++i) {
            region.destroy((Object)i);
        }
    }

    private void verifySizeOnServer(String regionName, int expectedSize) {
        InternalCache cache = this.getCache();
        Region region = cache.getRegion(regionName);
        int actualSize = region.sizeOnServer();
        Assert.assertEquals((String)("sizeOnServer returns unexpected " + actualSize + " instead of expected " + expectedSize), (long)expectedSize, (long)actualSize);
    }

    private void verifyIsEmptyOnServer(String regionName, boolean expected) {
        InternalCache cache = this.getCache();
        Region region = cache.getRegion(regionName);
        boolean isEmptyOnServer = region.isEmptyOnServer();
        Assert.assertEquals((String)("isEmptyOnServer returns unexpected " + isEmptyOnServer + " instead of expected " + expected), (Object)expected, (Object)isEmptyOnServer);
    }

    private void closeMyCache() {
        InternalCache cache = this.getCache();
        cache.close();
    }

    private static /* synthetic */ void lambda$testSystemCanBeCycledWithAnInitializedPool$5(Cache cacheForLamda, RegionAttributes attrs1) throws Throwable {
        cacheForLamda.createRegion(REGION_NAME1, attrs1);
    }

    static class MemberIDVerifier
    extends CacheListenerAdapter {
        boolean memberIDNotReceived = true;
        boolean eventReceived = false;

        MemberIDVerifier() {
        }

        public void afterCreate(EntryEvent event) {
            this.eventReceived(event);
        }

        public void afterUpdate(EntryEvent event) {
            this.eventReceived(event);
        }

        private void eventReceived(EntryEvent event) {
            this.eventReceived = true;
            DistributedMember memberID = event.getDistributedMember();
            this.memberIDNotReceived = memberID == null;
        }

        public void reset() {
            this.memberIDNotReceived = true;
            this.eventReceived = false;
        }
    }
}

