/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.membership;

import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.adapter.GMSMembershipManager;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.membership.GMSJoinLeave;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.WaitCriterion;
import org.awaitility.core.ThrowingRunnable;
import org.junit.Assert;

public class GMSJoinLeaveTestHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void becomeCoordinatorForTest(GMSJoinLeave gmsJoinLeave) {
        Object object = gmsJoinLeave.getViewInstallationLock();
        synchronized (object) {
            gmsJoinLeave.becomeCoordinator();
        }
    }

    public static boolean isViewCreator() {
        GMSJoinLeave gmsJoinLeave = GMSJoinLeaveTestHelper.getGmsJoinLeave();
        Assert.assertNotNull((String)"There should be a JoinLeave for every DS", (Object)gmsJoinLeave);
        return gmsJoinLeave.getView().getCreator().equals(gmsJoinLeave.getMemberID());
    }

    private static void waitCriterion() {
        WaitCriterion waitCriterion = new WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    return GMSJoinLeaveTestHelper.getIDS() != null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public String description() {
                return "Distributed system is null";
            }
        };
        GeodeAwaitility.await().untilAsserted((ThrowingRunnable)waitCriterion);
    }

    private static GMSJoinLeave getGmsJoinLeave() {
        InternalDistributedSystem distributedSystem = GMSJoinLeaveTestHelper.getInternalDistributedSystem();
        DistributionManager dm = distributedSystem.getDM();
        GMSMembershipManager membershipManager = (GMSMembershipManager)dm.getMembershipManager();
        Services services = membershipManager.getServices();
        return (GMSJoinLeave)services.getJoinLeave();
    }

    public static InternalDistributedSystem getInternalDistributedSystem() {
        GMSJoinLeaveTestHelper.waitCriterion();
        return GMSJoinLeaveTestHelper.getIDS();
    }

    private static InternalDistributedSystem getIDS() {
        InternalDistributedSystem distributedSystem = InternalDistributedSystem.getAnyInstance();
        if (distributedSystem == null) {
            Locator locator = Locator.getLocator();
            if (locator == null) {
                return null;
            }
            return (InternalDistributedSystem)locator.getDistributedSystem();
        }
        return distributedSystem;
    }
}

