/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.dunit;

import java.util.Iterator;
import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqAttributesFactory;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqExistsException;
import org.apache.geode.cache.query.CqListener;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.QueryTestUtils;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.internal.index.CompactRangeIndex;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache30.CacheSerializableRunnable;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.test.dunit.AsyncInvocation;
import org.apache.geode.test.dunit.NetworkUtils;
import org.apache.geode.test.dunit.SerializableCallable;
import org.apache.geode.test.dunit.SerializableRunnable;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.cache.internal.JUnit4CacheTestCase;
import org.apache.geode.test.junit.categories.OQLQueryTest;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={OQLQueryTest.class})
public abstract class HelperTestCase
extends JUnit4CacheTestCase {
    protected void createPartitionRegion(VM vm, final String regionName, final Class valueConstraint) {
        vm.invoke(new SerializableCallable(){

            @Override
            public Object call() throws Exception {
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                RegionFactory factory = HelperTestCase.this.getCache().createRegionFactory(RegionShortcut.PARTITION).setPartitionAttributes(paf.create());
                if (valueConstraint != null) {
                    factory.setValueConstraint(valueConstraint);
                }
                factory.create(regionName);
                return true;
            }
        });
    }

    protected void createReplicatedRegion(VM vm, final String regionName, final Class valueConstraint) {
        vm.invoke(new SerializableCallable(){

            @Override
            public Object call() throws Exception {
                RegionFactory factory = HelperTestCase.this.getCache().createRegionFactory(RegionShortcut.REPLICATE);
                if (valueConstraint != null) {
                    factory.setValueConstraint(valueConstraint);
                }
                factory.create(regionName);
                return true;
            }
        });
    }

    protected void createCachingProxyRegion(VM vm, final String regionName, final Class valueConstraint) {
        vm.invoke(new SerializableCallable(){

            @Override
            public Object call() throws Exception {
                ClientRegionFactory factory = ((ClientCache)HelperTestCase.this.getCache()).createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY);
                if (valueConstraint != null) {
                    factory.setValueConstraint(valueConstraint);
                }
                factory.create(regionName);
                return true;
            }
        });
    }

    protected void createCQ(VM vm, final String cqName, final String query, final CqAttributes cqAttr) {
        vm.invoke(new SerializableCallable(){

            @Override
            public Object call() throws CqException, RegionNotFoundException, CqExistsException {
                CqAttributes attrs = cqAttr;
                if (attrs == null) {
                    attrs = HelperTestCase.this.createDummyCqAttributes();
                }
                HelperTestCase.this.getCache().getQueryService().newCq(cqName, query, attrs);
                return true;
            }
        });
    }

    protected void registerInterest(VM vm, final String regionName) {
        vm.invoke(new SerializableCallable(){

            @Override
            public Object call() throws CqException, RegionNotFoundException, CqExistsException {
                HelperTestCase.this.getCache().getRegion("/" + regionName).registerInterestRegex(".*");
                return true;
            }
        });
    }

    protected void createIndex(VM vm, final String indexName, final String indexedExpression, final String regionPath) {
        vm.invoke(new SerializableCallable(){

            @Override
            public Object call() throws RegionNotFoundException, CqExistsException, IndexExistsException, IndexNameConflictException {
                HelperTestCase.this.getCache().getQueryService().createIndex(indexName, indexedExpression, regionPath);
                return true;
            }
        });
    }

    protected void printIndexMapping(VM vm, final String regionName, final String indexName) {
        vm.invoke(new SerializableCallable(){

            @Override
            public Object call() throws RegionNotFoundException, CqExistsException, IndexExistsException, IndexNameConflictException {
                Region region = HelperTestCase.this.getCache().getRegion("/" + regionName);
                CompactRangeIndex index = (CompactRangeIndex)HelperTestCase.this.getCache().getQueryService().getIndex(region, indexName);
                System.out.println(index.dump());
                return true;
            }
        });
    }

    protected void put(VM vm, final String regionName, final Object key, final Object value) {
        vm.invoke(new SerializableCallable(){

            @Override
            public Object call() throws RegionNotFoundException, CqExistsException, IndexExistsException, IndexNameConflictException {
                HelperTestCase.this.getCache().getRegion("/" + regionName).put(key, value);
                return true;
            }
        });
    }

    private CqAttributes createDummyCqAttributes() {
        CqAttributesFactory cqAf = new CqAttributesFactory();
        CqListener[] cqListeners = new CqListener[]{new CqListener(){

            public void close() {
            }

            public void onEvent(CqEvent aCqEvent) {
            }

            public void onError(CqEvent aCqEvent) {
            }
        }};
        cqAf.initCqListeners(cqListeners);
        CqAttributes cqa = cqAf.create();
        return cqa;
    }

    protected AsyncInvocation executeCQ(VM vm, final String cqName) {
        return vm.invokeAsync(new SerializableCallable(){

            @Override
            public Object call() throws CqException, RegionNotFoundException {
                HelperTestCase.this.getCache().getQueryService().getCq(cqName).executeWithInitialResults();
                return true;
            }
        });
    }

    public void stopCacheServer(VM server) {
        server.invoke(new SerializableRunnable("Close CacheServer"){

            @Override
            public void run() {
                CacheServer cs = (CacheServer)HelperTestCase.this.getCache().getCacheServers().iterator().next();
                cs.stop();
                Assert.assertFalse((boolean)cs.isRunning());
            }
        });
    }

    protected void startCacheServer(VM server, int port, Properties properties) throws Exception {
        this.createCacheServer(server, port, properties);
        this.startCacheServers(server);
    }

    protected void createCacheServer(VM server, final int port, final Properties properties) throws Exception {
        server.invoke(new SerializableCallable(){

            @Override
            public Object call() throws Exception {
                HelperTestCase.this.getSystem(properties);
                GemFireCacheImpl cache = (GemFireCacheImpl)HelperTestCase.this.getCache();
                cache.setCopyOnRead(true);
                CacheServer cacheServer = HelperTestCase.this.getCache().addCacheServer();
                cacheServer.setPort(port);
                QueryTestUtils.setCache((Cache)cache);
                return true;
            }
        });
    }

    protected void startCacheServers(VM server) {
        server.invoke(new SerializableCallable(){

            @Override
            public Object call() throws Exception {
                Iterator iterator = HelperTestCase.this.getCache().getCacheServers().iterator();
                while (iterator.hasNext()) {
                    ((CacheServer)iterator.next()).start();
                }
                return true;
            }
        });
    }

    protected void startClient(VM client, final VM[] servers, final int[] ports, final int redundancyLevel, final Properties properties) {
        client.invoke(new CacheSerializableRunnable("Start client"){

            @Override
            public void run2() throws CacheException {
                HelperTestCase.this.getSystem(properties);
                ClientCacheFactory ccf = new ClientCacheFactory(properties);
                for (int i = 0; i < servers.length; ++i) {
                    ccf.addPoolServer(NetworkUtils.getServerHostName(servers[i].getHost()), ports[i]);
                }
                ccf.setPoolSubscriptionEnabled(true);
                ccf.setPoolSubscriptionRedundancy(redundancyLevel);
                ClientCache cache = HelperTestCase.this.getClientCache(ccf);
            }
        });
    }

    protected Properties getClientProperties() {
        Properties p = new Properties();
        p.setProperty("mcast-port", "0");
        p.setProperty("locators", "");
        return p;
    }

    protected Properties getServerProperties(int mcastPort) {
        Properties p = new Properties();
        p.setProperty("mcast-port", mcastPort + "");
        p.setProperty("locators", "");
        return p;
    }
}

