/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.geode.test.dunit.internal.InternalBlackboard;

public class InternalBlackboardImpl
extends UnicastRemoteObject
implements InternalBlackboard {
    public static InternalBlackboard blackboard;
    private Map<String, Boolean> gates = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Object> mailboxes = new ConcurrentHashMap<String, Object>();

    public static InternalBlackboard getInstance() {
        if (blackboard == null) {
            try {
                InternalBlackboardImpl.initialize();
            }
            catch (Exception e) {
                throw new RuntimeException("failed to initialize blackboard", e);
            }
        }
        return blackboard;
    }

    private static synchronized void initialize() throws Exception {
        if (blackboard == null) {
            System.out.println("gemfire.DUnitLauncher.RMI_PORT=" + System.getProperty("gemfire.DUnitLauncher.RMI_PORT"));
            int namingPort = Integer.getInteger("gemfire.DUnitLauncher.RMI_PORT");
            String name = "//localhost:" + namingPort + "/InternalBlackboard";
            try {
                blackboard = (InternalBlackboard)Naming.lookup(name);
            }
            catch (NotBoundException e) {
                blackboard = new InternalBlackboardImpl();
                Naming.bind(name, blackboard);
            }
        }
    }

    @Override
    public void initBlackboard() throws RemoteException {
        this.gates.clear();
        this.mailboxes.clear();
    }

    @Override
    public void clearGate(String gateName) throws RemoteException {
        this.gates.remove(gateName);
    }

    @Override
    public void signalGate(String gateName) throws RemoteException {
        this.gates.put(gateName, Boolean.TRUE);
    }

    @Override
    public void waitForGate(String gateName, long timeout, TimeUnit units) throws RemoteException, TimeoutException, InterruptedException {
        long giveupTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, units);
        while (System.currentTimeMillis() < giveupTime) {
            Boolean gate = this.gates.get(gateName);
            if (gate != null && gate.booleanValue()) {
                return;
            }
            Thread.sleep(50L);
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isGateSignaled(String gateName) {
        Boolean gate = this.gates.get(gateName);
        return gate != null && gate != false;
    }

    @Override
    public void setMailbox(String boxName, Object value) {
        this.mailboxes.put(boxName, value);
    }

    public Object getMailbox(String boxName) {
        return this.mailboxes.get(boxName);
    }

    @Override
    public void ping() throws RemoteException {
    }
}

