/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.SerializableCallableIF;
import org.apache.geode.test.dunit.SerializableRunnableIF;
import org.apache.geode.test.dunit.VM;

public class Invoke {
    protected Invoke() {
    }

    public static void invokeInEveryVM(SerializableRunnableIF runnable) {
        Invoke.invokeInEveryVM(null, runnable);
    }

    public static void invokeInEveryVM(String name, SerializableRunnableIF runnable) {
        for (int hostIndex = 0; hostIndex < Host.getHostCount(); ++hostIndex) {
            Host host = Host.getHost(hostIndex);
            for (VM vm : host.getAllVMs()) {
                if (name != null) {
                    vm.invoke(name, runnable);
                    continue;
                }
                vm.invoke(runnable);
            }
        }
    }

    @Deprecated
    public static void invokeInEveryVM(Class<?> targetClass, String targetMethod) {
        for (int hostIndex = 0; hostIndex < Host.getHostCount(); ++hostIndex) {
            Host host = Host.getHost(hostIndex);
            for (VM vm : host.getAllVMs()) {
                vm.invoke(targetClass, targetMethod);
            }
        }
    }

    public static void invokeInEveryVM(Class<?> targetClass, String targetMethod, Object[] methodArgs) {
        for (int hostIndex = 0; hostIndex < Host.getHostCount(); ++hostIndex) {
            Host host = Host.getHost(hostIndex);
            for (VM vm : host.getAllVMs()) {
                vm.invoke(targetClass, targetMethod, methodArgs);
            }
        }
    }

    public static <T> Map<VM, T> invokeInEveryVM(SerializableCallableIF<T> callable) {
        return Invoke.invokeInEveryVM(null, callable);
    }

    public static <T> Map<VM, T> invokeInEveryVM(String name, SerializableCallableIF<T> callable) {
        HashMap<VM, T> ret = new HashMap<VM, T>();
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (VM vm : host.getAllVMs()) {
                if (name != null) {
                    ret.put(vm, vm.invoke(name, callable));
                    continue;
                }
                ret.put(vm, vm.invoke(callable));
            }
        }
        return ret;
    }

    public static void invokeInLocator(SerializableRunnableIF runnable) {
        Host.getLocator().invoke(runnable);
    }
}

