/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.ServerProxy;
import org.apache.geode.cache.client.internal.ServerRegionProxy;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqAttributesMutator;
import org.apache.geode.cache.query.CqClosedException;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqListener;
import org.apache.geode.cache.query.CqResults;
import org.apache.geode.cache.query.CqStatusListener;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.cq.internal.CqEventImpl;
import org.apache.geode.cache.query.cq.internal.CqQueryImpl;
import org.apache.geode.cache.query.cq.internal.CqServiceImpl;
import org.apache.geode.cache.query.cq.internal.ops.ServerCQProxyImpl;
import org.apache.geode.cache.query.internal.CqStateImpl;
import org.apache.geode.cache.query.internal.cq.ClientCQ;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class ClientCQImpl
extends CqQueryImpl
implements ClientCQ {
    private static final Logger logger = LogService.getLogger();
    private CqAttributes cqAttributes;
    private volatile ServerCQProxyImpl cqProxy;
    private ProxyCache proxyCache = null;
    private volatile ConcurrentLinkedQueue<CqEventImpl> queuedEvents = null;
    final Object queuedEventsSynchObject = new Object();
    private boolean connected = false;

    public ClientCQImpl(CqServiceImpl cqService, String cqName, String queryString, CqAttributes cqAttributes, ServerCQProxyImpl serverProxy, boolean isDurable) {
        super(cqService, cqName, queryString, isDurable);
        this.cqAttributes = cqAttributes;
        this.cqProxy = serverProxy;
    }

    @Override
    public String getServerCqName() {
        return this.cqName;
    }

    ServerCQProxyImpl getCQProxy() {
        return this.cqProxy;
    }

    private void initConnectionProxy() throws CqException, RegionNotFoundException {
        this.cqBaseRegion = (LocalRegion)this.cqService.getCache().getRegion(this.regionName);
        if (this.cqBaseRegion == null) {
            throw new RegionNotFoundException(String.format("Region on which query is specified not found locally, regionName: %s", this.regionName));
        }
        ServerRegionProxy srp = this.cqBaseRegion.getServerProxy();
        if (srp != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Found server region proxy on region. RegionName: {}", (Object)this.regionName);
            }
            this.cqProxy = new ServerCQProxyImpl((ServerProxy)srp);
            if (!srp.getPool().getSubscriptionEnabled()) {
                throw new CqException("The 'queueEnabled' flag on Pool installed on Region " + this.regionName + " is set to false.");
            }
        } else {
            throw new CqException("Unable to get the connection pool. The Region does not have a pool configured.");
        }
    }

    public void close() throws CqClosedException, CqException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean sendRequestToServer) throws CqClosedException, CqException {
        CqListener[] cqListeners;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Started closing CQ CqName: {} SendRequestToServer: {}", (Object)this.cqName, (Object)sendRequestToServer);
        }
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (this.isClosed()) {
                if (isDebugEnabled) {
                    logger.debug("CQ is already closed, CqName: {}", (Object)this.cqName);
                }
                return;
            }
            int stateBeforeClosing = this.cqState.getState();
            this.cqState.setState(3);
            boolean isClosed = false;
            Exception exception = null;
            if (this.cqProxy != null && sendRequestToServer) {
                try {
                    if (this.proxyCache != null) {
                        if (this.proxyCache.isClosed()) {
                            throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                        }
                        UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
                    }
                    this.cqProxy.close(this);
                    isClosed = true;
                }
                catch (CancelException e) {
                    throw e;
                }
                catch (Exception ex) {
                    if (this.shutdownInProgress()) {
                        return;
                    }
                    exception = ex;
                }
                finally {
                    UserAttributes.userAttributes.set(null);
                }
            }
            this.removeFromCqMap();
            if (this.cqProxy == null || !sendRequestToServer || isClosed) {
                if (stateBeforeClosing == 1) {
                    this.cqService.stats().decCqsActive();
                } else if (stateBeforeClosing == 0) {
                    this.cqService.stats().decCqsStopped();
                }
                this.cqState.setState(2);
                this.cqService.stats().incCqsClosed();
                this.cqService.stats().decCqsOnClient();
                if (this.stats != null) {
                    this.stats.close();
                }
            } else {
                if (this.shutdownInProgress()) {
                    return;
                }
                if (exception != null) {
                    throw new CqException(String.format("Failed to close the cq. CqName: %s. Error from last endpoint: %s", this.cqName, exception.getLocalizedMessage()), exception.getCause());
                }
                throw new CqException(String.format("Failed to close the cq. CqName: %s. The server endpoints on which this cq was registered were not found.", this.cqName));
            }
        }
        if (this.cqAttributes != null && (cqListeners = this.getCqAttributes().getCqListeners()) != null) {
            if (isDebugEnabled) {
                logger.debug("Invoking CqListeners close() api for the CQ, CqName: {} Number of CqListeners: {}", (Object)this.cqName, (Object)cqListeners.length);
            }
            for (CqListener cqListener : cqListeners) {
                try {
                    cqListener.close();
                }
                catch (Exception ex) {
                    logger.warn("Exception occurred in the CqListener of the CQ, CqName : {} Error : {}", new Object[]{this.cqName, ex.getLocalizedMessage()});
                    if (!isDebugEnabled) continue;
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure((Error)err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.warn("RuntimeException occurred in the CqListener of the CQ, CqName : {} Error : {}", new Object[]{this.cqName, t.getLocalizedMessage()});
                    if (!isDebugEnabled) continue;
                    logger.debug(t.getMessage(), t);
                }
            }
        }
        if (isDebugEnabled) {
            logger.debug("Successfully closed the CQ. {}", (Object)this.cqName);
        }
    }

    @Override
    protected void cleanup() throws CqException {
        this.cqService.removeFromBaseRegionToCqNameMap(this.regionName, this.getServerCqName());
    }

    public CqAttributes getCqAttributes() {
        return this.cqAttributes;
    }

    public CqListener[] getCqListeners() {
        return this.cqAttributes.getCqListeners();
    }

    public void execute() throws CqClosedException, RegionNotFoundException, CqException {
        this.executeCqOnRedundantsAndPrimary(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> CqResults<E> executeWithInitialResults() throws CqClosedException, RegionNotFoundException, CqException {
        CqResults initialResults;
        Object object = this.queuedEventsSynchObject;
        synchronized (object) {
            while (this.queuedEvents != null) {
                try {
                    this.queuedEventsSynchObject.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.queuedEvents = new ConcurrentLinkedQueue();
        }
        if (CqQueryImpl.testHook != null) {
            testHook.pauseUntilReady();
        }
        try {
            initialResults = (CqResults)this.executeCqOnRedundantsAndPrimary(true);
        }
        catch (RuntimeException | CqException | RegionNotFoundException e) {
            this.queuedEvents = null;
            throw e;
        }
        Object object2 = this.queuedEventsSynchObject;
        synchronized (object2) {
            try {
                if (!this.queuedEvents.isEmpty()) {
                    try {
                        LoggingThread thread = new LoggingThread("CQEventHandler For " + this.cqName, () -> {
                            if (CqQueryImpl.testHook != null) {
                                testHook.setEventCount(this.queuedEvents.size());
                            }
                            Object object = this.queuedEventsSynchObject;
                            synchronized (object) {
                                try {
                                    Object[] eventArray;
                                    for (Object cqEvent : eventArray = this.queuedEvents.toArray()) {
                                        this.cqService.invokeListeners(this.cqName, this, (CqEventImpl)cqEvent);
                                        this.stats.decQueuedCqListenerEvents();
                                    }
                                }
                                finally {
                                    this.queuedEvents.clear();
                                    this.queuedEvents = null;
                                    this.queuedEventsSynchObject.notify();
                                }
                            }
                        });
                        thread.start();
                    }
                    catch (Exception ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Exception while invoking the CQ Listener with queued events.", (Throwable)ex);
                        }
                    }
                } else {
                    this.queuedEvents = null;
                }
            }
            finally {
                this.queuedEventsSynchObject.notify();
            }
            return initialResults;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeCqOnRedundantsAndPrimary(boolean executeWithInitialResults) throws CqClosedException, RegionNotFoundException, CqException {
        SelectResults initialResults = null;
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (this.isClosed()) {
                throw new CqClosedException(String.format("CQ is closed, CqName : %s", this.cqName));
            }
            if (this.isRunning()) {
                throw new IllegalStateException(String.format("CQ is in running state, CqName : %s", this.cqName));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Performing Execute {} request for CQ. CqName: {}", (Object)(executeWithInitialResults ? "WithInitialResult" : ""), (Object)this.cqName);
            }
            this.cqBaseRegion = (LocalRegion)this.cqService.getCache().getRegion(this.regionName);
            if (!this.cqService.isServer()) {
                if (this.cqProxy == null) {
                    this.initConnectionProxy();
                }
                boolean success = false;
                try {
                    if (this.proxyCache != null) {
                        if (this.proxyCache.isClosed()) {
                            throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                        }
                        UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
                    }
                    if (executeWithInitialResults) {
                        initialResults = this.cqProxy.createWithIR(this);
                        if (initialResults == null) {
                            String errMsg = "Failed to execute the CQ.  CqName: " + this.cqName + ", Query String is: " + this.queryString;
                            throw new CqException(errMsg);
                        }
                    } else {
                        this.cqProxy.create(this);
                    }
                    success = true;
                }
                catch (Exception ex) {
                    if (this.shutdownInProgress()) {
                        throw new CqException("System shutdown in progress.");
                    }
                    if (ex.getCause() instanceof GemFireSecurityException) {
                        if (this.securityLogWriter.warningEnabled()) {
                            this.securityLogWriter.warning(String.format("Exception while executing cq Exception: %s", ex));
                        }
                        throw new CqException(ex.getCause().getMessage(), ex.getCause());
                    }
                    if (ex instanceof CqException) {
                        throw (CqException)((Object)ex);
                    }
                    String errMsg = String.format("Failed to execute the CQ. CqName: %s, Query String is: %s, Error from last server: %s", this.cqName, this.queryString, ex.getLocalizedMessage());
                    if (logger.isDebugEnabled()) {
                        logger.debug(errMsg, (Throwable)ex);
                    }
                    throw new CqException(errMsg, (Throwable)ex);
                }
                finally {
                    if (!success && !this.shutdownInProgress()) {
                        try {
                            this.cqProxy.close(this);
                        }
                        catch (Exception e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Exception cleaning up failed cq", (Throwable)e);
                            }
                            UserAttributes.userAttributes.set(null);
                        }
                    }
                    UserAttributes.userAttributes.set(null);
                }
            }
            this.cqState.setState(1);
        }
        if (!this.cqService.isServer()) {
            CqListener[] cqListeners;
            this.connected = true;
            for (CqListener cqListener : cqListeners = this.getCqAttributes().getCqListeners()) {
                if (cqListener == null || !(cqListener instanceof CqStatusListener)) continue;
                CqStatusListener listener = (CqStatusListener)cqListener;
                listener.onCqConnected();
            }
        }
        this.cqService.stats().incCqsActive();
        this.cqService.stats().decCqsStopped();
        return initialResults;
    }

    private boolean shutdownInProgress() {
        InternalCache cache = this.cqService.getInternalCache();
        if (cache == null || cache.isClosed()) {
            return true;
        }
        String reason = this.cqProxy.getPool().getCancelCriterion().cancelInProgress();
        return reason != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws CqClosedException, CqException {
        boolean isStopped = false;
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (this.isClosed()) {
                throw new CqClosedException(String.format("CQ is closed, CqName : %s", this.cqName));
            }
            if (!this.isRunning()) {
                throw new IllegalStateException(String.format("CQ is not in running state, stop CQ does not apply, CqName : %s", this.cqName));
            }
            Exception exception = null;
            try {
                if (this.proxyCache != null) {
                    if (this.proxyCache.isClosed()) {
                        throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                    }
                    UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
                }
                this.cqProxy.stop(this);
                isStopped = true;
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                UserAttributes.userAttributes.set(null);
            }
            if (this.cqProxy == null || isStopped) {
                this.cqState.setState(0);
                this.cqService.stats().incCqsStopped();
                this.cqService.stats().decCqsActive();
                if (logger.isDebugEnabled()) {
                    logger.debug("Successfully stopped the CQ. {}", (Object)this.cqName);
                }
            } else {
                if (exception != null) {
                    throw new CqException(String.format("Failed to stop the cq. CqName :%s Error from last server: %s", this.cqName, exception.getLocalizedMessage()), exception.getCause());
                }
                throw new CqException(String.format("Failed to stop the cq. CqName: %s. The server endpoints on which this cq was registered were not found.", this.cqName));
            }
        }
    }

    public CqAttributesMutator getCqAttributesMutator() {
        return (CqAttributesMutator)this.cqAttributes;
    }

    ConcurrentLinkedQueue<CqEventImpl> getQueuedEvents() {
        return this.queuedEvents;
    }

    public void setProxyCache(ProxyCache proxyCache) {
        this.proxyCache = proxyCache;
    }

    boolean isConnected() {
        return this.connected;
    }

    void setConnected(boolean connected) {
        this.connected = connected;
    }

    public void createOn(Connection conn, boolean isDurable) {
        byte regionDataPolicyOrdinal = this.getCqBaseRegion() == null ? (byte)0 : this.getCqBaseRegion().getAttributes().getDataPolicy().ordinal;
        int state = this.cqState.getState();
        this.cqProxy.createOn(this.getName(), conn, this.getQueryString(), state, isDurable, regionDataPolicyOrdinal);
    }
}

