/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.GetEventValueOp;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.QueueManager;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqClosedException;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqExistsException;
import org.apache.geode.cache.query.CqListener;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.CqServiceStatistics;
import org.apache.geode.cache.query.CqStatusListener;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.cq.internal.ClientCQImpl;
import org.apache.geode.cache.query.cq.internal.CqEventImpl;
import org.apache.geode.cache.query.cq.internal.CqQueryImpl;
import org.apache.geode.cache.query.cq.internal.CqServiceStatisticsImpl;
import org.apache.geode.cache.query.cq.internal.CqServiceVsdStats;
import org.apache.geode.cache.query.cq.internal.ServerCQImpl;
import org.apache.geode.cache.query.cq.internal.ops.ServerCQProxyImpl;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.CqQueryVsdStats;
import org.apache.geode.cache.query.internal.CqStateImpl;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.cq.ClientCQ;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.JavaWorkarounds;
import org.apache.logging.log4j.Logger;

public class CqServiceImpl
implements CqService {
    private static final Logger logger = LogService.getLogger();
    private static final Integer MESSAGE_TYPE_LOCAL_CREATE = 27;
    private static final Integer MESSAGE_TYPE_LOCAL_UPDATE = 28;
    private static final Integer MESSAGE_TYPE_LOCAL_DESTROY = 16;
    private static final Integer MESSAGE_TYPE_EXCEPTION = 2;
    public static boolean EXECUTE_QUERY_DURING_INIT = Boolean.valueOf(System.getProperty("gemfire.cq.EXECUTE_QUERY_DURING_INIT", "true"));
    private static final String CQ_NAME_PREFIX = "GfCq";
    private final InternalCache cache;
    private final HashMap<String, Boolean> cqPoolsConnected = new HashMap();
    private volatile HashMap<String, CqQueryImpl> cqQueryMap = new HashMap();
    private final Object cqQueryMapLock = new Object();
    private volatile boolean isRunning = false;
    private final HashMap<String, UserAttributes> cqNameToUserAttributesMap = new HashMap();
    private final ConcurrentHashMap matchingCqMap;
    private final CqServiceStatisticsImpl cqServiceStats;
    private final CqServiceVsdStats stats;
    private volatile long cqId = 1L;
    private HashMap<String, ArrayList<String>> baseRegionToCqNameMap = new HashMap();
    private static final ConcurrentHashMap<String, ConcurrentHashMap<ClientProxyMembershipID, String>> serverCqNameCache = new ConcurrentHashMap();

    public CqServiceImpl(InternalCache cache) {
        if (cache == null) {
            throw new IllegalStateException("cache is null");
        }
        cache.getCancelCriterion().checkCancelInProgress(null);
        this.cache = cache;
        this.matchingCqMap = new ConcurrentHashMap();
        DistributedSystem factory = this.cache.getDistributedSystem();
        this.stats = new CqServiceVsdStats((StatisticsFactory)factory);
        this.cqServiceStats = new CqServiceStatisticsImpl(this);
    }

    public Cache getCache() {
        return this.cache;
    }

    public InternalCache getInternalCache() {
        return this.cache;
    }

    public CqServiceVsdStats stats() {
        return this.stats;
    }

    public synchronized ClientCQ newCq(String cqName, String queryString, CqAttributes cqAttributes, InternalPool pool, boolean isDurable) throws QueryInvalidException, CqExistsException, CqException {
        ClientCQImpl cQuery;
        block8: {
            if (queryString == null) {
                throw new IllegalArgumentException(String.format("Null argument %s", "queryString"));
            }
            if (cqAttributes == null) {
                throw new IllegalArgumentException(String.format("Null argument %s", "cqAttribute"));
            }
            if (this.isServer()) {
                throw new IllegalStateException("client side newCq() method invocation on server.");
            }
            if (cqName != null && this.isCqExists(cqName)) {
                throw new CqExistsException(String.format("CQ with the given name already exists. CqName : %s", cqName));
            }
            ServerCQProxyImpl serverProxy = pool == null ? null : new ServerCQProxyImpl(pool);
            cQuery = new ClientCQImpl(this, cqName, queryString, cqAttributes, serverProxy, isDurable);
            cQuery.updateCqCreateStats();
            cQuery.validateCq();
            if (cqName == null) {
                while (true) {
                    cQuery.setName(this.generateCqName());
                    try {
                        this.addToCqMap(cQuery);
                        break block8;
                    }
                    catch (CqExistsException ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Got CqExistsException while intializing cq : {} Error : {}", (Object)cQuery.getName(), (Object)ex.getMessage());
                        continue;
                    }
                    break;
                }
            }
            this.addToCqMap(cQuery);
        }
        this.addToBaseRegionToCqNameMap(cQuery.getBaseRegionName(), cQuery.getServerCqName());
        return cQuery;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized ServerCQ executeCq(String cqName, String queryString, int cqState, ClientProxyMembershipID clientProxyId, CacheClientNotifier ccn, boolean isDurable, boolean manageEmptyRegions, int regionDataPolicy, Map emptyRegionsMap) throws CqException, RegionNotFoundException, CqClosedException {
        if (!this.isServer()) {
            throw new IllegalStateException(String.format("Server side executeCq method is called on client. CqName : %s", new Object[]{cqName}));
        }
        serverCqName = this.constructServerCqName(cqName, clientProxyId);
        if (!this.isCqExists(serverCqName)) {
            cQuery = new ServerCQImpl(this, cqName, queryString, isDurable, this.constructServerCqName(cqName, clientProxyId));
            try {
                cQuery.registerCq(clientProxyId, ccn, cqState);
                if (!manageEmptyRegions) ** GOTO lbl19
                if (emptyRegionsMap != null && emptyRegionsMap.containsKey(cQuery.getBaseRegionName())) {
                    regionDataPolicy = 0;
                }
                proxy = this.getCacheClientProxy(clientProxyId, ccn);
                ccn.updateMapOfEmptyRegions(proxy.getRegionsWithEmptyDataPolicy(), cQuery.getBaseRegionName(), regionDataPolicy);
            }
            catch (CqException cqe) {
                CqServiceImpl.logger.info("Exception while registering CQ on server. CqName : {}", (Object)cQuery.getName());
                throw cqe;
            }
        } else {
            cQuery = (ServerCQImpl)this.getCq(serverCqName);
            this.resumeCQ(cqState, cQuery);
        }
lbl19:
        // 3 sources

        if (CqServiceImpl.logger.isDebugEnabled()) {
            CqServiceImpl.logger.debug("Successfully created CQ on the server. CqName : {}", (Object)cQuery.getName());
        }
        return cQuery;
    }

    public CacheClientProxy getCacheClientProxy(ClientProxyMembershipID clientProxyId, CacheClientNotifier ccn) throws CqException {
        CacheClientProxy proxy = ccn.getClientProxy(clientProxyId, true);
        if (proxy == null) {
            throw new CqException("No Cache Client Proxy found while executing CQ.");
        }
        return proxy;
    }

    public void resumeCQ(int cqState, ServerCQ cQuery) {
        if (((CqStateImpl)cQuery.getState()).getState() != cqState) {
            cQuery.setCqState(cqState);
            cQuery.getCqBaseRegion().getFilterProfile().setCqState(cQuery);
        }
        if (cqState == 1) {
            this.addToMatchingCqMap((CqQueryImpl)cQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCqMap(CqQueryImpl cq) throws CqExistsException, CqException {
        HashMap<String, CqQueryImpl> cqMap;
        String sCqName = cq.getServerCqName();
        if (logger.isDebugEnabled()) {
            logger.debug("Adding to CQ Repository. CqName : {} ServerCqName : {}", (Object)cq.getName(), (Object)sCqName);
        }
        if ((cqMap = this.cqQueryMap).containsKey(sCqName)) {
            throw new CqExistsException(String.format("A CQ with the given name %s already exists.", sCqName));
        }
        Object object = this.cqQueryMapLock;
        synchronized (object) {
            HashMap<String, CqQueryImpl> tmpCqQueryMap = new HashMap<String, CqQueryImpl>(this.cqQueryMap);
            try {
                tmpCqQueryMap.put(sCqName, cq);
            }
            catch (Exception ex) {
                String errMsg = "Failed to store Continuous Query in the repository. CqName: %s %s";
                Object[] errMsgArgs = new Object[]{sCqName, ex.getLocalizedMessage()};
                String s = String.format(errMsg, errMsgArgs);
                logger.error(s);
                throw new CqException(s, (Throwable)ex);
            }
            UserAttributes attributes = (UserAttributes)UserAttributes.userAttributes.get();
            if (attributes != null) {
                this.cqNameToUserAttributesMap.put(cq.getName(), attributes);
            }
            this.cqQueryMap = tmpCqQueryMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCq(String cqName) {
        Object object = this.cqQueryMapLock;
        synchronized (object) {
            HashMap<String, CqQueryImpl> tmpCqQueryMap = new HashMap<String, CqQueryImpl>(this.cqQueryMap);
            tmpCqQueryMap.remove(cqName);
            this.cqNameToUserAttributesMap.remove(cqName);
            this.cqQueryMap = tmpCqQueryMap;
        }
    }

    public CqQuery getClientCqFromServer(ClientProxyMembershipID clientProxyId, String clientCqName) {
        HashMap<String, CqQueryImpl> cqMap = this.cqQueryMap;
        return (CqQuery)cqMap.get(this.constructServerCqName(clientCqName, clientProxyId));
    }

    public InternalCqQuery getCq(String cqName) {
        return this.cqQueryMap.get(cqName);
    }

    public Collection<? extends InternalCqQuery> getAllCqs() {
        return this.cqQueryMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends InternalCqQuery> getAllCqs(String regionName) throws CqException {
        String[] cqNames;
        if (regionName == null) {
            throw new IllegalArgumentException(String.format("Null argument %s", "regionName"));
        }
        HashMap<String, ArrayList<String>> hashMap = this.baseRegionToCqNameMap;
        synchronized (hashMap) {
            ArrayList<String> cqs = this.baseRegionToCqNameMap.get(regionName);
            if (cqs == null) {
                return null;
            }
            cqNames = new String[cqs.size()];
            cqs.toArray(cqNames);
        }
        ArrayList<InternalCqQuery> cQueryList = new ArrayList<InternalCqQuery>();
        for (int cqCnt = 0; cqCnt < cqNames.length; ++cqCnt) {
            InternalCqQuery cq = this.getCq(cqNames[cqCnt]);
            if (cq == null) continue;
            cQueryList.add(cq);
        }
        return cQueryList;
    }

    public synchronized void executeAllClientCqs() throws CqException {
        this.executeCqs(this.getAllCqs());
    }

    public synchronized void executeAllRegionCqs(String regionName) throws CqException {
        this.executeCqs(this.getAllCqs(regionName));
    }

    public synchronized void executeCqs(Collection<? extends InternalCqQuery> cqs) throws CqException {
        if (cqs == null) {
            return;
        }
        String cqName = null;
        for (InternalCqQuery internalCqQuery : cqs) {
            InternalCqQuery cq = internalCqQuery;
            if (cq.isClosed() || !cq.isStopped()) continue;
            try {
                cqName = cq.getName();
                cq.execute();
            }
            catch (CqClosedException | QueryException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Failed to execute the CQ, CqName : {} Error : {}", (Object)cqName, (Object)e.getMessage());
            }
        }
    }

    public synchronized void stopAllClientCqs() throws CqException {
        this.stopCqs(this.getAllCqs());
    }

    public synchronized void stopAllRegionCqs(String regionName) throws CqException {
        this.stopCqs(this.getAllCqs(regionName));
    }

    public synchronized void stopCqs(Collection<? extends InternalCqQuery> cqs) throws CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            if (cqs == null) {
                logger.debug("CqService.stopCqs cqs : null");
            } else {
                logger.debug("CqService.stopCqs cqs : ({} queries)", (Object)cqs.size());
            }
        }
        if (cqs == null) {
            return;
        }
        String cqName = null;
        for (InternalCqQuery internalCqQuery : cqs) {
            InternalCqQuery cq = internalCqQuery;
            if (cq.isClosed() || !cq.isRunning()) continue;
            try {
                cqName = cq.getName();
                cq.stop();
            }
            catch (CqClosedException | QueryException e) {
                if (!isDebugEnabled) continue;
                logger.debug("Failed to stop the CQ, CqName : {} Error : {}", (Object)cqName, (Object)e.getMessage());
            }
        }
    }

    public void closeCqs(String regionName) throws CqException {
        Collection<? extends InternalCqQuery> cqs = this.getAllCqs(regionName);
        if (cqs != null) {
            String cqName = null;
            for (InternalCqQuery internalCqQuery : cqs) {
                try {
                    cqName = internalCqQuery.getName();
                    if (this.isServer()) {
                        internalCqQuery.close(false);
                        continue;
                    }
                    boolean keepAlive = this.cache.keepDurableSubscriptionsAlive();
                    if (internalCqQuery.isDurable() && keepAlive) {
                        logger.warn("Not sending CQ close to the server as it is a durable CQ");
                        internalCqQuery.close(false);
                        continue;
                    }
                    internalCqQuery.close(true);
                }
                catch (CqClosedException | QueryException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Failed to close the CQ, CqName : {} Error : {}", (Object)cqName, (Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stopCq(String cqName, ClientProxyMembershipID clientId) throws CqException {
        block23: {
            block24: {
                serverCqName = cqName;
                if (clientId != null) {
                    serverCqName = this.constructServerCqName(cqName, clientId);
                    this.removeFromCacheForServerToConstructedCQName(cqName, clientId);
                }
                cQuery = null;
                errMsg = null;
                ex = null;
                cqMap = this.cqQueryMap;
                if (cqMap.containsKey(serverCqName)) break block23;
                if (ex == null) break block24;
                s = String.format(errMsg, new Object[]{cqName});
                if (CqServiceImpl.logger.isDebugEnabled()) {
                    CqServiceImpl.logger.debug(s);
                }
                throw new CqException(s, ex);
            }
            return;
        }
        try {
            cQuery = (ServerCQImpl)this.getCq(serverCqName);
            ** if (ex == null) goto lbl-1000
        }
        catch (CacheLoaderException e1) {
            errMsg = "CQ not found in the cq meta region, CqName: %s";
            ex = e1;
            ** if (ex == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                s = String.format(errMsg, new Object[]{cqName});
                if (CqServiceImpl.logger.isDebugEnabled()) {
                    CqServiceImpl.logger.debug(s);
                }
                throw new CqException(s, ex);
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        catch (TimeoutException e2) {
            errMsg = "Timeout while trying to get CQ from meta region, CqName: %s";
            ex = e2;
            ** if (ex == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                s = String.format(errMsg, new Object[]{cqName});
                if (CqServiceImpl.logger.isDebugEnabled()) {
                    CqServiceImpl.logger.debug(s);
                }
                throw new CqException(s, ex);
            }
lbl-1000:
            // 1 sources

            {
            }
            {
                catch (Throwable var9_14) {
                    if (ex != null) {
                        s = String.format(errMsg, new Object[]{cqName});
                        if (CqServiceImpl.logger.isDebugEnabled()) {
                            CqServiceImpl.logger.debug(s);
                        }
                        throw new CqException(s, ex);
                    }
                    throw var9_14;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            s = String.format(errMsg, new Object[]{cqName});
            if (CqServiceImpl.logger.isDebugEnabled()) {
                CqServiceImpl.logger.debug(s);
            }
            throw new CqException(s, ex);
        }
lbl-1000:
        // 1 sources

        {
        }
        try {
            if (!cQuery.isStopped()) {
                cQuery.stop();
            }
        }
        catch (CqClosedException cce) {
            throw new CqException(cce.getMessage());
        }
        finally {
            this.removeFromMatchingCqMap(cQuery);
        }
        cQuery.getCqBaseRegion().getFilterProfile().stopCq((ServerCQ)cQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void closeCq(String cqName, ClientProxyMembershipID clientProxyId) throws CqException {
        block29: {
            block30: {
                serverCqName = cqName;
                if (clientProxyId != null) {
                    serverCqName = this.constructServerCqName(cqName, clientProxyId);
                    this.removeFromCacheForServerToConstructedCQName(cqName, clientProxyId);
                }
                cQuery = null;
                errMsg = null;
                ex = null;
                cqMap = this.cqQueryMap;
                if (cqMap.containsKey(serverCqName)) break block29;
                if (ex == null) break block30;
                s = String.format(errMsg, new Object[]{cqName});
                if (CqServiceImpl.logger.isDebugEnabled()) {
                    CqServiceImpl.logger.debug(s);
                }
                throw new CqException(s, ex);
            }
            return;
        }
        try {
            cQuery = (ServerCQImpl)cqMap.get(serverCqName);
            ** if (ex == null) goto lbl-1000
        }
        catch (CacheLoaderException e1) {
            errMsg = "CQ not found in the cq meta region, CqName: %s";
            ex = e1;
            ** if (ex == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                s = String.format(errMsg, new Object[]{cqName});
                if (CqServiceImpl.logger.isDebugEnabled()) {
                    CqServiceImpl.logger.debug(s);
                }
                throw new CqException(s, ex);
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        catch (TimeoutException e2) {
            errMsg = "Timeout while trying to get CQ from meta region, CqName: %s";
            ex = e2;
            ** if (ex == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                s = String.format(errMsg, new Object[]{cqName});
                if (CqServiceImpl.logger.isDebugEnabled()) {
                    CqServiceImpl.logger.debug(s);
                }
                throw new CqException(s, ex);
            }
lbl-1000:
            // 1 sources

            {
            }
            {
                catch (Throwable var9_16) {
                    if (ex != null) {
                        s = String.format(errMsg, new Object[]{cqName});
                        if (CqServiceImpl.logger.isDebugEnabled()) {
                            CqServiceImpl.logger.debug(s);
                        }
                        throw new CqException(s, ex);
                    }
                    throw var9_16;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            s = String.format(errMsg, new Object[]{cqName});
            if (CqServiceImpl.logger.isDebugEnabled()) {
                CqServiceImpl.logger.debug(s);
            }
            throw new CqException(s, ex);
        }
lbl-1000:
        // 1 sources

        {
        }
        try {
            block31: {
                cQuery.close(false);
                try {
                    baseRegion = cQuery.getCqBaseRegion();
                    if (baseRegion != null && !baseRegion.isDestroyed() && this.isServer()) {
                        fp = baseRegion.getFilterProfile();
                        if (fp != null) {
                            fp.closeCq((ServerCQ)cQuery);
                        }
                        clientProxy = cQuery.getCacheClientNotifier().getClientProxy(clientProxyId);
                        clientProxy.decCqCount();
                        if (clientProxy.hasNoCq()) {
                            this.stats.decClientsWithCqs();
                        }
                    }
                }
                catch (Exception e) {
                    if (!CqServiceImpl.logger.isDebugEnabled()) break block31;
                    CqServiceImpl.logger.debug("Failed to remove CQ from the base region. CqName : {}", (Object)cqName);
                }
            }
            if (this.isServer()) {
                this.removeFromBaseRegionToCqNameMap(cQuery.getRegionName(), serverCqName);
            }
            if ((baseRegion = cQuery.getCqBaseRegion()).getFilterProfile().getCqCount() <= 0 && CqServiceImpl.logger.isDebugEnabled()) {
                CqServiceImpl.logger.debug("Should update the profile for this partitioned region {} for not requiring old value", (Object)baseRegion);
            }
        }
        catch (CqClosedException cce) {
            throw new CqException(cce.getMessage());
        }
        finally {
            this.removeFromMatchingCqMap(cQuery);
        }
    }

    public void closeAllCqs(boolean clientInitiated) {
        this.closeAllCqs(clientInitiated, this.getAllCqs());
    }

    private void closeAllCqs(boolean clientInitiated, Collection<? extends InternalCqQuery> cqs) {
        this.closeAllCqs(clientInitiated, cqs, this.cache.keepDurableSubscriptionsAlive());
    }

    public void closeAllCqs(boolean clientInitiated, Collection<? extends InternalCqQuery> cqs, boolean keepAlive) {
        if (cqs != null) {
            String cqName = null;
            if (logger.isDebugEnabled()) {
                logger.debug("Closing all CQs, number of CQ to be closed : {}", (Object)cqs.size());
            }
            for (InternalCqQuery internalCqQuery : cqs) {
                try {
                    cqName = internalCqQuery.getName();
                    if (this.isServer()) {
                        internalCqQuery.close(false);
                        continue;
                    }
                    if (clientInitiated) {
                        internalCqQuery.close(true);
                        continue;
                    }
                    if (!this.isServer() && internalCqQuery.isDurable() && keepAlive) {
                        logger.warn("Not sending CQ close to the server as it is a durable CQ");
                        internalCqQuery.close(false);
                        continue;
                    }
                    internalCqQuery.close(true);
                }
                catch (CqClosedException | QueryException e) {
                    if (!this.isRunning()) {
                        logger.warn("Failed to close CQ %s %s", (Object)cqName, (Object)e.getMessage());
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(e.getMessage(), e);
                }
            }
        }
    }

    public CqServiceStatistics getCqStatistics() {
        return this.cqServiceStats;
    }

    public void closeClientCqs(ClientProxyMembershipID clientProxyId) throws CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Closing Client CQs for the client: {}", (Object)clientProxyId);
        }
        List<ServerCQ> cqs = this.getAllClientCqs(clientProxyId);
        for (ServerCQ cq : cqs) {
            CqQueryImpl cQuery = (CqQueryImpl)cq;
            try {
                cQuery.close(false);
            }
            catch (CqClosedException | QueryException e) {
                if (!isDebugEnabled) continue;
                logger.debug("Failed to close the CQ, CqName : {} Error : {}", (Object)cQuery.getName(), (Object)e.getMessage());
            }
        }
    }

    public List<ServerCQ> getAllClientCqs(ClientProxyMembershipID clientProxyId) {
        Collection<? extends InternalCqQuery> cqs = this.getAllCqs();
        ArrayList<ServerCQ> clientCqs = new ArrayList<ServerCQ>();
        for (InternalCqQuery internalCqQuery : cqs) {
            ServerCQImpl cQuery = (ServerCQImpl)internalCqQuery;
            ClientProxyMembershipID id = cQuery.getClientProxyId();
            if (id == null || !id.equals((Object)clientProxyId)) continue;
            clientCqs.add(cQuery);
        }
        return clientCqs;
    }

    public List<String> getAllDurableClientCqs(ClientProxyMembershipID clientProxyId) throws CqException {
        if (clientProxyId == null) {
            throw new CqException(String.format("Unable to retrieve durable CQs for client proxy id %s", clientProxyId));
        }
        List<ServerCQ> cqs = this.getAllClientCqs(clientProxyId);
        ArrayList<String> durableClientCqs = new ArrayList<String>();
        for (ServerCQ cq : cqs) {
            ClientProxyMembershipID id;
            ServerCQImpl cQuery = (ServerCQImpl)cq;
            if (cQuery == null || !cQuery.isDurable() || (id = cQuery.getClientProxyId()) == null || !id.equals((Object)clientProxyId)) continue;
            durableClientCqs.add(cQuery.getName());
        }
        return durableClientCqs;
    }

    public void closeNonDurableClientCqs(ClientProxyMembershipID clientProxyId) throws CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Closing Client CQs for the client: {}", (Object)clientProxyId);
        }
        List<ServerCQ> cqs = this.getAllClientCqs(clientProxyId);
        for (ServerCQ cq : cqs) {
            ServerCQImpl cQuery = (ServerCQImpl)cq;
            try {
                if (cQuery.isDurable()) continue;
                cQuery.close(false);
            }
            catch (CqClosedException | QueryException e) {
                if (!isDebugEnabled) continue;
                logger.debug("Failed to close the CQ, CqName : {} Error : {}", (Object)cQuery.getName(), (Object)e.getMessage());
            }
        }
    }

    public boolean isServer() {
        return !this.cache.getCacheServers().isEmpty();
    }

    public void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing CqService. {}", (Object)this);
        }
        this.closeAllCqs(false);
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        this.isRunning = true;
    }

    public String constructServerCqName(String cqName, ClientProxyMembershipID clientProxyId) {
        ConcurrentHashMap cache = (ConcurrentHashMap)JavaWorkarounds.computeIfAbsent(serverCqNameCache, (Object)cqName, key -> new ConcurrentHashMap());
        String cName = (String)cache.get(clientProxyId);
        if (null == cName) {
            StringBuilder sb = new StringBuilder(cqName).append("__");
            if (clientProxyId.isDurable()) {
                sb.append(clientProxyId.getDurableId());
            } else {
                sb.append(clientProxyId.getDSMembership());
            }
            cName = sb.toString();
            cache.put(clientProxyId, cName);
        }
        return cName;
    }

    private void removeFromCacheForServerToConstructedCQName(String cqName, ClientProxyMembershipID clientProxyMembershipID) {
        ConcurrentHashMap<ClientProxyMembershipID, String> cache = serverCqNameCache.get(cqName);
        if (cache != null) {
            cache.remove(clientProxyMembershipID);
            if (cache.size() == 0) {
                serverCqNameCache.remove(cqName);
            }
        }
    }

    private synchronized boolean isCqExists(String cqName) {
        HashMap<String, CqQueryImpl> cqMap = this.cqQueryMap;
        return cqMap.containsKey(cqName);
    }

    private synchronized String generateCqName() {
        String cqName;
        while (this.isCqExists(cqName = CQ_NAME_PREFIX + this.cqId++)) {
        }
        return cqName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchCqListeners(HashMap<String, Integer> cqs, int messageType, Object key, Object value, byte[] delta, QueueManager qManager, EventID eventId) {
        Object[] fullValue = new Object[1];
        Iterator<Map.Entry<String, Integer>> iter = cqs.entrySet().iterator();
        String cqName = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        while (iter.hasNext()) {
            try {
                Map.Entry<String, Integer> entry = iter.next();
                cqName = entry.getKey();
                ClientCQImpl cQuery = (ClientCQImpl)this.getCq(cqName);
                if (cQuery == null || !cQuery.isRunning() && cQuery.getQueuedEvents() == null) {
                    if (!isDebugEnabled) continue;
                    logger.debug("Unable to invoke CqListener, {}, CqName : {}", (Object)(cQuery == null ? "CQ not found" : " CQ is Not running"), (Object)cqName);
                    continue;
                }
                Integer cqOp = entry.getValue();
                if (cqOp == 11) {
                    try {
                        cQuery.close(false);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                CqEventImpl cqEvent = new CqEventImpl((CqQuery)cQuery, this.getOperation(messageType), this.getOperation(cqOp), key, value, delta, qManager, eventId);
                cQuery.updateStats(cqEvent);
                if (cQuery.getQueuedEvents() != null) {
                    Object object = cQuery.queuedEventsSynchObject;
                    synchronized (object) {
                        ConcurrentLinkedQueue<CqEventImpl> queuedEvents = cQuery.getQueuedEvents();
                        if (queuedEvents != null) {
                            if (isDebugEnabled) {
                                logger.debug("Queueing event for key: {}", key);
                            }
                            cQuery.getVsdStats().incQueuedCqListenerEvents();
                            queuedEvents.add(cqEvent);
                            continue;
                        }
                    }
                }
                this.invokeListeners(cqName, cQuery, cqEvent, fullValue);
                if (value != null) continue;
                value = fullValue[0];
            }
            catch (Throwable t) {
                logger.warn(String.format("Error processing CqListener for cq: %s", cqName), t);
                if (!(t instanceof VirtualMachineError)) continue;
                logger.warn(String.format("VirtualMachineError processing CqListener for cq: %s", cqName), t);
                return;
            }
        }
    }

    void invokeListeners(String cqName, ClientCQImpl cQuery, CqEventImpl cqEvent) {
        this.invokeListeners(cqName, cQuery, cqEvent, null);
    }

    private void invokeListeners(String cqName, ClientCQImpl cQuery, CqEventImpl cqEvent, Object[] fullValue) {
        if (!cQuery.isRunning() || cQuery.getCqAttributes() == null) {
            return;
        }
        CqListener[] cqListeners = cQuery.getCqAttributes().getCqListeners();
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Invoking CQ listeners for {}, number of listeners : {} cqEvent : {}", (Object)cqName, (Object)cqListeners.length, (Object)cqEvent);
        }
        for (int lCnt = 0; lCnt < cqListeners.length; ++lCnt) {
            try {
                if (cqListeners[lCnt] == null) continue;
                cQuery.getVsdStats().incNumCqListenerInvocations();
                try {
                    if (cqEvent.getThrowable() != null) {
                        cqListeners[lCnt].onError((CqEvent)cqEvent);
                        continue;
                    }
                    cqListeners[lCnt].onEvent((CqEvent)cqEvent);
                }
                catch (InvalidDeltaException ide) {
                    if (isDebugEnabled) {
                        logger.debug("CqService.dispatchCqListeners(): Requesting full value...");
                    }
                    Part result = (Part)GetEventValueOp.executeOnPrimary((ExecutablePool)cqEvent.getQueueManager().getPool(), (EventID)cqEvent.getEventID(), null);
                    Object newVal = result.getObject();
                    if (result == null || newVal == null) {
                        if (this.cache.getCancelCriterion().isCancelInProgress()) continue;
                        Exception ex = new Exception("Failed to retrieve full value from server for eventID " + cqEvent.getEventID());
                        logger.warn("Exception in the CqListener of the CQ, CqName: {} Error : {}", new Object[]{cqName, ex.getMessage()});
                        if (!isDebugEnabled) continue;
                        logger.debug(ex.getMessage(), (Throwable)ex);
                        continue;
                    }
                    this.cache.getCachePerfStats().incDeltaFullValuesRequested();
                    cqEvent = new CqEventImpl((CqQuery)cQuery, cqEvent.getBaseOperation(), cqEvent.getQueryOperation(), cqEvent.getKey(), newVal, cqEvent.getDeltaValue(), cqEvent.getQueueManager(), cqEvent.getEventID());
                    if (cqEvent.getThrowable() != null) {
                        cqListeners[lCnt].onError((CqEvent)cqEvent);
                    } else {
                        cqListeners[lCnt].onEvent((CqEvent)cqEvent);
                    }
                    if (fullValue == null) continue;
                    fullValue[0] = newVal;
                }
                continue;
            }
            catch (Exception ex) {
                if (this.cache.getCancelCriterion().isCancelInProgress()) continue;
                logger.warn("Exception in the CqListener of the CQ, CqName: {} Error : {}", new Object[]{cqName, ex.getMessage()});
                if (!isDebugEnabled) continue;
                logger.debug(ex.getMessage(), (Throwable)ex);
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure((Error)err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn("Runtime Exception in the CqListener of the CQ, CqName: {} Error : {}", new Object[]{cqName, t.getLocalizedMessage()});
                if (!isDebugEnabled) continue;
                logger.debug(t.getMessage(), t);
            }
        }
    }

    private void invokeCqConnectedListeners(String cqName, ClientCQImpl cQuery, boolean connected) {
        if (!cQuery.isRunning() || cQuery.getCqAttributes() == null) {
            return;
        }
        cQuery.setConnected(connected);
        CqListener[] cqListeners = cQuery.getCqAttributes().getCqListeners();
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking CQ status listeners for {}, number of listeners : {}", (Object)cqName, (Object)cqListeners.length);
        }
        for (int lCnt = 0; lCnt < cqListeners.length; ++lCnt) {
            try {
                if (cqListeners[lCnt] == null || !(cqListeners[lCnt] instanceof CqStatusListener)) continue;
                CqStatusListener listener = (CqStatusListener)cqListeners[lCnt];
                if (connected) {
                    listener.onCqConnected();
                    continue;
                }
                listener.onCqDisconnected();
                continue;
            }
            catch (Exception ex) {
                if (this.cache.getCancelCriterion().isCancelInProgress()) continue;
                logger.warn("Exception in the CqListener of the CQ, CqName: {} Error : {}", new Object[]{cqName, ex.getMessage()});
                if (!logger.isDebugEnabled()) continue;
                logger.debug(ex.getMessage(), (Throwable)ex);
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure((Error)err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn("Runtime Exception in the CqListener of the CQ, CqName: {} Error : {}", new Object[]{cqName, t.getLocalizedMessage()});
                if (!logger.isDebugEnabled()) continue;
                logger.debug(t.getMessage(), t);
            }
        }
    }

    private Operation getOperation(int eventType) {
        Operation op = null;
        switch (eventType) {
            case 27: {
                op = Operation.CREATE;
                break;
            }
            case 28: {
                op = Operation.UPDATE;
                break;
            }
            case 16: {
                op = Operation.DESTROY;
                break;
            }
            case 15: {
                op = Operation.INVALIDATE;
                break;
            }
            case 36: {
                op = Operation.REGION_CLEAR;
                break;
            }
            case 55: {
                op = Operation.REGION_INVALIDATE;
            }
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvents(CacheEvent event, DistributionAdvisor.Profile localProfile, DistributionAdvisor.Profile[] profiles, FilterRoutingInfo frInfo) throws CqException {
        if (event instanceof RegionEvent) {
            this.processRegionEvent(event, localProfile, profiles, frInfo);
        } else {
            Boolean initialPdxReadSerialized = this.cache.getPdxReadSerializedOverride();
            this.cache.setPdxReadSerializedOverride(true);
            try {
                this.processEntryEvent(event, localProfile, profiles, frInfo);
            }
            finally {
                this.cache.setPdxReadSerializedOverride(initialPdxReadSerialized.booleanValue());
            }
        }
    }

    private void processRegionEvent(CacheEvent event, DistributionAdvisor.Profile localProfile, DistributionAdvisor.Profile[] profiles, FilterRoutingInfo frInfo) throws CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("CQ service processing region event {}", (Object)event);
        }
        Integer cqRegionEvent = this.generateCqRegionEvent(event);
        for (int i = -1; i < profiles.length; ++i) {
            FilterProfile pf;
            CacheDistributionAdvisor.CacheProfile cf;
            if (i < 0) {
                cf = (CacheDistributionAdvisor.CacheProfile)localProfile;
                if (cf == null) {
                    continue;
                }
            } else {
                cf = (CacheDistributionAdvisor.CacheProfile)profiles[i];
            }
            if ((pf = cf.filterProfile) == null || pf.getCqMap().isEmpty()) continue;
            Map cqs = pf.getCqMap();
            HashMap<Long, Integer> cqInfo = new HashMap<Long, Integer>();
            for (Map.Entry cqEntry : cqs.entrySet()) {
                ServerCQImpl cQuery;
                block11: {
                    cQuery = (ServerCQImpl)cqEntry.getValue();
                    if (!event.isOriginRemote() && event.getOperation().isRegionDestroy() && !((LocalRegion)event.getRegion()).isUsedForPartitionedRegionBucket()) {
                        try {
                            if (isDebugEnabled) {
                                logger.debug("Closing CQ on region destroy event. CqName : {}", (Object)cQuery.getName());
                            }
                            cQuery.close(false);
                        }
                        catch (Exception ex) {
                            if (!isDebugEnabled) break block11;
                            logger.debug("Failed to Close CQ on region destroy. CqName : {}", (Object)cQuery.getName(), (Object)ex);
                        }
                    }
                }
                cqInfo.put(cQuery.getFilterID(), cqRegionEvent);
                cQuery.getVsdStats().updateStats(cqRegionEvent);
            }
            if (pf.isLocalProfile()) {
                frInfo.setLocalCqInfo(cqInfo);
                continue;
            }
            frInfo.setCqRoutingInfo(cf.getDistributedMember(), cqInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntryEvent(CacheEvent event, DistributionAdvisor.Profile localProfile, DistributionAdvisor.Profile[] profiles, FilterRoutingInfo frInfo) throws CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        HashSet<Object> cqUnfilteredEventsSet_newValue = new HashSet<Object>();
        HashSet<Object> cqUnfilteredEventsSet_oldValue = new HashSet<Object>();
        EntryEvent entryEvent = (EntryEvent)event;
        Object eventKey = entryEvent.getKey();
        boolean isDupEvent = ((EntryEventImpl)event).isPossibleDuplicate();
        boolean opRequiringQueryOnOldValue = event.getOperation().isUpdate() || event.getOperation().isDestroy() || event.getOperation().isInvalidate() || event.getOperation().isCreate() && isDupEvent;
        HashMap<String, Integer> matchedCqs = new HashMap<String, Integer>();
        for (int i = -1; i < profiles.length; ++i) {
            Object newValue;
            FilterProfile pf;
            CacheDistributionAdvisor.CacheProfile cf;
            if (i < 0) {
                cf = (CacheDistributionAdvisor.CacheProfile)localProfile;
                if (cf == null) {
                    continue;
                }
            } else {
                cf = (CacheDistributionAdvisor.CacheProfile)profiles[i];
            }
            if ((pf = cf.filterProfile) == null || pf.getCqMap().isEmpty()) continue;
            Map cqs = pf.getCqMap();
            if (isDebugEnabled) {
                logger.debug("Profile for {} processing {} CQs", (Object)cf.peerMemberId, (Object)cqs.size());
            }
            if (cqs.isEmpty()) continue;
            if (cqUnfilteredEventsSet_newValue.isEmpty() && (event.getOperation().isCreate() || event.getOperation().isUpdate()) && (newValue = entryEvent.getNewValue()) != null) {
                cqUnfilteredEventsSet_newValue.add(newValue);
            }
            HashMap<Long, Integer> cqInfo = new HashMap<Long, Integer>();
            for (Map.Entry cqEntry : cqs.entrySet()) {
                Integer cqEvent;
                Long filterID;
                ServerCQImpl cQuery;
                block40: {
                    boolean error;
                    String cqName;
                    boolean b_cqResults_oldValue;
                    boolean b_cqResults_newValue;
                    block37: {
                        boolean queryOldValue;
                        block38: {
                            block39: {
                                cQuery = (ServerCQImpl)cqEntry.getValue();
                                b_cqResults_newValue = false;
                                b_cqResults_oldValue = false;
                                queryOldValue = false;
                                if (cQuery == null) continue;
                                cqName = cQuery.getServerCqName();
                                filterID = cQuery.getFilterID();
                                if (isDebugEnabled) {
                                    logger.debug("Processing CQ : {} Key: {}", (Object)cqName, eventKey);
                                }
                                cqEvent = null;
                                if (!matchedCqs.containsKey(cqName)) break block38;
                                cqEvent = (Integer)matchedCqs.get(cqName);
                                if (isDebugEnabled) {
                                    logger.debug("query {} has already been processed and returned {}", (Object)cqName, (Object)cqEvent);
                                }
                                if (cqEvent == null) continue;
                                if (cqEvent != 27 && cqEvent != 28) break block39;
                                cQuery.addToCqResultKeys(eventKey);
                                break block40;
                            }
                            if (cqEvent != 16) break block40;
                            cQuery.markAsDestroyedInCqResultKeys(eventKey);
                            break block40;
                        }
                        error = false;
                        try {
                            Object oldValue;
                            long executionStartTime;
                            ServerCQImpl serverCQImpl = cQuery;
                            synchronized (serverCQImpl) {
                                if (!cqUnfilteredEventsSet_newValue.isEmpty()) {
                                    executionStartTime = this.stats.startCqQueryExecution();
                                    b_cqResults_newValue = this.evaluateQuery(cQuery, new Object[]{cqUnfilteredEventsSet_newValue});
                                    this.stats.endCqQueryExecution(executionStartTime);
                                }
                            }
                            if (!opRequiringQueryOnOldValue) break block37;
                            if (cQuery.cqResultKeysInitialized) {
                                b_cqResults_oldValue = cQuery.isPartOfCqResult(eventKey);
                                if (!(!cQuery.isPR && EXECUTE_QUERY_DURING_INIT || b_cqResults_oldValue)) {
                                    queryOldValue = true;
                                }
                                if (isDebugEnabled && !cQuery.isPR && !b_cqResults_oldValue) {
                                    logger.debug("Event Key not found in the CQ Result Queue. EventKey : {} CQ Name : {}", eventKey, (Object)cqName);
                                }
                            } else {
                                queryOldValue = true;
                            }
                            if (!queryOldValue) break block37;
                            if (cqUnfilteredEventsSet_oldValue.isEmpty() && (oldValue = entryEvent.getOldValue()) != null) {
                                cqUnfilteredEventsSet_oldValue.add(oldValue);
                            }
                            oldValue = cQuery;
                            synchronized (oldValue) {
                                if (!cqUnfilteredEventsSet_oldValue.isEmpty()) {
                                    executionStartTime = this.stats.startCqQueryExecution();
                                    b_cqResults_oldValue = this.evaluateQuery(cQuery, new Object[]{cqUnfilteredEventsSet_oldValue});
                                    this.stats.endCqQueryExecution(executionStartTime);
                                } else if (isDebugEnabled) {
                                    logger.debug("old value for event with key {} is null - query execution not performed", eventKey);
                                }
                            }
                        }
                        catch (Exception ex) {
                            error = true;
                            logger.info("Error while processing CQ on the event, key : {} CqName: {}, Error: {}", new Object[]{((EntryEvent)event).getKey(), cQuery.getName(), ex.getLocalizedMessage()});
                        }
                    }
                    if (error) {
                        cqEvent = MESSAGE_TYPE_EXCEPTION;
                    } else if (b_cqResults_newValue) {
                        cqEvent = b_cqResults_oldValue ? MESSAGE_TYPE_LOCAL_UPDATE : MESSAGE_TYPE_LOCAL_CREATE;
                        cQuery.addToCqResultKeys(eventKey);
                    } else if (b_cqResults_oldValue) {
                        cqEvent = MESSAGE_TYPE_LOCAL_DESTROY;
                        cQuery.markAsDestroyedInCqResultKeys(eventKey);
                    }
                    String query = cQuery.getQueryString();
                    Set matchingCqs = (Set)this.matchingCqMap.get(query);
                    if (matchingCqs != null) {
                        for (String matchingCqName : matchingCqs) {
                            if (matchingCqName.equals(cqName)) continue;
                            matchedCqs.put(matchingCqName, cqEvent);
                            if (!isDebugEnabled) continue;
                            logger.debug("Adding CQ into Matching CQ Map: {} Event is: {}", (Object)matchingCqName, (Object)cqEvent);
                        }
                    }
                }
                if (cqEvent == null || !cQuery.isRunning()) continue;
                if (isDebugEnabled) {
                    logger.debug("Added event to CQ with client-side name: {} key: {} operation : {}", (Object)cQuery.cqName, eventKey, (Object)cqEvent);
                }
                cqInfo.put(filterID, cqEvent);
                CqQueryVsdStats stats = cQuery.getVsdStats();
                if (stats == null) continue;
                stats.updateStats(cqEvent);
            }
            if (cqInfo.size() <= 0) continue;
            if (pf.isLocalProfile()) {
                if (isDebugEnabled) {
                    logger.debug("Setting local CQ matches to {}", cqInfo);
                }
                frInfo.setLocalCqInfo(cqInfo);
                continue;
            }
            if (isDebugEnabled) {
                logger.debug("Setting CQ matches for {} to {}", (Object)cf.getDistributedMember(), cqInfo);
            }
            frInfo.setCqRoutingInfo(cf.getDistributedMember(), cqInfo);
        }
    }

    private Integer generateCqRegionEvent(CacheEvent event) {
        Integer cqEvent = null;
        if (event.getOperation().isRegionDestroy()) {
            cqEvent = 11;
        } else if (event.getOperation().isRegionInvalidate()) {
            cqEvent = 55;
        } else if (event.getOperation().isClear()) {
            cqEvent = 36;
        }
        return cqEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBaseRegionToCqNameMap(String regionName, String cqName) {
        HashMap<String, ArrayList<String>> hashMap = this.baseRegionToCqNameMap;
        synchronized (hashMap) {
            ArrayList<String> cqs = this.baseRegionToCqNameMap.get(regionName);
            if (cqs == null) {
                cqs = new ArrayList();
            }
            cqs.add(cqName);
            this.baseRegionToCqNameMap.put(regionName, cqs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromBaseRegionToCqNameMap(String regionName, String cqName) {
        HashMap<String, ArrayList<String>> hashMap = this.baseRegionToCqNameMap;
        synchronized (hashMap) {
            ArrayList<String> cqs = this.baseRegionToCqNameMap.get(regionName);
            if (cqs != null) {
                cqs.remove(cqName);
                if (cqs.isEmpty()) {
                    this.baseRegionToCqNameMap.remove(regionName);
                } else {
                    this.baseRegionToCqNameMap.put(regionName, cqs);
                }
            }
        }
    }

    public CqServiceVsdStats getCqServiceVsdStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToMatchingCqMap(CqQueryImpl cq) {
        ConcurrentHashMap concurrentHashMap = this.matchingCqMap;
        synchronized (concurrentHashMap) {
            Set matchingCQs;
            String cqQuery = cq.getQueryString();
            if (!this.matchingCqMap.containsKey(cqQuery)) {
                matchingCQs = Collections.newSetFromMap(new ConcurrentHashMap());
                this.matchingCqMap.put(cqQuery, matchingCQs);
                this.stats.incUniqueCqQuery();
            } else {
                matchingCQs = (Set)this.matchingCqMap.get(cqQuery);
            }
            matchingCQs.add(cq.getServerCqName());
            if (logger.isDebugEnabled()) {
                logger.debug("Adding CQ into MatchingCQ map, CQName: {} Number of matched querys are: {}", (Object)cq.getServerCqName(), (Object)matchingCQs.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMatchingCqMap(CqQueryImpl cq) {
        ConcurrentHashMap concurrentHashMap = this.matchingCqMap;
        synchronized (concurrentHashMap) {
            String cqQuery = cq.getQueryString();
            if (this.matchingCqMap.containsKey(cqQuery)) {
                Set matchingCQs = (Set)this.matchingCqMap.get(cqQuery);
                matchingCQs.remove(cq.getServerCqName());
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing CQ from MatchingCQ map, CQName: {} Number of matched querys are: {}", (Object)cq.getServerCqName(), (Object)matchingCQs.size());
                }
                if (matchingCQs.isEmpty()) {
                    this.matchingCqMap.remove(cqQuery);
                    this.stats.decUniqueCqQuery();
                }
            }
        }
    }

    public Map<String, HashSet<String>> getMatchingCqMap() {
        return this.matchingCqMap;
    }

    private boolean evaluateQuery(CqQueryImpl cQuery, Object[] event) throws Exception {
        ExecutionContext execContext = cQuery.getQueryExecutionContext();
        execContext.reset();
        execContext.setBindArguments(event);
        boolean status = false;
        if (execContext.getScopeNum() <= 0) {
            SelectResults results = (SelectResults)((DefaultQuery)cQuery.getQuery()).executeUsingContext(execContext);
            if (results != null && results.size() > 0) {
                status = true;
            }
        } else {
            CompiledSelect cs = ((DefaultQuery)cQuery.getQuery()).getSelect();
            status = cs.evaluateCq(execContext);
        }
        return status;
    }

    public UserAttributes getUserAttributes(String cqName) {
        return this.cqNameToUserAttributesMap.get(cqName);
    }

    public void cqsDisconnected(Pool pool) {
        this.invokeCqsConnected(pool, false);
    }

    public void cqsConnected(Pool pool) {
        this.invokeCqsConnected(pool, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeCqsConnected(Pool pool, boolean connected) {
        String poolName = pool.getName();
        HashMap<String, Boolean> hashMap = this.cqPoolsConnected;
        synchronized (hashMap) {
            if (this.cqPoolsConnected.containsKey(poolName) && connected == this.cqPoolsConnected.get(poolName)) {
                return;
            }
            this.cqPoolsConnected.put(poolName, connected);
            Collection<? extends InternalCqQuery> cqs = this.getAllCqs();
            String cqName = null;
            boolean isDebugEnabled = logger.isDebugEnabled();
            for (InternalCqQuery internalCqQuery : cqs) {
                try {
                    ClientCQImpl cQuery;
                    if (internalCqQuery == null || (cQuery = (ClientCQImpl)this.getCq(cqName = internalCqQuery.getName())) == null || cQuery.getCQProxy() == null) continue;
                    InternalPool cqPool = cQuery.getCQProxy().getPool();
                    if (cQuery.isConnected() == connected || !cqPool.getName().equals(poolName)) continue;
                    if (!cQuery.isRunning() && cQuery.getQueuedEvents() == null) {
                        if (!isDebugEnabled) continue;
                        logger.debug("Unable to invoke CqListener, CQ is Not running, CqName : {}", (Object)cqName);
                        continue;
                    }
                    this.invokeCqConnectedListeners(cqName, cQuery, connected);
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.warn("Error while sending connection status to cq listeners", t);
                }
            }
        }
    }

    public List<String> getAllDurableCqsFromServer(InternalPool pool) {
        return new ServerCQProxyImpl(pool).getAllDurableCqsFromServer();
    }
}

