/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.cq;

import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.CqServiceImpl;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.cache.query.internal.cq.ServerCQImpl;
import org.apache.geode.cache.query.internal.cq.spi.CqServiceFactory;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.CommandInitializer;
import org.apache.geode.internal.cache.tier.sockets.command.CloseCQ;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteCQ;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteCQ61;
import org.apache.geode.internal.cache.tier.sockets.command.GetCQStats;
import org.apache.geode.internal.cache.tier.sockets.command.GetDurableCQs;
import org.apache.geode.internal.cache.tier.sockets.command.MonitorCQ;
import org.apache.geode.internal.cache.tier.sockets.command.StopCQ;

public class CqServiceFactoryImpl
implements CqServiceFactory {
    public void initialize() {
        HashMap<Version, Command> versions = new HashMap<Version, Command>();
        versions.put(Version.GFE_57, ExecuteCQ.getCommand());
        versions.put(Version.GFE_61, ExecuteCQ61.getCommand());
        CommandInitializer.registerCommand((int)42, versions);
        CommandInitializer.registerCommand((int)43, versions);
        CommandInitializer.registerCommand((int)48, Collections.singletonMap(Version.GFE_57, GetCQStats.getCommand()));
        CommandInitializer.registerCommand((int)49, Collections.singletonMap(Version.GFE_57, MonitorCQ.getCommand()));
        CommandInitializer.registerCommand((int)44, Collections.singletonMap(Version.GFE_57, StopCQ.getCommand()));
        CommandInitializer.registerCommand((int)45, Collections.singletonMap(Version.GFE_57, CloseCQ.getCommand()));
        CommandInitializer.registerCommand((int)105, Collections.singletonMap(Version.GFE_70, GetDurableCQs.getCommand()));
    }

    public CqService create(GemFireCacheImpl cache) {
        return new CqServiceImpl((Cache)cache);
    }

    public ServerCQ readCqQuery(DataInput in) throws ClassNotFoundException, IOException {
        ServerCQImpl cq = new ServerCQImpl();
        cq.fromData(in);
        return cq;
    }
}

