/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.query.internal.cq.CqService;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.BaseCQCommand;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GetDurableCQs
extends BaseCQCommand {
    private static final GetDurableCQs singleton = new GetDurableCQs();

    public static Command getCommand() {
        return singleton;
    }

    private GetDurableCQs() {
    }

    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        AcceptorImpl acceptor = servConn.getAcceptor();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        ClientProxyMembershipID id = servConn.getProxyID();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received {} request from {}", new Object[]{servConn.getName(), MessageType.getString((int)msg.getMessageType()), servConn.getSocketString()});
        }
        DefaultQueryService qService = null;
        CqService cqServiceForExec = null;
        Object query = null;
        Object cqRegionNames = null;
        Object getDurableCqsOperationContext = null;
        Object cqQuery = null;
        try {
            qService = (DefaultQueryService)((GemFireCacheImpl)crHelper.getCache()).getLocalQueryService();
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                authzRequest.getDurableCQsAuthorize();
            }
            cqServiceForExec = qService.getCqService();
            List durableCqs = cqServiceForExec.getAllDurableClientCqs(id);
            ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
            chunkedResponseMsg.setMessageType(1);
            chunkedResponseMsg.setTransactionId(msg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            ArrayList durableCqList = new ArrayList(maximumChunkSize);
            boolean isTraceEnabled = logger.isTraceEnabled();
            for (Object durableCqName : durableCqs) {
                durableCqList.add(durableCqName);
                if (isTraceEnabled) {
                    logger.trace("{}: getDurableCqsResponse <{}>; list size was {}", new Object[]{servConn.getName(), durableCqName, durableCqList.size()});
                }
                if (durableCqList.size() != maximumChunkSize) continue;
                this.sendDurableCqsResponseChunk(durableCqList, false, servConn);
                durableCqList.clear();
            }
            this.sendDurableCqsResponseChunk(durableCqList, true, servConn);
        }
        catch (CqException cqe) {
            GetDurableCQs.sendCqResponse((int)50, (String)"", (int)msg.getTransactionId(), (Throwable)cqe, (ServerConnection)servConn);
            return;
        }
        catch (Exception e) {
            GetDurableCQs.writeChunkedException((Message)msg, (Throwable)e, (boolean)false, (ServerConnection)servConn);
            return;
        }
    }

    private void sendDurableCqsResponseChunk(List list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart((Object)list, false);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} durableCQs response chunk{}", new Object[]{servConn.getName(), lastChunk ? " last " : " ", logger.isTraceEnabled() ? " keys=" + list + " chunk=<" + chunkedResponseMsg + ">" : ""});
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

