/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.query.internal.cq.CqService;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.BaseCQCommand;
import java.io.IOException;

public class GetCQStats
extends BaseCQCommand {
    private static final GetCQStats singleton = new GetCQStats();

    public static Command getCommand() {
        return singleton;
    }

    private GetCQStats() {
    }

    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: Received close all client CQs request from {}", new Object[]{servConn.getName(), servConn.getSocketString()});
        }
        String cqName = msg.getPart(0).getString();
        if (isDebugEnabled) {
            logger.debug("{}: Received close CQ request from {} cqName: {}", new Object[]{servConn.getName(), servConn.getSocketString(), cqName});
        }
        if (cqName == null) {
            String err = "The cqName for the cq stats request is null";
            GetCQStats.sendCqResponse((int)47, (String)err, (int)msg.getTransactionId(), null, (ServerConnection)servConn);
            return;
        }
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
        }
        catch (Exception e) {
            String err = "Exception while Getting the CQ Statistics. ";
            GetCQStats.sendCqResponse((int)50, (String)err, (int)msg.getTransactionId(), (Throwable)e, (ServerConnection)servConn);
            return;
        }
        GetCQStats.sendCqResponse((int)6, (String)"cq stats sent successfully.", (int)msg.getTransactionId(), null, (ServerConnection)servConn);
        servConn.setAsTrue(1);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessGetCqStatsTime(start - oldStart);
    }
}

