/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.cq;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesMutator;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.internal.CompiledBindArgument;
import com.gemstone.gemfire.cache.query.internal.CompiledIteratorDef;
import com.gemstone.gemfire.cache.query.internal.CompiledRegion;
import com.gemstone.gemfire.cache.query.internal.CompiledSelect;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.CqStateImpl;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.cq.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.cq.CqServiceImpl;
import com.gemstone.gemfire.cache.query.internal.cq.CqServiceProvider;
import com.gemstone.gemfire.cache.query.internal.cq.ServerCQ;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ServerCQImpl
extends CqQueryImpl
implements DataSerializable,
ServerCQ {
    private static final Logger logger = LogService.getLogger();
    private volatile HashMap<Object, Object> cqResultKeys;
    private HashSet<Object> destroysWhileCqResultsInProgress;
    public volatile boolean cqResultKeysInitialized = false;
    public volatile boolean isPR = false;
    private ClientProxyMembershipID clientProxyId = null;
    private CacheClientNotifier ccn = null;
    private String serverCqName;
    private Long filterID;

    public ServerCQImpl(CqServiceImpl cqService, String cqName, String queryString, boolean isDurable, String serverCqName) {
        super(cqService, cqName, queryString, isDurable);
        this.serverCqName = serverCqName;
    }

    public ServerCQImpl() {
    }

    public Long getFilterID() {
        return this.filterID;
    }

    public void setFilterID(Long filterID) {
        this.filterID = filterID;
    }

    @Override
    public void setName(String cqName) {
        this.cqName = this.serverCqName = cqName;
    }

    @Override
    public String getServerCqName() {
        return this.serverCqName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void registerCq(ClientProxyMembershipID p_clientProxyId, CacheClientNotifier p_ccn, int p_cqState) throws CqException, RegionNotFoundException {
        clientProxy = null;
        this.clientProxyId = p_clientProxyId;
        if (p_ccn != null) {
            this.ccn = p_ccn;
            clientProxy = p_ccn.getClientProxy(p_clientProxyId, true);
        }
        this.validateCq();
        isDebugEnabled = ServerCQImpl.logger.isDebugEnabled();
        msg = LocalizedStrings.ONE_ARG;
        t = null;
        try {
            this.query = this.constructServerSideQuery();
            if (isDebugEnabled) {
                ServerCQImpl.logger.debug("Server side query for the cq: {} is: {}", new Object[]{this.cqName, this.query.getQueryString()});
            }
            ** if (t == null) goto lbl-1000
        }
        catch (Exception ex) {
            try {
                t = ex;
                msg = ex instanceof ClassNotFoundException != false ? LocalizedStrings.CqQueryImpl_CLASS_NOT_FOUND_EXCEPTION_THE_ANTLRJAR_OR_THE_SPCIFIED_CLASS_MAY_BE_MISSING_FROM_SERVER_SIDE_CLASSPATH_ERROR_0 : LocalizedStrings.CqQueryImpl_ERROR_WHILE_PARSING_THE_QUERY_ERROR_0;
                ** if (t == null) goto lbl-1000
            }
            catch (Throwable var9_12) {
                if (t != null) {
                    s = msg.toLocalizedString(new Object[]{t});
                    if (isDebugEnabled) {
                        ServerCQImpl.logger.debug(s, (Throwable)t);
                    }
                    throw new CqException(s);
                }
                throw var9_12;
            }
lbl-1000:
            // 1 sources

            {
                s = msg.toLocalizedString(new Object[]{t});
                if (isDebugEnabled) {
                    ServerCQImpl.logger.debug(s, (Throwable)t);
                }
                throw new CqException(s);
            }
lbl-1000:
            // 1 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            s = msg.toLocalizedString(new Object[]{t});
            if (isDebugEnabled) {
                ServerCQImpl.logger.debug(s, (Throwable)t);
            }
            throw new CqException(s);
        }
lbl-1000:
        // 1 sources

        {
        }
        this.cqBaseRegion = (LocalRegion)this.cqService.getCache().getRegion(this.regionName);
        if (this.cqBaseRegion == null) {
            throw new RegionNotFoundException(LocalizedStrings.CqQueryImpl_REGION__0_SPECIFIED_WITH_CQ_NOT_FOUND_CQNAME_1.toLocalizedString(new Object[]{this.regionName, this.cqName}));
        }
        dp = this.cqBaseRegion.getDataPolicy();
        this.isPR = dp.withPartitioning();
        if (!this.isPR && !dp.withReplication()) {
            errMsg = null;
            errMsg = dp.withPreloaded() != false && this.cqBaseRegion.getAttributes().getEvictionAttributes() != null && this.cqBaseRegion.getAttributes().getEvictionAttributes().getAction().equals(EvictionAction.LOCAL_DESTROY) != false ? LocalizedStrings.CqQueryImpl_CQ_NOT_SUPPORTED_FOR_REPLICATE_WITH_LOCAL_DESTROY.toString(new Object[]{this.regionName, this.cqBaseRegion.getAttributes().getEvictionAttributes().getAction()}) : "The region " + this.regionName + "  specified in CQ creation is neither replicated nor partitioned; " + "only replicated or partitioned regions are allowed in CQ creation.";
            if (isDebugEnabled) {
                ServerCQImpl.logger.debug(errMsg);
            }
            throw new CqException(errMsg);
        }
        if (dp.withReplication() && !this.cqBaseRegion.getAttributes().getScope().isDistributedAck() && !this.cqBaseRegion.getAttributes().getScope().isGlobal()) {
            errMsg = "The replicated region " + this.regionName + " specified in CQ creation does not have scope supported by CQ." + " The CQ supported scopes are DISTRIBUTED_ACK and GLOBAL.";
            if (isDebugEnabled) {
                ServerCQImpl.logger.debug(errMsg);
            }
            throw new CqException(errMsg);
        }
        if (clientProxy != null) {
            clientProxy.incCqCount();
            if (clientProxy.hasOneCq()) {
                this.cqService.stats.incClientsWithCqs();
            }
            if (isDebugEnabled) {
                ServerCQImpl.logger.debug("Added CQ to the base region: {} With key as: {}", new Object[]{this.cqBaseRegion.getFullPath(), this.serverCqName});
            }
        }
        this.updateCqCreateStats();
        if (this.cqState.getState() != p_cqState) {
            this.setCqState(p_cqState);
        }
        if (p_cqState == 1) {
            this.cqService.addToMatchingCqMap(this);
        }
        if (CqServiceProvider.MAINTAIN_KEYS) {
            this.cqResultKeys = new HashMap<K, V>();
            if (this.isPR) {
                this.setCqResultsCacheInitialized();
            } else {
                this.destroysWhileCqResultsInProgress = new HashSet<E>();
            }
        }
        if (p_ccn != null) {
            try {
                this.cqService.addToCqMap(this);
            }
            catch (CqExistsException cqe) {
                throw new CqException(LocalizedStrings.CqQueryImpl_UNABLE_TO_CREATE_CQ_0_ERROR__1.toLocalizedString(new Object[]{this.cqName, cqe.getMessage()}));
            }
            this.cqBaseRegion.getFilterProfile().registerCq((ServerCQ)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> getCqResultKeyCache() {
        if (this.cqResultKeys != null) {
            HashMap<Object, Object> hashMap = this.cqResultKeys;
            synchronized (hashMap) {
                return Collections.synchronizedSet(new HashSet<Object>(this.cqResultKeys.keySet()));
            }
        }
        return null;
    }

    private Query constructServerSideQuery() throws QueryException {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.cqService.getCache();
        DefaultQuery locQuery = (DefaultQuery)cache.getLocalQueryService().newQuery(this.queryString);
        CompiledSelect select = locQuery.getSimpleSelect();
        CompiledIteratorDef from = (CompiledIteratorDef)select.getIterators().get(0);
        this.regionName = ((CompiledRegion)from.getCollectionExpr()).getRegionPath();
        from.setCollectionExpr((CompiledValue)new CompiledBindArgument(1));
        return locQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPartOfCqResult(Object key) {
        if (this.cqResultKeys == null) {
            logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.CqQueryImpl_Null_CQ_Result_Key_Cache_0));
            return false;
        }
        HashMap<Object, Object> hashMap = this.cqResultKeys;
        synchronized (hashMap) {
            if (this.destroysWhileCqResultsInProgress != null) {
                for (Object k : this.destroysWhileCqResultsInProgress) {
                    this.cqResultKeys.remove(k);
                }
                this.destroysWhileCqResultsInProgress = null;
            }
            return this.cqResultKeys.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCqResultKeys(Object key) {
        if (!CqServiceProvider.MAINTAIN_KEYS) {
            return;
        }
        if (this.cqResultKeys != null) {
            HashMap<Object, Object> hashMap = this.cqResultKeys;
            synchronized (hashMap) {
                this.cqResultKeys.put(key, TOKEN);
                if (!this.cqResultKeysInitialized && this.destroysWhileCqResultsInProgress != null) {
                    this.destroysWhileCqResultsInProgress.remove(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCqResultKeys(Object key, boolean isTokenMode) {
        if (!CqServiceProvider.MAINTAIN_KEYS) {
            return;
        }
        if (this.cqResultKeys != null) {
            HashMap<Object, Object> hashMap = this.cqResultKeys;
            synchronized (hashMap) {
                if (isTokenMode && this.cqResultKeys.get(key) != Token.DESTROYED) {
                    return;
                }
                this.cqResultKeys.remove(key);
                if (!this.cqResultKeysInitialized && this.destroysWhileCqResultsInProgress != null) {
                    this.destroysWhileCqResultsInProgress.add(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsDestroyedInCqResultKeys(Object key) {
        if (!CqServiceProvider.MAINTAIN_KEYS) {
            return;
        }
        if (this.cqResultKeys != null) {
            HashMap<Object, Object> hashMap = this.cqResultKeys;
            synchronized (hashMap) {
                this.cqResultKeys.put(key, Token.DESTROYED);
                if (!this.cqResultKeysInitialized && this.destroysWhileCqResultsInProgress != null) {
                    this.destroysWhileCqResultsInProgress.add(key);
                }
            }
        }
    }

    public void setCqResultsCacheInitialized() {
        if (CqServiceProvider.MAINTAIN_KEYS) {
            this.cqResultKeysInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCqResultKeysSize() {
        if (this.cqResultKeys == null) {
            return 0;
        }
        HashMap<Object, Object> hashMap = this.cqResultKeys;
        synchronized (hashMap) {
            return this.cqResultKeys.size();
        }
    }

    public boolean isOldValueRequiredForQueryProcessing(Object key) {
        return !this.cqResultKeysInitialized || !this.isPartOfCqResult(key);
    }

    public void close() throws CqClosedException, CqException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean sendRequestToServer) throws CqClosedException, CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Started closing CQ CqName: {} SendRequestToServer: {}", new Object[]{this.cqName, sendRequestToServer});
        }
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (this.isClosed()) {
                if (isDebugEnabled) {
                    logger.debug("CQ is already closed, CqName: {}", new Object[]{this.cqName});
                }
                return;
            }
            int stateBeforeClosing = this.cqState.getState();
            this.cqState.setState(3);
            boolean isClosed = false;
            this.removeFromCqMap();
            if (stateBeforeClosing == 1) {
                this.cqService.stats.decCqsActive();
            } else if (stateBeforeClosing == 0) {
                this.cqService.stats.decCqsStopped();
            }
            if (this.cqResultKeys != null) {
                HashMap<Object, Object> hashMap = this.cqResultKeys;
                synchronized (hashMap) {
                    this.cqResultKeys.clear();
                }
            }
            this.cqState.setState(2);
            this.cqService.stats.incCqsClosed();
            this.cqService.stats.decCqsOnClient();
            if (this.stats != null) {
                this.stats.close();
            }
        }
        if (isDebugEnabled) {
            logger.debug("Successfully closed the CQ. {}", new Object[]{this.cqName});
        }
    }

    public ClientProxyMembershipID getClientProxyId() {
        return this.clientProxyId;
    }

    public CacheClientNotifier getCacheClientNotifier() {
        return this.ccn;
    }

    @Override
    protected void cleanup() throws CqException {
        block4: {
            try {
                if (this.cqBaseRegion != null && !this.cqBaseRegion.isDestroyed()) {
                    this.cqBaseRegion.getFilterProfile().closeCq((ServerCQ)this);
                    CacheClientProxy clientProxy = this.ccn.getClientProxy(this.clientProxyId);
                    clientProxy.decCqCount();
                    if (clientProxy.hasNoCq()) {
                        this.cqService.stats.decClientsWithCqs();
                    }
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Failed to remove CQ from the base region. CqName :{}", new Object[]{this.cqName});
            }
        }
    }

    public void setServerCqName(String serverCqName) {
        this.serverCqName = serverCqName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws CqClosedException, CqException {
        boolean isStopped = false;
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (this.isClosed()) {
                throw new CqClosedException(LocalizedStrings.CqQueryImpl_CQ_IS_CLOSED_CQNAME_0.toLocalizedString(new Object[]{this.cqName}));
            }
            if (!this.isRunning()) {
                throw new IllegalStateException(LocalizedStrings.CqQueryImpl_CQ_IS_NOT_IN_RUNNING_STATE_STOP_CQ_DOES_NOT_APPLY_CQNAME_0.toLocalizedString(new Object[]{this.cqName}));
            }
            this.cqState.setState(0);
            this.cqService.stats.incCqsStopped();
            this.cqService.stats.decCqsActive();
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully stopped the CQ. {}", new Object[]{this.cqName});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            this.cqState.setState(DataSerializer.readInteger((DataInput)in).intValue());
        }
        this.isDurable = DataSerializer.readBoolean((DataInput)in);
        this.queryString = DataSerializer.readString((DataInput)in);
        this.filterID = in.readLong();
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeInteger((Integer)this.cqState.getState(), (DataOutput)out);
        DataSerializer.writeBoolean((Boolean)this.isDurable, (DataOutput)out);
        DataSerializer.writeString((String)this.queryString, (DataOutput)out);
        out.writeLong(this.filterID);
    }

    public boolean isPR() {
        return this.isPR;
    }

    public CqAttributes getCqAttributes() {
        throw new IllegalStateException("CQ attributes are not available on the server");
    }

    public CqAttributesMutator getCqAttributesMutator() {
        throw new IllegalStateException("CQ attributes are not available on the server");
    }

    public <E> CqResults<E> executeWithInitialResults() throws CqClosedException, RegionNotFoundException, CqException {
        throw new IllegalStateException("Execute cannot be called on a CQ on the server");
    }

    public void execute() throws CqClosedException, RegionNotFoundException, CqException {
        throw new IllegalStateException("Execute cannot be called on a CQ on the server");
    }
}

