/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.commands.CreateJndiBindingCommand;
import org.apache.geode.management.internal.cli.functions.CreateJndiBindingFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class CreateDataSourceCommand
extends SingleGfshCommand {
    static final String CREATE_DATA_SOURCE = "create data-source";
    static final String CREATE_DATA_SOURCE__HELP = "(Experimental) Creates a JDBC data source and verifies connectivity to an external JDBC database.";
    static final String POOLED_DATA_SOURCE_FACTORY_CLASS = "pooled-data-source-factory-class";
    private static final String DEFAULT_POOLED_DATA_SOURCE_FACTORY_CLASS = "org.apache.geode.connectors.jdbc.JdbcPooledDataSourceFactory";
    static final String POOLED_DATA_SOURCE_FACTORY_CLASS__HELP = "This class will be created, by calling its no-arg constructor, and used as the pool of this data source.  The class must implement org.apache.geode.datasource.PooledDataSourceFactory. Only valid if --pooled. Defaults to: org.apache.geode.connectors.jdbc.JdbcPooledDataSourceFactory";
    static final String URL = "url";
    static final String URL__HELP = "This is the JDBC data source URL string, for example, jdbc:hsqldb:hsql://localhost:1701.";
    static final String NAME = "name";
    static final String NAME__HELP = "Name of the data source to be created.";
    static final String PASSWORD = "password";
    static final String PASSWORD__HELP = "The password that may be required by the external JDBC database when creating a new connection.";
    static final String USERNAME = "username";
    static final String USERNAME__HELP = "The username that may be required by the external JDBC database when creating a new connection.";
    static final String POOLED = "pooled";
    static final String POOLED__HELP = "By default a pooled data source is created. If this option is false then a non-pooled data source is created.";
    static final String IFNOTEXISTS__HELP = "Skip the create operation when a data source with the same name already exists.  Without specifying this option, this command execution results into an error.";
    static final String POOL_PROPERTIES = "pool-properties";
    static final String POOL_PROPERTIES_HELP = "Used to configure pool properties of a pooled data source. Only valid if --pooled is specified.The value is a comma separated list of json strings. Each json string contains a name and value. If the name starts with \"pool.\", then it will be used to configure the pool data source. Otherwise the name value pair will be used to configure the database data source. For example 'pool.name1' configures the pool and 'name2' configures the database in the following: --pool-properties={'name':'pool.name1','value':'value1'},{'name':'name2','value':'value2'}";

    @CliCommand(value={"create data-source"}, help="(Experimental) Creates a JDBC data source and verifies connectivity to an external JDBC database.")
    @CliMetaData(relatedTopic={"Geode"}, interceptor="org.apache.geode.connectors.jdbc.internal.cli.CreateDataSourceInterceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel createDataSource(@CliOption(key={"pooled-data-source-factory-class"}, help="This class will be created, by calling its no-arg constructor, and used as the pool of this data source.  The class must implement org.apache.geode.datasource.PooledDataSourceFactory. Only valid if --pooled. Defaults to: org.apache.geode.connectors.jdbc.JdbcPooledDataSourceFactory") String pooledDataSourceFactoryClass, @CliOption(key={"url"}, mandatory=true, help="This is the JDBC data source URL string, for example, jdbc:hsqldb:hsql://localhost:1701.") String url, @CliOption(key={"name"}, mandatory=true, help="Name of the data source to be created.") String name, @CliOption(key={"username"}, help="The username that may be required by the external JDBC database when creating a new connection.") String username, @CliOption(key={"password"}, help="The password that may be required by the external JDBC database when creating a new connection.") String password, @CliOption(key={"if-not-exists"}, help="Skip the create operation when a data source with the same name already exists.  Without specifying this option, this command execution results into an error.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifNotExists, @CliOption(key={"pooled"}, help="By default a pooled data source is created. If this option is false then a non-pooled data source is created.", specifiedDefaultValue="true", unspecifiedDefaultValue="true") boolean pooled, @CliOption(key={"pool-properties"}, optionContext="splittingRegex=,(?![^{]*\\})", help="Used to configure pool properties of a pooled data source. Only valid if --pooled is specified.The value is a comma separated list of json strings. Each json string contains a name and value. If the name starts with \"pool.\", then it will be used to configure the pool data source. Otherwise the name value pair will be used to configure the database data source. For example 'pool.name1' configures the pool and 'name2' configures the database in the following: --pool-properties={'name':'pool.name1','value':'value1'},{'name':'name2','value':'value2'}") PoolProperty[] poolProperties) {
        CacheConfig cacheConfig;
        InternalConfigurationPersistenceService service;
        JndiBindingsType.JndiBinding configuration = new JndiBindingsType.JndiBinding();
        if (pooled) {
            if (pooledDataSourceFactoryClass == null) {
                pooledDataSourceFactoryClass = DEFAULT_POOLED_DATA_SOURCE_FACTORY_CLASS;
            }
            configuration.setConnPooledDatasourceClass(pooledDataSourceFactoryClass);
        }
        configuration.setConnectionUrl(url);
        configuration.setJndiName(name);
        configuration.setPassword(password);
        if (pooled) {
            configuration.setType(CreateJndiBindingCommand.DATASOURCE_TYPE.POOLED.getType());
        } else {
            configuration.setType(CreateJndiBindingCommand.DATASOURCE_TYPE.SIMPLE.getType());
        }
        configuration.setUserName(username);
        if (poolProperties != null && poolProperties.length > 0) {
            List configProperties = configuration.getConfigProperties();
            for (PoolProperty dataSourceProperty : poolProperties) {
                String propName = dataSourceProperty.getName();
                String propValue = dataSourceProperty.getValue();
                configProperties.add(new JndiBindingsType.JndiBinding.ConfigProperty(propName, "type", propValue));
            }
        }
        if ((service = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService()) != null && (cacheConfig = service.getCacheConfig("cluster")) != null && CacheElement.exists((List)cacheConfig.getJndiBindings(), (String)name)) {
            String message = CliStrings.format((String)"Jndi binding with jndi-name \"{0}\" already exists.", (Object)name);
            return ifNotExists ? ResultModel.createInfo((String)("Skipping: " + message)) : ResultModel.createError((String)message);
        }
        Set targetMembers = this.findMembers(null, null);
        if (targetMembers.size() > 0) {
            Object[] arguments = new Object[]{configuration, true};
            List jndiCreationResult = this.executeAndGetFunctionResult((Function)new CreateJndiBindingFunction(), arguments, targetMembers);
            ResultModel result = ResultModel.createMemberStatusResult((List)jndiCreationResult, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
            result.setConfigObject((Object)configuration);
            return result;
        }
        if (service != null) {
            ResultModel result = ResultModel.createInfo((String)"No members found, data source saved to cluster configuration.");
            result.setConfigObject((Object)configuration);
            return result;
        }
        return ResultModel.createError((String)"No members found and cluster configuration unavailable.");
    }

    public boolean updateConfigForGroup(String group, CacheConfig config, Object element) {
        config.getJndiBindings().add((JndiBindingsType.JndiBinding)element);
        return true;
    }

    @CliAvailabilityIndicator(value={"create data-source"})
    public boolean commandAvailable() {
        return this.isOnlineCommandAvailable();
    }

    public static class PoolProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "PoolProperty [name=" + this.name + ", value=" + this.value + "]";
        }
    }
}

