/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.JdbcWriter;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.RegionMappingNotFoundException;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataManager;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;
import org.apache.geode.connectors.jdbc.internal.configuration.FieldMapping;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.logging.log4j.Logger;

@Experimental
public class JdbcConnectorServiceImpl
implements JdbcConnectorService {
    private static final Logger logger = LogService.getLogger();
    private final Map<String, RegionMapping> mappingsByRegion = new ConcurrentHashMap<String, RegionMapping>();

    @Override
    public Set<RegionMapping> getRegionMappings() {
        HashSet<RegionMapping> regionMappings = new HashSet<RegionMapping>();
        regionMappings.addAll(this.mappingsByRegion.values());
        return regionMappings;
    }

    @Override
    public void createRegionMapping(RegionMapping mapping) throws RegionMappingExistsException {
        RegionMapping existing = this.mappingsByRegion.putIfAbsent(mapping.getRegionName(), mapping);
        if (existing != null) {
            throw new RegionMappingExistsException("JDBC mapping for region " + mapping.getRegionName() + " exists");
        }
    }

    @Override
    public void replaceRegionMapping(RegionMapping alteredMapping) throws RegionMappingNotFoundException {
        RegionMapping existingMapping = this.mappingsByRegion.get(alteredMapping.getRegionName());
        if (existingMapping == null) {
            throw new RegionMappingNotFoundException("JDBC mapping for the region " + alteredMapping.getRegionName() + " was not found");
        }
        this.mappingsByRegion.put(existingMapping.getRegionName(), alteredMapping);
    }

    @Override
    public boolean isMappingSynchronous(String regionName, Cache cache) {
        Region region = cache.getRegion(regionName);
        if (region == null) {
            throw new IllegalStateException("Region for mapping could not be found.");
        }
        return region.getAttributes().getCacheWriter() != null && region.getAttributes().getCacheWriter() instanceof JdbcWriter;
    }

    @Override
    public void validateMapping(RegionMapping regionMapping) {
        DataSource dataSource = this.getDataSource(regionMapping.getDataSourceName());
        if (dataSource == null) {
            throw new JdbcConnectorException("No datasource \"" + regionMapping.getDataSourceName() + "\" found when creating mapping \"" + regionMapping.getRegionName() + "\"");
        }
        this.validateMapping(regionMapping, dataSource);
    }

    @Override
    public void validateMapping(RegionMapping regionMapping, DataSource dataSource) {
        TableMetaDataView metaDataView = this.getTableMetaDataView(regionMapping, dataSource);
        boolean foundDifference = false;
        if (regionMapping.getFieldMappings().size() != metaDataView.getColumnNames().size()) {
            foundDifference = true;
        } else {
            for (FieldMapping fieldMapping : regionMapping.getFieldMappings()) {
                String jdbcName = fieldMapping.getJdbcName();
                if (!metaDataView.getColumnNames().contains(jdbcName)) {
                    foundDifference = true;
                    break;
                }
                if (!metaDataView.getColumnDataType(jdbcName).getName().equals(fieldMapping.getJdbcType())) {
                    foundDifference = true;
                    break;
                }
                if (metaDataView.isColumnNullable(jdbcName) == fieldMapping.isJdbcNullable()) continue;
                foundDifference = true;
                break;
            }
        }
        if (!(foundDifference || regionMapping.getSpecifiedIds() || regionMapping.getIds().equals(String.join((CharSequence)",", metaDataView.getKeyColumnNames())))) {
            foundDifference = true;
        }
        if (foundDifference) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error detected when comparing mapping for region \"" + regionMapping.getRegionName() + "\" with table definition: \n");
            if (!regionMapping.getSpecifiedIds()) {
                sb.append("\nId fields in Field Mappings: " + regionMapping.getIds());
                sb.append("\nId fields in Table MetaData: " + String.join((CharSequence)",", metaDataView.getKeyColumnNames()));
            }
            sb.append("\n\nDefinition from Field Mappings (" + regionMapping.getFieldMappings().size() + " field mappings found):");
            for (FieldMapping fieldMapping : regionMapping.getFieldMappings()) {
                sb.append("\n" + fieldMapping.getJdbcName() + " - " + fieldMapping.getJdbcType());
            }
            sb.append("\n\nDefinition from Table Metadata (" + metaDataView.getColumnNames().size() + " columns found):");
            for (String name : metaDataView.getColumnNames()) {
                sb.append("\n" + name + " - " + metaDataView.getColumnDataType(name));
            }
            sb.append("\n\nDestroy and recreate the JDBC mapping for \"" + regionMapping.getRegionName() + "\" to resolve this error.");
            logger.error(sb.toString());
            throw new JdbcConnectorException("Jdbc mapping for \"" + regionMapping.getRegionName() + "\" does not match table definition, check logs for more details.");
        }
    }

    @Override
    public RegionMapping getMappingForRegion(String regionName) {
        return this.mappingsByRegion.get(regionName);
    }

    @Override
    public void destroyRegionMapping(String regionName) {
        this.mappingsByRegion.remove(regionName);
    }

    public void init(Cache cache) {
    }

    public Class<? extends CacheService> getInterface() {
        return JdbcConnectorService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }

    DataSource getDataSource(String dataSourceName) {
        return JNDIInvoker.getDataSource((String)dataSourceName);
    }

    TableMetaDataManager getTableMetaDataManager() {
        return new TableMetaDataManager();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TableMetaDataView getTableMetaDataView(RegionMapping regionMapping, DataSource dataSource) {
        TableMetaDataManager manager = this.getTableMetaDataManager();
        try (Connection connection = dataSource.getConnection();){
            TableMetaDataView tableMetaDataView = manager.getTableMetaDataView(connection, regionMapping);
            return tableMetaDataView;
        }
        catch (SQLException ex) {
            throw JdbcConnectorException.createException("Exception thrown while connecting to datasource \"" + regionMapping.getDataSourceName() + "\": ", ex);
        }
    }
}

