/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.xml;

import java.util.Stack;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.xml.RegionMappingConfiguration;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.xmlcache.RegionCreation;
import org.xml.sax.Attributes;

public enum ElementType {
    JDBC_MAPPING("mapping"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof RegionCreation)) {
                throw new CacheXmlException("<jdbc:mapping> elements must occur within <region> elements");
            }
            RegionCreation regionCreation = (RegionCreation)stack.peek();
            RegionMapping mapping = new RegionMapping();
            mapping.setRegionName(regionCreation.getFullPath().substring(1));
            mapping.setConnectionConfigName(attributes.getValue("connection-name"));
            mapping.setTableName(attributes.getValue("table"));
            mapping.setPdxName(attributes.getValue("pdx-name"));
            stack.push(mapping);
        }

        @Override
        void endElement(Stack<Object> stack) {
            RegionMapping mapping = (RegionMapping)stack.pop();
            RegionCreation regionCreation = (RegionCreation)stack.peek();
            regionCreation.getExtensionPoint().addExtension((Extension)new RegionMappingConfiguration(mapping));
        }
    };

    private String typeName;

    private ElementType(String typeName) {
        this.typeName = typeName;
    }

    static ElementType getTypeFromName(String typeName) {
        for (ElementType type : ElementType.values()) {
            if (!type.typeName.equals(typeName)) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid type '" + typeName + "'");
    }

    public String getTypeName() {
        return this.typeName;
    }

    abstract void startElement(Stack<Object> var1, Attributes var2);

    abstract void endElement(Stack<Object> var1);
}

