/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.Collection;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.ListMappingFunction;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

@Experimental
public class ListMappingCommand
extends GfshCommand {
    public static final String JDBC_MAPPINGS_SECTION = "jdbc-mappings";
    static final String LIST_MAPPING = "list jdbc-mappings";
    static final String LIST_MAPPING__HELP = "(Experimental) Display jdbc mappings for all members.";
    static final String LIST_OF_MAPPINGS = "List of mappings";
    static final String NO_MAPPINGS_FOUND = "No mappings found";
    static final String LIST_MAPPINGS_MEMBER__HELP = "Member from which the jdbc mappings are retrieved.";

    @CliCommand(value={"list jdbc-mappings"}, help="(Experimental) Display jdbc mappings for all members.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel listMapping() {
        Collection mappings = null;
        Set members = this.findMembers(null, null);
        if (members.size() > 0) {
            DistributedMember targetMember = (DistributedMember)members.iterator().next();
            CliFunctionResult result = this.executeFunctionAndGetFunctionResult((Function)new ListMappingFunction(), null, targetMember);
            if (result != null) {
                mappings = (Collection)result.getResultObject();
            }
        } else {
            return ResultModel.createError((String)"No Members Found");
        }
        ResultModel resultModel = new ResultModel();
        boolean mappingsExist = this.fillTabularResultData(mappings, resultModel.addTable(JDBC_MAPPINGS_SECTION));
        if (mappingsExist) {
            resultModel.setHeader("(Experimental) ");
            return resultModel;
        }
        return ResultModel.createInfo((String)"(Experimental) \nNo mappings found");
    }

    private boolean fillTabularResultData(Collection<RegionMapping> mappings, TabularResultModel tableModel) {
        if (mappings == null) {
            return false;
        }
        for (RegionMapping mapping : mappings) {
            tableModel.accumulate(LIST_OF_MAPPINGS, mapping.getRegionName());
        }
        return !mappings.isEmpty();
    }
}

