/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.RegionMappingNotFoundException;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;

@Experimental
public class JdbcConnectorServiceImpl
implements JdbcConnectorService {
    private final Map<String, RegionMapping> mappingsByRegion = new ConcurrentHashMap<String, RegionMapping>();

    @Override
    public Set<RegionMapping> getRegionMappings() {
        HashSet<RegionMapping> regionMappings = new HashSet<RegionMapping>();
        regionMappings.addAll(this.mappingsByRegion.values());
        return regionMappings;
    }

    @Override
    public void createRegionMapping(RegionMapping mapping) throws RegionMappingExistsException {
        RegionMapping existing = this.mappingsByRegion.putIfAbsent(mapping.getRegionName(), mapping);
        if (existing != null) {
            throw new RegionMappingExistsException("RegionMapping for region " + mapping.getRegionName() + " exists");
        }
    }

    @Override
    public void replaceRegionMapping(RegionMapping alteredMapping) throws RegionMappingNotFoundException {
        RegionMapping existingMapping = this.mappingsByRegion.get(alteredMapping.getRegionName());
        if (existingMapping == null) {
            throw new RegionMappingNotFoundException("RegionMapping for the region " + alteredMapping.getRegionName() + " was not found");
        }
        this.mappingsByRegion.put(existingMapping.getRegionName(), alteredMapping);
    }

    @Override
    public RegionMapping getMappingForRegion(String regionName) {
        return this.mappingsByRegion.get(regionName);
    }

    @Override
    public void destroyRegionMapping(String regionName) {
        this.mappingsByRegion.remove(regionName);
    }

    public void init(Cache cache) {
    }

    public Class<? extends CacheService> getInterface() {
        return JdbcConnectorService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }
}

