/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.xml;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.Cache;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigExistsException;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.xmlcache.XmlGenerator;

public class JdbcServiceConfiguration
implements Extension<Cache> {
    private final List<ConnectorService.Connection> connections = new ArrayList<ConnectorService.Connection>();
    private final List<ConnectorService.RegionMapping> mappings = new ArrayList<ConnectorService.RegionMapping>();

    void addConnectionConfig(ConnectorService.Connection config) {
        this.connections.add(config);
    }

    void addRegionMapping(ConnectorService.RegionMapping mapping) {
        this.mappings.add(mapping);
    }

    public XmlGenerator<Cache> getXmlGenerator() {
        return null;
    }

    public void beforeCreate(Extensible<Cache> source, Cache cache) {
    }

    public void onCreate(Extensible<Cache> source, Extensible<Cache> target) {
        InternalCache internalCache = (InternalCache)target;
        JdbcConnectorService service = (JdbcConnectorService)internalCache.getService(JdbcConnectorService.class);
        this.connections.forEach(connection -> this.createConnectionConfig(service, (ConnectorService.Connection)connection));
        this.mappings.forEach(mapping -> this.createRegionMapping(service, (ConnectorService.RegionMapping)mapping));
    }

    private void createConnectionConfig(JdbcConnectorService service, ConnectorService.Connection connectionConfig) {
        try {
            service.createConnectionConfig(connectionConfig);
        }
        catch (ConnectionConfigExistsException e) {
            throw new InternalGemFireException((Throwable)e);
        }
    }

    private void createRegionMapping(JdbcConnectorService service, ConnectorService.RegionMapping regionMapping) {
        try {
            service.createRegionMapping(regionMapping);
        }
        catch (RegionMappingExistsException e) {
            throw new InternalGemFireException((Throwable)e);
        }
    }
}

