/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.xml;

import java.util.Stack;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.connectors.jdbc.internal.xml.JdbcServiceConfiguration;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.xml.sax.Attributes;

public enum ElementType {
    CONNECTION_SERVICE("connector-service"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof CacheCreation)) {
                throw new CacheXmlException("jdbc <connector-service> elements must occur within <cache> elements");
            }
            CacheCreation cacheCreation = (CacheCreation)stack.peek();
            JdbcServiceConfiguration serviceConfig = new JdbcServiceConfiguration();
            cacheCreation.getExtensionPoint().addExtension((Extension)serviceConfig);
            stack.push(serviceConfig);
        }

        @Override
        void endElement(Stack<Object> stack) {
            stack.pop();
        }
    }
    ,
    CONNECTION("connection"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof JdbcServiceConfiguration)) {
                throw new CacheXmlException("jdbc <connection> elements must occur within <connector-service> elements");
            }
            ConnectorService.Connection connection = new ConnectorService.Connection();
            connection.setName(attributes.getValue("name"));
            connection.setUrl(attributes.getValue("url"));
            connection.setUser(attributes.getValue("user"));
            connection.setPassword(attributes.getValue("password"));
            connection.setParameters(this.parseParameters(attributes));
            stack.push(connection);
        }

        private String[] parseParameters(Attributes attributes) {
            String[] result = null;
            String value = attributes.getValue("parameters");
            if (value != null) {
                result = value.split(",");
            }
            return result;
        }

        @Override
        void endElement(Stack<Object> stack) {
            ConnectorService.Connection config = (ConnectorService.Connection)stack.pop();
            JdbcServiceConfiguration connectorService = (JdbcServiceConfiguration)stack.peek();
            connectorService.addConnectionConfig(config);
        }
    }
    ,
    REGION_MAPPING("region-mapping"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof JdbcServiceConfiguration)) {
                throw new CacheXmlException("jdbc <region-mapping> elements must occur within <connector-service> elements");
            }
            ConnectorService.RegionMapping mapping = new ConnectorService.RegionMapping();
            mapping.setRegionName(attributes.getValue("region"));
            mapping.setConnectionConfigName(attributes.getValue("connection-name"));
            mapping.setTableName(attributes.getValue("table"));
            mapping.setPdxClassName(attributes.getValue("pdx-class"));
            mapping.setPrimaryKeyInValue(Boolean.valueOf(attributes.getValue("primary-key-in-value")));
            stack.push(mapping);
        }

        @Override
        void endElement(Stack<Object> stack) {
            ConnectorService.RegionMapping mapping = (ConnectorService.RegionMapping)stack.pop();
            JdbcServiceConfiguration connectorService = (JdbcServiceConfiguration)stack.peek();
            connectorService.addRegionMapping(mapping);
        }
    }
    ,
    FIELD_MAPPING("field-mapping"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof ConnectorService.RegionMapping)) {
                throw new CacheXmlException("jdbc <field-mapping> elements must occur within <region-mapping> elements");
            }
            ConnectorService.RegionMapping mapping = (ConnectorService.RegionMapping)stack.peek();
            mapping.getFieldMapping().add(new ConnectorService.RegionMapping.FieldMapping(attributes.getValue("field-name"), attributes.getValue("column-name")));
        }

        @Override
        void endElement(Stack<Object> stack) {
        }
    };

    private String typeName;

    private ElementType(String typeName) {
        this.typeName = typeName;
    }

    static ElementType getTypeFromName(String typeName) {
        for (ElementType type : ElementType.values()) {
            if (!type.typeName.equals(typeName)) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid type '" + typeName + "'");
    }

    public String getTypeName() {
        return this.typeName;
    }

    abstract void startElement(Stack<Object> var1, Attributes var2);

    abstract void endElement(Stack<Object> var1);
}

