/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

@Experimental
public class DestroyMappingFunction
extends CliFunction<String> {
    public CliFunctionResult executeFunction(FunctionContext<String> context) {
        JdbcConnectorService service = FunctionContextArgumentProvider.getJdbcConnectorService(context);
        String regionName = (String)context.getArguments();
        String member = context.getMemberName();
        ConnectorService.RegionMapping mapping = service.getMappingForRegion(regionName);
        if (mapping != null) {
            service.destroyRegionMapping(regionName);
            String message = "Destroyed region mapping for region " + regionName + " on " + member;
            return new CliFunctionResult(member, true, message);
        }
        String message = "Region mapping for region \"" + regionName + "\" not found";
        return new CliFunctionResult(member, false, message);
    }
}

