/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.DestroyMappingFunction;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class DestroyMappingCommand
extends SingleGfshCommand {
    static final String DESTROY_MAPPING = "destroy jdbc-mapping";
    static final String DESTROY_MAPPING__HELP = "(Experimental) Destroy the specified mapping.";
    static final String DESTROY_MAPPING__REGION_NAME = "region";
    static final String DESTROY_MAPPING__REGION_NAME__HELP = "Name of the region mapping to destroy.";
    private static final String ERROR_PREFIX = "ERROR: ";

    @CliCommand(value={"destroy jdbc-mapping"}, help="(Experimental) Destroy the specified mapping.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel destroyMapping(@CliOption(key={"region"}, mandatory=true, help="Name of the region mapping to destroy.") String regionName) {
        Set targetMembers = this.getMembers(null, null);
        List results = this.executeAndGetFunctionResult((Function)new DestroyMappingFunction(), regionName, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult((List)results, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
        result.setConfigObject((Object)regionName);
        return result;
    }

    public void updateClusterConfig(String group, CacheConfig config, Object element) {
        ConnectorService service = (ConnectorService)config.findCustomCacheElement("connector-service", ConnectorService.class);
        if (service != null) {
            CacheElement.removeElement(service.getRegionMapping(), (String)((String)element));
        }
    }
}

