/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.configuration.ConnectorService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

@Experimental
public class DestroyConnectionFunction
extends CliFunction<String> {
    public CliFunctionResult executeFunction(FunctionContext<String> context) {
        String connectionName;
        JdbcConnectorService service = FunctionContextArgumentProvider.getJdbcConnectorService(context);
        ConnectorService.Connection connectionConfig = service.getConnectionConfig(connectionName = (String)context.getArguments());
        if (connectionConfig != null) {
            service.destroyConnectionConfig(connectionName);
            String message = "Destroyed JDBC connection \"" + connectionName + "\" on " + context.getMemberName();
            return new CliFunctionResult(context.getMemberName(), true, message);
        }
        String message = "Connection named \"" + connectionName + "\" not found";
        return new CliFunctionResult(context.getMemberName(), false, message);
    }
}

