/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.CacheCallback;
import org.apache.geode.cache.Operation;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.SqlHandler;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataManager;
import org.apache.geode.internal.cache.InternalCache;

@Experimental
public abstract class AbstractJdbcCallback
implements CacheCallback {
    private volatile SqlHandler sqlHandler;
    protected InternalCache cache;

    protected AbstractJdbcCallback() {
    }

    protected AbstractJdbcCallback(SqlHandler sqlHandler, InternalCache cache) {
        this.sqlHandler = sqlHandler;
        this.cache = cache;
    }

    public void close() {
        if (this.sqlHandler != null) {
            this.sqlHandler.close();
        }
    }

    protected SqlHandler getSqlHandler() {
        return this.sqlHandler;
    }

    protected void checkInitialized(InternalCache cache) {
        if (this.sqlHandler == null) {
            this.initialize(cache);
        }
    }

    protected boolean eventCanBeIgnored(Operation operation) {
        return operation.isLoad();
    }

    private synchronized void initialize(InternalCache cache) {
        if (this.sqlHandler == null) {
            this.cache = cache;
            JdbcConnectorService service = (JdbcConnectorService)cache.getService(JdbcConnectorService.class);
            TableMetaDataManager tableMetaDataManager = new TableMetaDataManager();
            this.sqlHandler = new SqlHandler(service.getDataSourceManager(), tableMetaDataManager, service);
        }
    }
}

