/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.geode.cache.Cache;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.xml.ElementType;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.internal.cache.xmlcache.XmlGenerator;
import org.apache.geode.internal.cache.xmlcache.XmlGeneratorUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JdbcConnectorServiceXmlGenerator
implements XmlGenerator<Cache> {
    public static final String PREFIX = "jdbc";
    private static final AttributesImpl EMPTY = new AttributesImpl();
    private final Collection<ConnectionConfiguration> connections;
    private final Collection<RegionMapping> mappings;

    public JdbcConnectorServiceXmlGenerator(Collection<ConnectionConfiguration> connections, Collection<RegionMapping> mappings) {
        this.connections = connections != null ? connections : Collections.emptyList();
        this.mappings = mappings != null ? mappings : Collections.emptyList();
    }

    public String getNamespaceUri() {
        return "http://geode.apache.org/schema/jdbc";
    }

    public void generate(CacheXmlGenerator cacheXmlGenerator) throws SAXException {
        ContentHandler handler = cacheXmlGenerator.getContentHandler();
        handler.startPrefixMapping(PREFIX, "http://geode.apache.org/schema/jdbc");
        AttributesImpl attributes = new AttributesImpl();
        XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"name", (Object)ElementType.CONNECTION_SERVICE.getTypeName());
        XmlGeneratorUtils.startElement((ContentHandler)handler, (String)PREFIX, (String)ElementType.CONNECTION_SERVICE.getTypeName(), (AttributesImpl)attributes);
        for (ConnectionConfiguration connection : this.connections) {
            this.outputConnectionConfiguration(handler, connection);
        }
        for (RegionMapping mapping : this.mappings) {
            this.outputRegionMapping(handler, mapping);
        }
        XmlGeneratorUtils.endElement((ContentHandler)handler, (String)PREFIX, (String)ElementType.CONNECTION_SERVICE.getTypeName());
    }

    Collection<ConnectionConfiguration> getConnections() {
        return this.connections;
    }

    Collection<RegionMapping> getMappings() {
        return this.mappings;
    }

    private void outputConnectionConfiguration(ContentHandler handler, ConnectionConfiguration config) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"name", (Object)config.getName());
        XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"url", (Object)config.getUrl());
        if (config.getUser() != null) {
            XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"user", (Object)config.getUser());
        }
        if (config.getPassword() != null) {
            XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"password", (Object)config.getPassword());
        }
        if (config.getParameters() != null) {
            XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"parameters", (Object)this.createParametersString(config));
        }
        XmlGeneratorUtils.emptyElement((ContentHandler)handler, (String)PREFIX, (String)ElementType.CONNECTION.getTypeName(), (AttributesImpl)attributes);
    }

    private void outputRegionMapping(ContentHandler handler, RegionMapping mapping) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"connection-name", (Object)mapping.getConnectionConfigName());
        XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"region", (Object)mapping.getRegionName());
        if (mapping.getTableName() != null) {
            XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"table", (Object)mapping.getTableName());
        }
        if (mapping.getPdxClassName() != null) {
            XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"pdx-class", (Object)mapping.getPdxClassName());
        }
        if (mapping.isPrimaryKeyInValue() != null) {
            XmlGeneratorUtils.addAttribute((AttributesImpl)attributes, (String)"primary-key-in-value", (Object)Boolean.toString(mapping.isPrimaryKeyInValue()));
        }
        XmlGeneratorUtils.startElement((ContentHandler)handler, (String)PREFIX, (String)ElementType.REGION_MAPPING.getTypeName(), (AttributesImpl)attributes);
        this.addFieldMappings(handler, mapping.getFieldToColumnMap());
        XmlGeneratorUtils.endElement((ContentHandler)handler, (String)PREFIX, (String)ElementType.REGION_MAPPING.getTypeName());
    }

    private void addFieldMappings(ContentHandler handler, Map<String, String> fieldMappings) throws SAXException {
        if (fieldMappings == null) {
            return;
        }
        for (Map.Entry<String, String> fieldMapping : fieldMappings.entrySet()) {
            AttributesImpl fieldAttributes = new AttributesImpl();
            XmlGeneratorUtils.addAttribute((AttributesImpl)fieldAttributes, (String)"field-name", (Object)fieldMapping.getKey());
            XmlGeneratorUtils.addAttribute((AttributesImpl)fieldAttributes, (String)"column-name", (Object)fieldMapping.getValue());
            XmlGeneratorUtils.emptyElement((ContentHandler)handler, (String)PREFIX, (String)ElementType.FIELD_MAPPING.getTypeName(), (AttributesImpl)fieldAttributes);
        }
    }

    private String createParametersString(ConnectionConfiguration config) {
        assert (config.getParameters() != null);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : config.getParameters().entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(entry.getKey()).append(":").append(entry.getValue());
        }
        return stringBuilder.toString();
    }
}

