/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.cli.DescribeConnectionFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class DescribeConnectionCommand
implements GfshCommand {
    static final String DESCRIBE_CONNECTION = "describe jdbc-connection";
    static final String DESCRIBE_CONNECTION__HELP = "(Experimental) Describe the specified jdbc connection.";
    static final String DESCRIBE_CONNECTION__NAME = "name";
    static final String DESCRIBE_CONNECTION__NAME__HELP = "Name of the jdbc connection to be described.";
    static final String OBSCURED_PASSWORD = "********";
    static final String RESULT_SECTION_NAME = "ConnectionDescription";

    @CliCommand(value={"describe jdbc-connection"}, help="(Experimental) Describe the specified jdbc connection.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result describeConnection(@CliOption(key={"name"}, mandatory=true, help="Name of the jdbc connection to be described.") String name) {
        Set members = this.getMembers(null, null);
        if (members.isEmpty()) {
            return ResultBuilder.createUserErrorResult((String)"No Members Found");
        }
        DistributedMember targetMember = (DistributedMember)members.iterator().next();
        ResultCollector<ConnectionConfiguration, List<ConnectionConfiguration>> resultCollector = this.execute(new DescribeConnectionFunction(), name, targetMember);
        ConnectionConfiguration config = (ConnectionConfiguration)((List)resultCollector.getResult()).get(0);
        if (config == null) {
            return ResultBuilder.createInfoResult((String)String.format("(Experimental) \nConnection named '%s' not found", name));
        }
        CompositeResultData resultData = ResultBuilder.createCompositeResultData();
        this.fillResultData(config, resultData);
        resultData.setHeader("(Experimental) ");
        return ResultBuilder.buildResult((ResultData)resultData);
    }

    ResultCollector<ConnectionConfiguration, List<ConnectionConfiguration>> execute(DescribeConnectionFunction function, String connectionName, DistributedMember targetMember) {
        return this.executeFunction(function, connectionName, targetMember);
    }

    private void fillResultData(ConnectionConfiguration config, CompositeResultData resultData) {
        CompositeResultData.SectionResultData sectionResult = resultData.addSection(RESULT_SECTION_NAME);
        sectionResult.addSeparator('-');
        sectionResult.addData(DESCRIBE_CONNECTION__NAME, (Object)config.getName());
        sectionResult.addData("url", (Object)config.getUrl());
        if (config.getUser() != null) {
            sectionResult.addData("user", (Object)config.getUser());
        }
        if (config.getPassword() != null) {
            sectionResult.addData("password", (Object)OBSCURED_PASSWORD);
        }
        TabularResultData tabularResultData = sectionResult.addTable("params");
        tabularResultData.setHeader("Additional connection parameters:");
        if (config.getParameters() != null) {
            config.getParameters().entrySet().forEach(entry -> {
                tabularResultData.accumulate("Param Name", entry.getKey());
                tabularResultData.accumulate("Value", entry.getValue());
            });
        }
    }
}

