/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import org.apache.geode.connectors.jdbc.internal.SqlToPdxInstance;
import org.apache.geode.connectors.jdbc.internal.configuration.FieldMapping;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.pdx.FieldType;
import org.apache.geode.pdx.PdxInstanceFactory;

public class SqlToPdxInstanceCreator {
    private final InternalCache cache;
    private final RegionMapping regionMapping;

    public SqlToPdxInstanceCreator(InternalCache cache, RegionMapping regionMapping) {
        this.cache = cache;
        this.regionMapping = regionMapping;
    }

    public SqlToPdxInstance create() {
        SqlToPdxInstance result = new SqlToPdxInstance();
        PdxInstanceFactory templateFactory = this.createPdxInstanceFactory();
        for (FieldMapping columnMapping : this.regionMapping.getFieldMappings()) {
            String columnName = columnMapping.getJdbcName();
            String fieldName = columnMapping.getPdxName();
            FieldType fieldType = FieldType.valueOf((String)columnMapping.getPdxType());
            result.addMapping(columnName, fieldName, fieldType);
            SqlToPdxInstanceCreator.writeField(templateFactory, columnMapping, fieldName, fieldType);
        }
        result.setPdxTemplate(templateFactory.create());
        return result;
    }

    private PdxInstanceFactory createPdxInstanceFactory() {
        String valueClassName = this.regionMapping.getPdxName();
        return this.cache.createPdxInstanceFactory(valueClassName);
    }

    public static void writeField(PdxInstanceFactory factory, FieldMapping columnMapping, String fieldName, FieldType fieldType) {
        switch (fieldType) {
            case STRING: {
                factory.writeString(fieldName, null);
                break;
            }
            case CHAR: {
                factory.writeChar(fieldName, '\u0000');
                break;
            }
            case SHORT: {
                factory.writeShort(fieldName, (short)0);
                break;
            }
            case INT: {
                factory.writeInt(fieldName, 0);
                break;
            }
            case LONG: {
                factory.writeLong(fieldName, 0L);
                break;
            }
            case FLOAT: {
                factory.writeFloat(fieldName, 0.0f);
                break;
            }
            case DOUBLE: {
                factory.writeDouble(fieldName, 0.0);
                break;
            }
            case BYTE: {
                factory.writeByte(fieldName, (byte)0);
                break;
            }
            case BOOLEAN: {
                factory.writeBoolean(fieldName, false);
                break;
            }
            case DATE: {
                factory.writeDate(fieldName, null);
                break;
            }
            case BYTE_ARRAY: {
                factory.writeByteArray(fieldName, null);
                break;
            }
            case BOOLEAN_ARRAY: {
                factory.writeBooleanArray(fieldName, null);
                break;
            }
            case CHAR_ARRAY: {
                factory.writeCharArray(fieldName, null);
                break;
            }
            case SHORT_ARRAY: {
                factory.writeShortArray(fieldName, null);
                break;
            }
            case INT_ARRAY: {
                factory.writeIntArray(fieldName, null);
                break;
            }
            case LONG_ARRAY: {
                factory.writeLongArray(fieldName, null);
                break;
            }
            case FLOAT_ARRAY: {
                factory.writeFloatArray(fieldName, null);
                break;
            }
            case DOUBLE_ARRAY: {
                factory.writeDoubleArray(fieldName, null);
                break;
            }
            case STRING_ARRAY: {
                factory.writeStringArray(fieldName, null);
                break;
            }
            case OBJECT_ARRAY: {
                factory.writeObjectArray(fieldName, null);
                break;
            }
            case ARRAY_OF_BYTE_ARRAYS: {
                factory.writeArrayOfByteArrays(fieldName, (byte[][])null);
                break;
            }
            case OBJECT: {
                factory.writeObject(fieldName, null);
                break;
            }
            default: {
                throw new IllegalStateException("unhandled pdx field type " + fieldType);
            }
        }
    }
}

