/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.ColumnData;
import org.apache.geode.connectors.jdbc.internal.EntryColumnData;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.SqlStatementFactory;
import org.apache.geode.connectors.jdbc.internal.SqlToPdxInstance;
import org.apache.geode.connectors.jdbc.internal.SqlToPdxInstanceCreator;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataManager;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;
import org.apache.geode.connectors.jdbc.internal.configuration.FieldMapping;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;

@Experimental
public class SqlHandler {
    private static final Logger logger = LogService.getLogger();
    private final InternalCache cache;
    private final RegionMapping regionMapping;
    private final DataSource dataSource;
    private final TableMetaDataView tableMetaData;
    private final Map<String, FieldMapping> pdxToFieldMappings = new HashMap<String, FieldMapping>();
    private volatile SqlToPdxInstance sqlToPdxInstance;

    public SqlHandler(InternalCache cache, String regionName, TableMetaDataManager tableMetaDataManager, JdbcConnectorService configService, DataSourceFactory dataSourceFactory) {
        this.cache = cache;
        this.regionMapping = SqlHandler.getMappingForRegion(configService, regionName);
        this.dataSource = SqlHandler.getDataSource(dataSourceFactory, this.regionMapping.getDataSourceName());
        this.tableMetaData = this.getTableMetaDataView(tableMetaDataManager);
        ((JdbcConnectorService)cache.getService(JdbcConnectorService.class)).validateMapping(this.regionMapping, this.dataSource);
        this.initializeFieldMappingMaps();
    }

    public SqlHandler(InternalCache cache, String regionName, TableMetaDataManager tableMetaDataManager, JdbcConnectorService configService) {
        this(cache, regionName, tableMetaDataManager, configService, dataSourceName -> JNDIInvoker.getDataSource((String)dataSourceName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TableMetaDataView getTableMetaDataView(TableMetaDataManager tableMetaDataManager) {
        try (Connection connection = this.getConnection();){
            TableMetaDataView tableMetaDataView = tableMetaDataManager.getTableMetaDataView(connection, this.regionMapping);
            return tableMetaDataView;
        }
        catch (SQLException ex) {
            throw new JdbcConnectorException("Could not connect to datasource \"" + this.regionMapping.getDataSourceName() + "\" because: " + ex);
        }
    }

    private static RegionMapping getMappingForRegion(JdbcConnectorService configService, String regionName) {
        RegionMapping regionMapping = configService.getMappingForRegion(regionName);
        if (regionMapping == null) {
            throw new JdbcConnectorException("JDBC mapping for region " + regionName + " not found. Create the mapping with the gfsh command 'create jdbc-mapping'.");
        }
        return regionMapping;
    }

    private static DataSource getDataSource(DataSourceFactory dataSourceFactory, String dataSourceName) {
        DataSource dataSource = dataSourceFactory.getDataSource(dataSourceName);
        if (dataSource == null) {
            throw new JdbcConnectorException("JDBC data-source named \"" + dataSourceName + "\" not found. Create it with gfsh 'create data-source --pooled --name=" + dataSourceName + "'.");
        }
        return dataSource;
    }

    private void initializeFieldMappingMaps() {
        for (FieldMapping fieldMapping : this.regionMapping.getFieldMappings()) {
            this.pdxToFieldMappings.put(fieldMapping.getPdxName(), fieldMapping);
        }
    }

    private String getColumnNameForField(String fieldName) {
        FieldMapping match = this.pdxToFieldMappings.get(fieldName);
        if (match != null) {
            return match.getJdbcName();
        }
        return null;
    }

    Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public <K, V> PdxInstance read(Region<K, V> region, K key) throws SQLException {
        PdxInstance result;
        if (key == null) {
            throw new IllegalArgumentException("Key for query cannot be null");
        }
        try (Connection connection = this.getConnection();){
            EntryColumnData entryColumnData = this.getEntryColumnData(this.tableMetaData, key, null, Operation.GET);
            try (PreparedStatement statement = this.getPreparedStatement(connection, this.tableMetaData, entryColumnData, Operation.GET);
                 ResultSet resultSet = this.executeReadQuery(statement, entryColumnData);){
                result = this.getSqlToPdxInstance().create(resultSet);
            }
        }
        return result;
    }

    private SqlToPdxInstance getSqlToPdxInstance() {
        SqlToPdxInstance result = this.sqlToPdxInstance;
        if (result == null) {
            result = this.initializeSqlToPdxInstance();
        }
        return result;
    }

    private synchronized SqlToPdxInstance initializeSqlToPdxInstance() {
        SqlToPdxInstance result;
        SqlToPdxInstanceCreator sqlToPdxInstanceCreator = new SqlToPdxInstanceCreator(this.cache, this.regionMapping);
        this.sqlToPdxInstance = result = sqlToPdxInstanceCreator.create();
        return result;
    }

    private ResultSet executeReadQuery(PreparedStatement statement, EntryColumnData entryColumnData) throws SQLException {
        this.setValuesInStatement(statement, entryColumnData, Operation.GET);
        return statement.executeQuery();
    }

    private void setValuesInStatement(PreparedStatement statement, EntryColumnData entryColumnData, Operation operation) throws SQLException {
        int index = 0;
        if (operation.isCreate() || operation.isUpdate()) {
            index = this.setValuesFromColumnData(statement, entryColumnData.getEntryValueColumnData(), index);
        }
        this.setValuesFromColumnData(statement, entryColumnData.getEntryKeyColumnData(), index);
    }

    private int setValuesFromColumnData(PreparedStatement statement, List<ColumnData> columnDataList, int index) throws SQLException {
        for (ColumnData columnData : columnDataList) {
            this.setValueOnStatement(statement, ++index, columnData);
        }
        return index;
    }

    private void setValueOnStatement(PreparedStatement statement, int index, ColumnData columnData) throws SQLException {
        Object value = columnData.getValue();
        if (value instanceof Character) {
            Character character = (Character)value;
            value = character.equals(Character.valueOf('\u0000')) ? null : character.toString();
        } else if (value instanceof java.util.Date) {
            java.util.Date jdkDate = (java.util.Date)value;
            switch (columnData.getDataType()) {
                case DATE: {
                    value = new Date(jdkDate.getTime());
                    break;
                }
                case TIME: 
                case TIME_WITH_TIMEZONE: {
                    value = new Time(jdkDate.getTime());
                    break;
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_TIMEZONE: {
                    value = new Timestamp(jdkDate.getTime());
                    break;
                }
            }
        }
        if (value == null) {
            statement.setNull(index, columnData.getDataType().getVendorTypeNumber());
        } else {
            statement.setObject(index, value);
        }
    }

    public <K, V> void write(Region<K, V> region, Operation operation, K key, PdxInstance value) throws SQLException {
        if (value == null && !operation.isDestroy()) {
            throw new IllegalArgumentException("PdxInstance cannot be null for non-destroy operations");
        }
        try (Connection connection = this.getConnection();){
            EntryColumnData entryColumnData = this.getEntryColumnData(this.tableMetaData, key, value, operation);
            int updateCount = 0;
            SQLException firstSqlEx = null;
            try (PreparedStatement statement = this.getPreparedStatement(connection, this.tableMetaData, entryColumnData, operation);){
                updateCount = this.executeWriteStatement(statement, entryColumnData, operation);
            }
            catch (SQLException e) {
                if (operation.isDestroy()) {
                    throw e;
                }
                firstSqlEx = e;
            }
            if (operation.isDestroy()) {
                return;
            }
            if (updateCount <= 0) {
                Operation upsertOp = this.getOppositeOperation(operation);
                try (PreparedStatement upsertStatement = this.getPreparedStatement(connection, this.tableMetaData, entryColumnData, upsertOp);){
                    updateCount = this.executeWriteStatement(upsertStatement, entryColumnData, operation);
                }
            }
            if (updateCount <= 0 && firstSqlEx != null) {
                throw firstSqlEx;
            }
            assert (updateCount == 1) : "expected 1 but updateCount was: " + updateCount;
        }
    }

    private Operation getOppositeOperation(Operation operation) {
        return operation.isUpdate() ? Operation.CREATE : Operation.UPDATE;
    }

    private int executeWriteStatement(PreparedStatement statement, EntryColumnData entryColumnData, Operation operation) throws SQLException {
        this.setValuesInStatement(statement, entryColumnData, operation);
        return statement.executeUpdate();
    }

    private PreparedStatement getPreparedStatement(Connection connection, TableMetaDataView tableMetaData, EntryColumnData entryColumnData, Operation operation) throws SQLException {
        String sqlStr = this.getSqlString(tableMetaData, entryColumnData, operation);
        if (logger.isDebugEnabled()) {
            logger.debug("Got SQL string:{} with key:{} value:{}", (Object)sqlStr, entryColumnData.getEntryKeyColumnData(), entryColumnData.getEntryValueColumnData());
        }
        return connection.prepareStatement(sqlStr);
    }

    private String getSqlString(TableMetaDataView tableMetaData, EntryColumnData entryColumnData, Operation operation) {
        SqlStatementFactory statementFactory = new SqlStatementFactory(tableMetaData.getIdentifierQuoteString());
        String tableName = tableMetaData.getQuotedTablePath();
        if (operation.isCreate()) {
            return statementFactory.createInsertSqlString(tableName, entryColumnData);
        }
        if (operation.isUpdate()) {
            return statementFactory.createUpdateSqlString(tableName, entryColumnData);
        }
        if (operation.isDestroy()) {
            return statementFactory.createDestroySqlString(tableName, entryColumnData);
        }
        if (operation.isGet()) {
            return statementFactory.createSelectQueryString(tableName, entryColumnData);
        }
        throw new InternalGemFireException("unsupported operation " + operation);
    }

    <K> EntryColumnData getEntryColumnData(TableMetaDataView tableMetaData, K key, PdxInstance value, Operation operation) {
        List<ColumnData> keyColumnData = this.createKeyColumnDataList(tableMetaData, key);
        List<ColumnData> valueColumnData = null;
        if (operation.isCreate() || operation.isUpdate()) {
            valueColumnData = this.createValueColumnDataList(tableMetaData, value);
        }
        return new EntryColumnData(keyColumnData, valueColumnData);
    }

    private <K> List<ColumnData> createKeyColumnDataList(TableMetaDataView tableMetaData, K key) {
        List<String> keyColumnNames = tableMetaData.getKeyColumnNames();
        ArrayList<ColumnData> result = new ArrayList<ColumnData>();
        if (keyColumnNames.size() == 1) {
            String keyColumnName = keyColumnNames.get(0);
            ColumnData columnData = new ColumnData(keyColumnName, key, tableMetaData.getColumnDataType(keyColumnName));
            result.add(columnData);
        } else {
            if (!(key instanceof PdxInstance)) {
                throw new JdbcConnectorException("The key \"" + key + "\" of class \"" + key.getClass().getName() + "\" must be a PdxInstance because multiple columns are configured as ids.");
            }
            PdxInstance compositeKey = (PdxInstance)key;
            if (compositeKey.isDeserializable()) {
                throw new JdbcConnectorException("The key \"" + key + "\" must be a PdxInstance created with PdxInstanceFactory.neverDeserialize");
            }
            List fieldNames = compositeKey.getFieldNames();
            if (fieldNames.size() != keyColumnNames.size()) {
                throw new JdbcConnectorException("The key \"" + key + "\" should have " + keyColumnNames.size() + " fields but has " + fieldNames.size() + " fields.");
            }
            for (String fieldName : fieldNames) {
                String columnName = this.getColumnNameForField(fieldName);
                if (columnName == null || !keyColumnNames.contains(columnName)) {
                    throw new JdbcConnectorException("The key \"" + key + "\" has the field \"" + fieldName + "\" which does not match any of the key columns: " + keyColumnNames);
                }
                ColumnData columnData = new ColumnData(columnName, compositeKey.getField(fieldName), tableMetaData.getColumnDataType(columnName));
                result.add(columnData);
            }
        }
        return result;
    }

    private List<ColumnData> createValueColumnDataList(TableMetaDataView tableMetaData, PdxInstance value) {
        ArrayList<ColumnData> result = new ArrayList<ColumnData>();
        for (String fieldName : value.getFieldNames()) {
            String columnName = this.getColumnNameForField(fieldName);
            if (columnName == null || tableMetaData.getKeyColumnNames().contains(columnName)) continue;
            ColumnData columnData = new ColumnData(columnName, value.getField(fieldName), tableMetaData.getColumnDataType(columnName));
            result.add(columnData);
        }
        return result;
    }

    public static interface DataSourceFactory {
        public DataSource getDataSource(String var1);
    }
}

