/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.util.DriverJarUtil;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

@Experimental
public class ListDriversFunction
extends CliFunction<Object[]> {
    ListDriversFunction() {
    }

    public CliFunctionResult executeFunction(FunctionContext<Object[]> context) {
        try {
            List driverNames = this.getDriverJarUtil().getRegisteredDriverNames();
            return new CliFunctionResult(context.getMemberName(), (Object)driverNames, this.createMessageFromDriversList(driverNames));
        }
        catch (Exception ex) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, ex.getMessage());
        }
    }

    DriverJarUtil getDriverJarUtil() {
        return new DriverJarUtil();
    }

    String createMessageFromDriversList(List<String> driverNames) {
        String message;
        if (driverNames.isEmpty()) {
            message = "No drivers found.";
        } else {
            message = "{" + driverNames.get(0);
            for (int i = 1; i < driverNames.size(); ++i) {
                message = message + ", ";
                message = message + driverNames.get(i);
            }
            message = message + "}";
        }
        return message;
    }
}

