/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.apache.geode.CopyHelper;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.asyncqueue.AsyncEvent;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.connectors.jdbc.internal.AbstractJdbcCallback;
import org.apache.geode.connectors.jdbc.internal.SqlHandler;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;

@Experimental
public class JdbcAsyncWriter
extends AbstractJdbcCallback
implements AsyncEventListener {
    private static final Logger logger = LogService.getLogger();
    private final LongAdder totalEvents = new LongAdder();
    private final LongAdder successfulEvents = new LongAdder();
    private final LongAdder failedEvents = new LongAdder();
    private final LongAdder ignoredEvents = new LongAdder();

    public JdbcAsyncWriter() {
    }

    JdbcAsyncWriter(SqlHandler sqlHandler, InternalCache cache) {
        super(sqlHandler, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processEvents(List<AsyncEvent> events) {
        this.changeTotalEvents(events.size());
        if (!events.isEmpty()) {
            try {
                this.checkInitialized(events.get(0).getRegion());
            }
            catch (RuntimeException ex) {
                this.changeFailedEvents(events.size());
                logger.error("Exception initializing JdbcAsyncWriter", (Throwable)ex);
                return true;
            }
        }
        Boolean initialPdxReadSerialized = this.cache.getPdxReadSerializedOverride();
        this.cache.setPdxReadSerializedOverride(true);
        try {
            for (AsyncEvent event : events) {
                if (this.eventCanBeIgnored(event.getOperation())) {
                    this.changeIgnoredEvents(1L);
                    continue;
                }
                try {
                    this.getSqlHandler().write(event.getRegion(), event.getOperation(), event.getKey(), this.getPdxInstance(event));
                    this.changeSuccessfulEvents(1L);
                }
                catch (RuntimeException | SQLException ex) {
                    this.changeFailedEvents(1L);
                    logger.error("Exception processing event {}", (Object)event, (Object)ex);
                }
            }
        }
        finally {
            this.cache.setPdxReadSerializedOverride(initialPdxReadSerialized.booleanValue());
        }
        return true;
    }

    long getTotalEvents() {
        return this.totalEvents.longValue();
    }

    long getSuccessfulEvents() {
        return this.successfulEvents.longValue();
    }

    long getFailedEvents() {
        return this.failedEvents.longValue();
    }

    long getIgnoredEvents() {
        return this.ignoredEvents.longValue();
    }

    private void changeSuccessfulEvents(long delta) {
        this.successfulEvents.add(delta);
    }

    private void changeFailedEvents(long delta) {
        this.failedEvents.add(delta);
    }

    private void changeTotalEvents(long delta) {
        this.totalEvents.add(delta);
    }

    private void changeIgnoredEvents(long delta) {
        this.ignoredEvents.add(delta);
    }

    private PdxInstance getPdxInstance(AsyncEvent event) {
        Object value = event.getDeserializedValue();
        if (!(value instanceof PdxInstance)) {
            value = CopyHelper.copy((Object)value);
        }
        return (PdxInstance)value;
    }
}

