/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.concurrency.loop;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.geode.test.concurrency.ParallelExecutor;
import org.apache.geode.test.concurrency.Runner;
import org.apache.geode.test.concurrency.loop.LoopRunnerConfig;

public class LoopRunner
implements Runner {
    private static final int DEFAULT_COUNT = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Throwable> runTestMethod(Method child) {
        int count = this.getCount(child);
        ExecutorService executorService = Executors.newCachedThreadPool();
        try {
            DelegatingExecutor executor = new DelegatingExecutor(executorService);
            for (int i = 0; i < count; ++i) {
                try {
                    Object test = child.getDeclaringClass().newInstance();
                    child.invoke(test, executor);
                    continue;
                }
                catch (Exception e) {
                    List<Throwable> list = Collections.singletonList(e);
                    executorService.shutdown();
                    return list;
                }
            }
        }
        finally {
            executorService.shutdown();
        }
        return Collections.emptyList();
    }

    private int getCount(Method child) {
        LoopRunnerConfig config = child.getDeclaringClass().getAnnotation(LoopRunnerConfig.class);
        if (config == null) {
            return 1000;
        }
        return config.count();
    }

    private static class DelegatingExecutor
    implements ParallelExecutor {
        private final ExecutorService executorService;
        List<Future<?>> futures;

        public DelegatingExecutor(ExecutorService executorService) {
            this.executorService = executorService;
            this.futures = new ArrayList();
        }

        @Override
        public <T> Future<T> inParallel(Callable<T> callable) {
            Future<T> future = this.executorService.submit(callable);
            this.futures.add(future);
            return future;
        }

        @Override
        public void execute() throws ExecutionException, InterruptedException {
            for (Future<?> future : this.futures) {
                future.get();
            }
        }
    }
}

