/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer.kotlin;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.fury.Fury;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.type.Type;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0011\u001a\u00028\u00012\u0006\u0010\u0012\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u000b\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00018\u0001 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00018\u0001\u0018\u00010\u00030\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/apache/fury/serializer/kotlin/AbstractDelegatingArraySerializer;", "T", "T_Delegate", "Lorg/apache/fury/serializer/Serializer;", "fury", "Lorg/apache/fury/Fury;", "cls", "Ljava/lang/Class;", "delegateClass", "<init>", "(Lorg/apache/fury/Fury;Ljava/lang/Class;Ljava/lang/Class;)V", "delegatingSerializer", "kotlin.jvm.PlatformType", "getDelegatingSerializer", "()Lorg/apache/fury/serializer/Serializer;", "delegatingSerializer$delegate", "Lkotlin/Lazy;", "toDelegateClass", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "fromDelegateClass", "getXtypeId", "", "xwrite", "", "buffer", "Lorg/apache/fury/memory/MemoryBuffer;", "(Lorg/apache/fury/memory/MemoryBuffer;Ljava/lang/Object;)V", "xread", "(Lorg/apache/fury/memory/MemoryBuffer;)Ljava/lang/Object;", "write", "read", "fury-kotlin"})
public abstract class AbstractDelegatingArraySerializer<T, T_Delegate>
extends Serializer<T> {
    @NotNull
    private final Class<T_Delegate> delegateClass;
    @NotNull
    private final Lazy delegatingSerializer$delegate;

    public AbstractDelegatingArraySerializer(@NotNull Fury fury, @NotNull Class<T> cls, @NotNull Class<T_Delegate> delegateClass) {
        Intrinsics.checkNotNullParameter((Object)fury, (String)"fury");
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter(delegateClass, (String)"delegateClass");
        super(fury, cls);
        this.delegateClass = delegateClass;
        this.delegatingSerializer$delegate = LazyKt.lazy(() -> AbstractDelegatingArraySerializer.delegatingSerializer_delegate$lambda$0(fury, this));
    }

    private final Serializer<T_Delegate> getDelegatingSerializer() {
        Lazy lazy = this.delegatingSerializer$delegate;
        return (Serializer)lazy.getValue();
    }

    protected abstract T_Delegate toDelegateClass(T var1);

    protected abstract T fromDelegateClass(T_Delegate var1);

    public short getXtypeId() {
        return -Type.LIST.getId();
    }

    public void xwrite(@NotNull MemoryBuffer buffer, T value) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.write(buffer, value);
    }

    public T xread(@NotNull MemoryBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.read(buffer);
    }

    public void write(@NotNull MemoryBuffer buffer, T value) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.getDelegatingSerializer().write(buffer, this.toDelegateClass(value));
    }

    public T read(@NotNull MemoryBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Object delegatedValue = this.getDelegatingSerializer().read(buffer);
        return this.fromDelegateClass(delegatedValue);
    }

    private static final Serializer delegatingSerializer_delegate$lambda$0(Fury $fury, AbstractDelegatingArraySerializer this$0) {
        return $fury.getClassResolver().getSerializer(this$0.delegateClass);
    }
}

