/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import org.apache.fury.Fury;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.serializer.Serializer;

public class ByteStringSerializer
extends Serializer<ByteString> {
    public ByteStringSerializer(Fury fury, Class<ByteString> type) {
        super(fury, type);
    }

    public void write(MemoryBuffer buffer, ByteString value) {
        int size = value.size();
        buffer.writeVarUint32(size);
        buffer.grow(size);
        byte[] heapMemory = buffer.getHeapMemory();
        if (heapMemory != null) {
            int writerIndex = buffer._unsafeHeapWriterIndex();
            value.copyTo(heapMemory, writerIndex);
        } else {
            value.copyTo(buffer.sliceAsByteBuffer(buffer.writerIndex(), size));
        }
        buffer.increaseWriterIndex(size);
    }

    public ByteString read(MemoryBuffer buffer) {
        int size = buffer.readVarUint32Small14();
        buffer.checkReadableBytes(size);
        byte[] heapMemory = buffer.getHeapMemory();
        if (heapMemory != null) {
            ByteString bytes = ByteString.copyFrom((byte[])heapMemory, (int)buffer._unsafeHeapReaderIndex(), (int)size);
            buffer.increaseReaderIndex(size);
            return bytes;
        }
        ByteString bytes = ByteString.copyFrom((ByteBuffer)buffer.sliceAsByteBuffer(buffer.readerIndex(), size));
        buffer.increaseReaderIndex(size);
        return bytes;
    }
}

