/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.meta;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdException;
import java.util.Arrays;
import org.apache.fury.meta.MetaCompressor;

public class ZstdMetaCompressor
implements MetaCompressor {
    public byte[] compress(byte[] data, int offset, int size) {
        long maxCompressedSize = Zstd.compressBound((long)size);
        if (maxCompressedSize > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        byte[] compressedData = new byte[(int)maxCompressedSize];
        long originalSize = Zstd.compressByteArray((byte[])compressedData, (int)0, (int)((int)maxCompressedSize), (byte[])data, (int)offset, (int)size, (int)Zstd.defaultCompressionLevel());
        return Arrays.copyOf(compressedData, (int)originalSize);
    }

    public byte[] decompress(byte[] data, int offset, int size) {
        int decompressedSize = (int)Zstd.getFrameContentSize((byte[])data, (int)offset, (int)size, (boolean)false);
        byte[] decompressedBytes = new byte[decompressedSize];
        long originalSize = Zstd.decompressByteArray((byte[])decompressedBytes, (int)0, (int)decompressedSize, (byte[])data, (int)offset, (int)size);
        return Arrays.copyOf(decompressedBytes, (int)originalSize);
    }

    public int hashCode() {
        return ZstdMetaCompressor.class.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }
}

